/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.zeroturnaround.zip.ZTFilePermissions;
import org.zeroturnaround.zip.ZTFilePermissionsUtil;
import org.zeroturnaround.zip.ZipException;
import org.zeroturnaround.zip.commons.IOUtils;
import org.zeroturnaround.zip.extra.AsiExtraField;
import org.zeroturnaround.zip.extra.ExtraFieldUtils;
import org.zeroturnaround.zip.extra.ZipExtraField;
import org.zeroturnaround.zip.timestamps.TimestampStrategyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ZipEntryUtil {
    private ZipEntryUtil() {
    }

    static ZipEntry copy(ZipEntry original) {
        return ZipEntryUtil.copy(original, null);
    }

    static ZipEntry copy(ZipEntry original, String newName) {
        ZipEntry copy = new ZipEntry(newName == null ? original.getName() : newName);
        if (original.getCrc() != -1L) {
            copy.setCrc(original.getCrc());
        }
        if (original.getMethod() != -1) {
            copy.setMethod(original.getMethod());
        }
        if (original.getSize() >= 0L) {
            copy.setSize(original.getSize());
        }
        if (original.getExtra() != null) {
            copy.setExtra(original.getExtra());
        }
        copy.setComment(original.getComment());
        copy.setTime(original.getTime());
        return copy;
    }

    static void copyEntry(ZipEntry zipEntry, InputStream in, ZipOutputStream out) throws IOException {
        ZipEntryUtil.copyEntry(zipEntry, in, out, true);
    }

    static void copyEntry(ZipEntry originalEntry, InputStream in, ZipOutputStream out, boolean preserveTimestamps) throws IOException {
        ZipEntry copy = ZipEntryUtil.copy(originalEntry);
        if (preserveTimestamps) {
            TimestampStrategyFactory.getInstance().setTime(copy, originalEntry);
        } else {
            copy.setTime(System.currentTimeMillis());
        }
        ZipEntryUtil.addEntry(copy, new BufferedInputStream(in), out);
    }

    static void addEntry(ZipEntry zipEntry, InputStream in, ZipOutputStream out) throws IOException {
        out.putNextEntry(zipEntry);
        if (in != null) {
            IOUtils.copy(in, out);
        }
        out.closeEntry();
    }

    static ZipEntry fromFile(String name, File file) {
        ZipEntry zipEntry = new ZipEntry(name);
        if (!file.isDirectory()) {
            zipEntry.setSize(file.length());
        }
        zipEntry.setTime(file.lastModified());
        ZTFilePermissions permissions = ZTFilePermissionsUtil.getDefaultStategy().getPermissions(file);
        if (permissions != null) {
            ZipEntryUtil.setZTFilePermissions(zipEntry, permissions);
        }
        return zipEntry;
    }

    static boolean setZTFilePermissions(ZipEntry zipEntry, ZTFilePermissions permissions) {
        try {
            List<ZipExtraField> fields = ExtraFieldUtils.parse(zipEntry.getExtra());
            AsiExtraField asiExtraField = ZipEntryUtil.getFirstAsiExtraField(fields);
            if (asiExtraField == null) {
                asiExtraField = new AsiExtraField();
                fields.add(asiExtraField);
            }
            asiExtraField.setDirectory(zipEntry.isDirectory());
            asiExtraField.setMode(ZTFilePermissionsUtil.toPosixFileMode(permissions));
            zipEntry.setExtra(ExtraFieldUtils.mergeLocalFileDataData(fields));
            return true;
        }
        catch (java.util.zip.ZipException ze) {
            return false;
        }
    }

    static ZTFilePermissions getZTFilePermissions(ZipEntry zipEntry) {
        try {
            ZTFilePermissions permissions = null;
            List<ZipExtraField> fields = ExtraFieldUtils.parse(zipEntry.getExtra());
            AsiExtraField asiExtraField = ZipEntryUtil.getFirstAsiExtraField(fields);
            if (asiExtraField != null) {
                int mode = asiExtraField.getMode() & 0x1FF;
                permissions = ZTFilePermissionsUtil.fromPosixFileMode(mode);
            }
            return permissions;
        }
        catch (java.util.zip.ZipException ze) {
            throw new ZipException(ze);
        }
    }

    private static AsiExtraField getFirstAsiExtraField(List<ZipExtraField> fields) {
        AsiExtraField asiExtraField = null;
        for (ZipExtraField field2 : fields) {
            if (!(field2 instanceof AsiExtraField)) continue;
            asiExtraField = (AsiExtraField)field2;
        }
        return asiExtraField;
    }
}

