/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.ZipEntryUtil;

public class FileSource
implements ZipEntrySource {
    private final String path;
    private final File file;

    public FileSource(String path, File file) {
        this.path = path;
        this.file = file;
    }

    public String getPath() {
        return this.path;
    }

    public ZipEntry getEntry() {
        ZipEntry entry2 = ZipEntryUtil.fromFile(this.path, this.file);
        return entry2;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file.isDirectory()) {
            return null;
        }
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public String toString() {
        return "FileSource[" + this.path + ", " + this.file + "]";
    }

    public static FileSource[] pair(File[] files, String[] names) {
        if (files.length > names.length) {
            throw new IllegalArgumentException("names array must contain at least the same amount of items as files array or more");
        }
        FileSource[] result2 = new FileSource[files.length];
        for (int i = 0; i < files.length; ++i) {
            result2[i] = new FileSource(names[i], files[i]);
        }
        return result2;
    }
}

