/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.matchers;

import java.util.Map;
import javax.xml.transform.Source;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.w3c.dom.Node;
import org.xmlunit.builder.Input;
import org.xmlunit.util.Convert;
import org.xmlunit.xpath.JAXPXPathEngine;

public class EvaluateXPathMatcher
extends BaseMatcher<Object> {
    private final String xPath;
    private final Matcher<String> valueMatcher;
    private Map<String, String> prefix2Uri;

    public EvaluateXPathMatcher(String xPath, Matcher<String> valueMatcher) {
        this.xPath = xPath;
        this.valueMatcher = valueMatcher;
    }

    @Factory
    public static EvaluateXPathMatcher hasXPath(String xPath, Matcher<String> valueMatcher) {
        return new EvaluateXPathMatcher(xPath, valueMatcher);
    }

    @Override
    public boolean matches(Object object) {
        String value2 = this.xPathEvaluate(object);
        return this.valueMatcher.matches(value2);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("XML with XPath ").appendText(this.xPath);
        if (this.valueMatcher != null) {
            description.appendText(" evaluated to ").appendDescriptionOf(this.valueMatcher);
        }
    }

    @Override
    public void describeMismatch(Object object, Description mismatchDescription) {
        if (this.valueMatcher != null) {
            String value2 = this.xPathEvaluate(object);
            this.valueMatcher.describeMismatch(value2, mismatchDescription);
        }
    }

    public EvaluateXPathMatcher withNamespaceContext(Map<String, String> prefix2Uri) {
        this.prefix2Uri = prefix2Uri;
        return this;
    }

    private String xPathEvaluate(Object input2) {
        JAXPXPathEngine engine = new JAXPXPathEngine();
        if (this.prefix2Uri != null) {
            engine.setNamespaceContext(this.prefix2Uri);
        }
        Source s2 = Input.from(input2).build();
        Node n = Convert.toNode(s2);
        return engine.evaluate(this.xPath, n);
    }
}

