/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;
import org.xmlunit.diff.XPathContext;
import org.xmlunit.util.Mapper;

class ChildNodeXPathContextProvider
implements Mapper<Node, XPathContext> {
    private final XPathContext xpathContext;
    private final Map<Node, Integer> childIndex;

    ChildNodeXPathContextProvider(XPathContext parentContext, Iterable<Node> children) {
        this.xpathContext = parentContext.clone();
        HashMap<Node, Integer> index2 = new HashMap<Node, Integer>();
        int i = 0;
        for (Node n : children) {
            index2.put(n, i++);
        }
        this.childIndex = Collections.unmodifiableMap(index2);
    }

    @Override
    public XPathContext apply(Node n) {
        XPathContext ctx = this.xpathContext.clone();
        Integer idx = this.childIndex.get(n);
        if (idx == null) {
            throw new NoSuchElementException(n + " is not a known child node");
        }
        ctx.navigateToChild(idx);
        return ctx;
    }
}

