/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class RequestParamMapMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        RequestParam requestParamAnnot = parameter.getParameterAnnotation(RequestParam.class);
        if (requestParamAnnot != null && Map.class.isAssignableFrom(parameter.getParameterType())) {
            return !StringUtils.hasText(requestParamAnnot.value());
        }
        return false;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Class<?> paramType = parameter.getParameterType();
        Map<String, String[]> parameterMap = webRequest.getParameterMap();
        if (MultiValueMap.class.isAssignableFrom(paramType)) {
            LinkedMultiValueMap<String, String> result2 = new LinkedMultiValueMap<String, String>(parameterMap.size());
            for (Map.Entry<String, String[]> entry2 : parameterMap.entrySet()) {
                for (String value2 : entry2.getValue()) {
                    result2.add(entry2.getKey(), value2);
                }
            }
            return result2;
        }
        LinkedHashMap<String, String> result3 = new LinkedHashMap<String, String>(parameterMap.size());
        for (Map.Entry<String, String[]> entry3 : parameterMap.entrySet()) {
            if (entry3.getValue().length <= 0) continue;
            result3.put(entry3.getKey(), entry3.getValue()[0]);
        }
        return result3;
    }
}

