/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request.async;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.Assert;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.async.AsyncWebRequest;

public class StandardServletAsyncWebRequest
extends ServletWebRequest
implements AsyncWebRequest,
AsyncListener {
    private Long timeout;
    private AsyncContext asyncContext;
    private AtomicBoolean asyncCompleted = new AtomicBoolean(false);
    private final List<Runnable> timeoutHandlers = new ArrayList<Runnable>();
    private final List<Runnable> completionHandlers = new ArrayList<Runnable>();

    public StandardServletAsyncWebRequest(HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
    }

    public void setTimeout(Long timeout) {
        Assert.state(!this.isAsyncStarted(), "Cannot change the timeout with concurrent handling in progress");
        this.timeout = timeout;
    }

    public void addTimeoutHandler(Runnable timeoutHandler) {
        this.timeoutHandlers.add(timeoutHandler);
    }

    public void addCompletionHandler(Runnable runnable) {
        this.completionHandlers.add(runnable);
    }

    public boolean isAsyncStarted() {
        return this.asyncContext != null && this.getRequest().isAsyncStarted();
    }

    public boolean isAsyncComplete() {
        return this.asyncCompleted.get();
    }

    public void startAsync() {
        Assert.state(this.getRequest().isAsyncSupported(), "Async support must be enabled on a servlet and for all filters involved in async request processing. This is done in Java code using the Servlet API or by adding \"<async-supported>true</async-supported>\" to servlet and filter declarations in web.xml.");
        Assert.state(!this.isAsyncComplete(), "Async processing has already completed");
        if (this.isAsyncStarted()) {
            return;
        }
        this.asyncContext = this.getRequest().startAsync(this.getRequest(), this.getResponse());
        this.asyncContext.addListener((AsyncListener)this);
        if (this.timeout != null) {
            this.asyncContext.setTimeout(this.timeout.longValue());
        }
    }

    public void dispatch() {
        Assert.notNull(this.asyncContext, "Cannot dispatch without an AsyncContext");
        this.asyncContext.dispatch();
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
    }

    public void onError(AsyncEvent event) throws IOException {
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        for (Runnable handler : this.timeoutHandlers) {
            handler.run();
        }
    }

    public void onComplete(AsyncEvent event) throws IOException {
        for (Runnable handler : this.completionHandlers) {
            handler.run();
        }
        this.asyncContext = null;
        this.asyncCompleted.set(true);
    }
}

