/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.util.RequestMatcher;
import org.springframework.util.StringUtils;

public final class RegexRequestMatcher
implements RequestMatcher {
    private static final Log logger = LogFactory.getLog(RegexRequestMatcher.class);
    private final Pattern pattern;
    private final HttpMethod httpMethod;

    public RegexRequestMatcher(String pattern, String httpMethod) {
        this(pattern, httpMethod, false);
    }

    public RegexRequestMatcher(String pattern, String httpMethod, boolean caseInsensitive) {
        this.pattern = caseInsensitive ? Pattern.compile(pattern, 2) : Pattern.compile(pattern);
        this.httpMethod = StringUtils.hasText(httpMethod) ? HttpMethod.valueOf(httpMethod) : null;
    }

    public boolean matches(HttpServletRequest request) {
        if (this.httpMethod != null && request.getMethod() != null && this.httpMethod != HttpMethod.valueOf(request.getMethod())) {
            return false;
        }
        String url = request.getServletPath();
        String pathInfo = request.getPathInfo();
        String query = request.getQueryString();
        if (pathInfo != null || query != null) {
            StringBuilder sb = new StringBuilder(url);
            if (pathInfo != null) {
                sb.append(pathInfo);
            }
            if (query != null) {
                sb.append('?').append(query);
            }
            url = sb.toString();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking match of request : '" + url + "'; against '" + this.pattern + "'"));
        }
        return this.pattern.matcher(url).matches();
    }
}

