/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.jaasapi.JaasApiIntegrationFilter;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;
import org.springframework.security.web.session.SessionManagementFilter;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFilterChainValidator
implements FilterChainProxy.FilterChainValidator {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void validate(FilterChainProxy fcp) {
        for (SecurityFilterChain filterChain : fcp.getFilterChains()) {
            this.checkLoginPageIsntProtected(fcp, filterChain.getFilters());
            this.checkFilterStack(filterChain.getFilters());
        }
        this.checkPathOrder(new ArrayList<SecurityFilterChain>(fcp.getFilterChains()));
        this.checkForDuplicateMatchers(new ArrayList<SecurityFilterChain>(fcp.getFilterChains()));
    }

    private void checkPathOrder(List<SecurityFilterChain> filterChains) {
        Iterator<SecurityFilterChain> chains = filterChains.iterator();
        while (chains.hasNext()) {
            RequestMatcher matcher = ((DefaultSecurityFilterChain)chains.next()).getRequestMatcher();
            if (!AnyRequestMatcher.INSTANCE.equals(matcher) || !chains.hasNext()) continue;
            throw new IllegalArgumentException("A universal match pattern ('/**') is defined  before other patterns in the filter chain, causing them to be ignored. Please check the ordering in your <security:http> namespace or FilterChainProxy bean configuration");
        }
    }

    private void checkForDuplicateMatchers(List<SecurityFilterChain> chains) {
        while (chains.size() > 1) {
            DefaultSecurityFilterChain chain2 = (DefaultSecurityFilterChain)chains.remove(0);
            for (SecurityFilterChain test : chains) {
                if (!chain2.getRequestMatcher().equals(((DefaultSecurityFilterChain)test).getRequestMatcher())) continue;
                throw new IllegalArgumentException("The FilterChainProxy contains two filter chains using the matcher " + chain2.getRequestMatcher() + ". If you are using multiple <http> namespace " + "elements, you must use a 'pattern' attribute to define the request patterns to which they apply.");
            }
        }
    }

    private <F extends Filter> F getFilter(Class<F> type, List<Filter> filters) {
        for (Filter f : filters) {
            if (!type.isAssignableFrom(f.getClass())) continue;
            return (F)f;
        }
        return null;
    }

    private void checkFilterStack(List<Filter> filters) {
        this.checkForDuplicates(SecurityContextPersistenceFilter.class, filters);
        this.checkForDuplicates(UsernamePasswordAuthenticationFilter.class, filters);
        this.checkForDuplicates(SessionManagementFilter.class, filters);
        this.checkForDuplicates(BasicAuthenticationFilter.class, filters);
        this.checkForDuplicates(SecurityContextHolderAwareRequestFilter.class, filters);
        this.checkForDuplicates(JaasApiIntegrationFilter.class, filters);
        this.checkForDuplicates(ExceptionTranslationFilter.class, filters);
        this.checkForDuplicates(FilterSecurityInterceptor.class, filters);
    }

    private void checkForDuplicates(Class<? extends Filter> clazz, List<Filter> filters) {
        for (int i = 0; i < filters.size(); ++i) {
            Filter f1 = filters.get(i);
            if (!clazz.isAssignableFrom(f1.getClass())) continue;
            for (int j = i + 1; j < filters.size(); ++j) {
                Filter f2 = filters.get(j);
                if (!clazz.isAssignableFrom(f2.getClass())) continue;
                this.logger.warn((Object)("Possible error: Filters at position " + i + " and " + j + " are both " + "instances of " + clazz.getName()));
                return;
            }
        }
    }

    private void checkLoginPageIsntProtected(FilterChainProxy fcp, List<Filter> filterStack) {
        ExceptionTranslationFilter etf = this.getFilter(ExceptionTranslationFilter.class, filterStack);
        if (etf == null || !(etf.getAuthenticationEntryPoint() instanceof LoginUrlAuthenticationEntryPoint)) {
            return;
        }
        String loginPage = ((LoginUrlAuthenticationEntryPoint)etf.getAuthenticationEntryPoint()).getLoginFormUrl();
        this.logger.info((Object)("Checking whether login URL '" + loginPage + "' is accessible with your configuration"));
        FilterInvocation loginRequest = new FilterInvocation(loginPage, "POST");
        List<Filter> filters = null;
        try {
            filters = fcp.getFilters(loginPage);
        }
        catch (Exception e) {
            this.logger.info((Object)"Failed to obtain filter chain information for the login page. Unable to complete check.");
        }
        if (filters == null || filters.isEmpty()) {
            this.logger.debug((Object)"Filter chain is empty for the login page");
            return;
        }
        if (this.getFilter(DefaultLoginPageGeneratingFilter.class, filters) != null) {
            this.logger.debug((Object)"Default generated login page is in use");
            return;
        }
        FilterSecurityInterceptor fsi = this.getFilter(FilterSecurityInterceptor.class, filters);
        FilterInvocationSecurityMetadataSource fids = fsi.getSecurityMetadataSource();
        Collection<ConfigAttribute> attributes = fids.getAttributes(loginRequest);
        if (attributes == null) {
            this.logger.debug((Object)"No access attributes defined for login page URL");
            if (fsi.isRejectPublicInvocations()) {
                this.logger.warn((Object)"FilterSecurityInterceptor is configured to reject public invocations. Your login page may not be accessible.");
            }
            return;
        }
        AnonymousAuthenticationFilter anonPF = this.getFilter(AnonymousAuthenticationFilter.class, filters);
        if (anonPF == null) {
            this.logger.warn((Object)"The login page is being protected by the filter chain, but you don't appear to have anonymous authentication enabled. This is almost certainly an error.");
            return;
        }
        AnonymousAuthenticationToken token2 = new AnonymousAuthenticationToken("key", anonPF.getPrincipal(), anonPF.getAuthorities());
        try {
            fsi.getAccessDecisionManager().decide(token2, loginRequest, attributes);
        }
        catch (AccessDeniedException e) {
            this.logger.warn((Object)("Anonymous access to the login page doesn't appear to be enabled. This is almost certainly an error. Please check your configuration allows unauthenticated access to the configured login page. (Simulated access was rejected: " + e + ")"));
        }
        catch (Exception e) {
            this.logger.info((Object)"Unable to check access to the login page to determine if anonymous access is allowed. This might be an error, but can happen under normal circumstances.", (Throwable)e);
        }
    }
}

