/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import javax.naming.NamingException;
import org.springframework.core.env.PropertySource;
import org.springframework.jndi.JndiLocatorDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiPropertySource
extends PropertySource<JndiLocatorDelegate> {
    public JndiPropertySource(String name) {
        this(name, JndiLocatorDelegate.createDefaultResourceRefLocator());
    }

    public JndiPropertySource(String name, JndiLocatorDelegate jndiLocator) {
        super(name, jndiLocator);
    }

    @Override
    public Object getProperty(String name) {
        try {
            Object value2 = ((JndiLocatorDelegate)this.source).lookup(name);
            this.logger.debug((Object)("JNDI lookup for name [" + name + "] returned: [" + value2 + "]"));
            return value2;
        }
        catch (NamingException ex) {
            this.logger.debug((Object)("JNDI lookup for name [" + name + "] threw NamingException " + "with message: " + ex.getMessage() + ". Returning null."));
            return null;
        }
    }
}

