/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.security.AccessControlException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.MissingRequiredPropertiesException;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.env.ReadOnlySystemAttributesMap;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnvironment
implements ConfigurableEnvironment {
    public static final String ACTIVE_PROFILES_PROPERTY_NAME = "spring.profiles.active";
    public static final String DEFAULT_PROFILES_PROPERTY_NAME = "spring.profiles.default";
    protected static final String RESERVED_DEFAULT_PROFILE_NAME = "default";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Set<String> activeProfiles = new LinkedHashSet<String>();
    private Set<String> defaultProfiles = new LinkedHashSet<String>(this.getReservedDefaultProfiles());
    private final MutablePropertySources propertySources = new MutablePropertySources(this.logger);
    private final ConfigurablePropertyResolver propertyResolver = new PropertySourcesPropertyResolver(this.propertySources);

    public AbstractEnvironment() {
        String name = this.getClass().getSimpleName();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Initializing new %s", name));
        }
        this.customizePropertySources(this.propertySources);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Initialized %s with PropertySources %s", name, this.propertySources));
        }
    }

    protected void customizePropertySources(MutablePropertySources propertySources) {
    }

    protected Set<String> getReservedDefaultProfiles() {
        return Collections.singleton(RESERVED_DEFAULT_PROFILE_NAME);
    }

    @Override
    public String[] getActiveProfiles() {
        return StringUtils.toStringArray(this.doGetActiveProfiles());
    }

    protected Set<String> doGetActiveProfiles() {
        String profiles;
        if (this.activeProfiles.isEmpty() && StringUtils.hasText(profiles = this.getProperty(ACTIVE_PROFILES_PROPERTY_NAME))) {
            this.setActiveProfiles(StringUtils.commaDelimitedListToStringArray(StringUtils.trimAllWhitespace(profiles)));
        }
        return this.activeProfiles;
    }

    @Override
    public void setActiveProfiles(String ... profiles) {
        Assert.notNull(profiles, "Profile array must not be null");
        this.activeProfiles.clear();
        for (String profile : profiles) {
            this.validateProfile(profile);
            this.activeProfiles.add(profile);
        }
    }

    @Override
    public void addActiveProfile(String profile) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Activating profile '%s'", profile));
        }
        this.validateProfile(profile);
        this.doGetActiveProfiles();
        this.activeProfiles.add(profile);
    }

    @Override
    public String[] getDefaultProfiles() {
        return StringUtils.toStringArray(this.doGetDefaultProfiles());
    }

    protected Set<String> doGetDefaultProfiles() {
        String profiles;
        if (this.defaultProfiles.equals(this.getReservedDefaultProfiles()) && StringUtils.hasText(profiles = this.getProperty(DEFAULT_PROFILES_PROPERTY_NAME))) {
            this.setDefaultProfiles(StringUtils.commaDelimitedListToStringArray(StringUtils.trimAllWhitespace(profiles)));
        }
        return this.defaultProfiles;
    }

    @Override
    public void setDefaultProfiles(String ... profiles) {
        Assert.notNull(profiles, "Profile array must not be null");
        this.defaultProfiles.clear();
        for (String profile : profiles) {
            this.validateProfile(profile);
            this.defaultProfiles.add(profile);
        }
    }

    @Override
    public boolean acceptsProfiles(String ... profiles) {
        Assert.notEmpty(profiles, "Must specify at least one profile");
        for (String profile : profiles) {
            if (profile != null && profile.length() > 0 && profile.charAt(0) == '!') {
                return !this.isProfileActive(profile.substring(1));
            }
            if (!this.isProfileActive(profile)) continue;
            return true;
        }
        return false;
    }

    protected boolean isProfileActive(String profile) {
        this.validateProfile(profile);
        return this.doGetActiveProfiles().contains(profile) || this.doGetActiveProfiles().isEmpty() && this.doGetDefaultProfiles().contains(profile);
    }

    protected void validateProfile(String profile) {
        Assert.hasText(profile, "Invalid profile [" + profile + "]: must contain text");
        Assert.isTrue(profile.charAt(0) != '!', "Invalid profile [" + profile + "]: must not begin with the ! operator");
    }

    @Override
    public MutablePropertySources getPropertySources() {
        return this.propertySources;
    }

    @Override
    public Map<String, Object> getSystemEnvironment() {
        ReadOnlySystemAttributesMap systemEnvironment;
        try {
            systemEnvironment = System.getenv();
        }
        catch (AccessControlException ex) {
            systemEnvironment = new ReadOnlySystemAttributesMap(){

                protected String getSystemAttribute(String variableName) {
                    try {
                        return System.getenv(variableName);
                    }
                    catch (AccessControlException ex) {
                        if (AbstractEnvironment.this.logger.isInfoEnabled()) {
                            AbstractEnvironment.this.logger.info((Object)String.format("Caught AccessControlException when accessing system environment variable [%s]; its value will be returned [null]. Reason: %s", variableName, ex.getMessage()));
                        }
                        return null;
                    }
                }
            };
        }
        return systemEnvironment;
    }

    @Override
    public Map<String, Object> getSystemProperties() {
        Map<Object, Object> systemProperties;
        try {
            systemProperties = System.getProperties();
        }
        catch (AccessControlException ex) {
            systemProperties = new ReadOnlySystemAttributesMap(){

                protected String getSystemAttribute(String propertyName) {
                    try {
                        return System.getProperty(propertyName);
                    }
                    catch (AccessControlException ex) {
                        if (AbstractEnvironment.this.logger.isInfoEnabled()) {
                            AbstractEnvironment.this.logger.info((Object)String.format("Caught AccessControlException when accessing system property [%s]; its value will be returned [null]. Reason: %s", propertyName, ex.getMessage()));
                        }
                        return null;
                    }
                }
            };
        }
        return systemProperties;
    }

    @Override
    public void merge(ConfigurableEnvironment parent) {
        for (PropertySource<?> ps : parent.getPropertySources()) {
            if (this.propertySources.contains(ps.getName())) continue;
            this.propertySources.addLast(ps);
        }
        for (String profile : parent.getActiveProfiles()) {
            this.activeProfiles.add(profile);
        }
        if (parent.getDefaultProfiles().length > 0) {
            this.defaultProfiles.remove(RESERVED_DEFAULT_PROFILE_NAME);
            for (String profile : parent.getDefaultProfiles()) {
                this.defaultProfiles.add(profile);
            }
        }
    }

    @Override
    public boolean containsProperty(String key) {
        return this.propertyResolver.containsProperty(key);
    }

    @Override
    public String getProperty(String key) {
        return this.propertyResolver.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.propertyResolver.getProperty(key, defaultValue);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType) {
        return this.propertyResolver.getProperty(key, targetType);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return this.propertyResolver.getProperty(key, targetType, defaultValue);
    }

    @Override
    public <T> Class<T> getPropertyAsClass(String key, Class<T> targetType) {
        return this.propertyResolver.getPropertyAsClass(key, targetType);
    }

    @Override
    public String getRequiredProperty(String key) throws IllegalStateException {
        return this.propertyResolver.getRequiredProperty(key);
    }

    @Override
    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        return this.propertyResolver.getRequiredProperty(key, targetType);
    }

    @Override
    public void setRequiredProperties(String ... requiredProperties) {
        this.propertyResolver.setRequiredProperties(requiredProperties);
    }

    @Override
    public void validateRequiredProperties() throws MissingRequiredPropertiesException {
        this.propertyResolver.validateRequiredProperties();
    }

    @Override
    public String resolvePlaceholders(String text2) {
        return this.propertyResolver.resolvePlaceholders(text2);
    }

    @Override
    public String resolveRequiredPlaceholders(String text2) throws IllegalArgumentException {
        return this.propertyResolver.resolveRequiredPlaceholders(text2);
    }

    @Override
    public void setIgnoreUnresolvableNestedPlaceholders(boolean ignoreUnresolvableNestedPlaceholders) {
        this.propertyResolver.setIgnoreUnresolvableNestedPlaceholders(ignoreUnresolvableNestedPlaceholders);
    }

    @Override
    public void setConversionService(ConfigurableConversionService conversionService) {
        this.propertyResolver.setConversionService(conversionService);
    }

    @Override
    public ConfigurableConversionService getConversionService() {
        return this.propertyResolver.getConversionService();
    }

    @Override
    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.propertyResolver.setPlaceholderPrefix(placeholderPrefix);
    }

    @Override
    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.propertyResolver.setPlaceholderSuffix(placeholderSuffix);
    }

    @Override
    public void setValueSeparator(String valueSeparator) {
        this.propertyResolver.setValueSeparator(valueSeparator);
    }

    public String toString() {
        return String.format("%s {activeProfiles=%s, defaultProfiles=%s, propertySources=%s}", this.getClass().getSimpleName(), this.activeProfiles, this.defaultProfiles, this.propertySources);
    }
}

