/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.enums;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.core.enums.LabeledEnumResolver;
import org.springframework.util.Assert;
import org.springframework.util.CachingMapDecorator;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class AbstractCachingLabeledEnumResolver
implements LabeledEnumResolver {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private final LabeledEnumCache labeledEnumCache = new LabeledEnumCache();

    @Override
    public Set<LabeledEnum> getLabeledEnumSet(Class type) throws IllegalArgumentException {
        return new TreeSet<LabeledEnum>(this.getLabeledEnumMap(type).values());
    }

    @Override
    public Map<Comparable, LabeledEnum> getLabeledEnumMap(Class type) throws IllegalArgumentException {
        Assert.notNull(type, "No type specified");
        return (Map)this.labeledEnumCache.get(type);
    }

    @Override
    public LabeledEnum getLabeledEnumByCode(Class type, Comparable code) throws IllegalArgumentException {
        Assert.notNull(code, "No enum code specified");
        Map<Comparable, LabeledEnum> typeEnums = this.getLabeledEnumMap(type);
        LabeledEnum codedEnum = typeEnums.get(code);
        if (codedEnum == null) {
            throw new IllegalArgumentException("No enumeration with code '" + code + "'" + " of type [" + type.getName() + "] exists: this is likely a configuration error. " + "Make sure the code value matches a valid instance's code property!");
        }
        return codedEnum;
    }

    @Override
    public LabeledEnum getLabeledEnumByLabel(Class type, String label) throws IllegalArgumentException {
        Map<Comparable, LabeledEnum> typeEnums = this.getLabeledEnumMap(type);
        for (LabeledEnum value2 : typeEnums.values()) {
            if (!value2.getLabel().equalsIgnoreCase(label)) continue;
            return value2;
        }
        throw new IllegalArgumentException("No enumeration with label '" + label + "' of type [" + type + "] exists: this is likely a configuration error. " + "Make sure the label string matches a valid instance's label property!");
    }

    protected abstract Set<LabeledEnum> findLabeledEnums(Class var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LabeledEnumCache
    extends CachingMapDecorator<Class, Map<Comparable, LabeledEnum>> {
        public LabeledEnumCache() {
            super(true);
        }

        @Override
        protected Map<Comparable, LabeledEnum> create(Class key) {
            Set<LabeledEnum> typeEnums = AbstractCachingLabeledEnumResolver.this.findLabeledEnums(key);
            if (typeEnums == null || typeEnums.isEmpty()) {
                throw new IllegalArgumentException("Unsupported labeled enumeration type '" + key + "': " + "make sure you've properly defined this enumeration! " + "If it is static, are the class and its fields public/static/final?");
            }
            HashMap<Comparable, LabeledEnum> typeEnumMap = new HashMap<Comparable, LabeledEnum>(typeEnums.size());
            for (LabeledEnum labeledEnum : typeEnums) {
                typeEnumMap.put(labeledEnum.getCode(), labeledEnum);
            }
            return Collections.unmodifiableMap(typeEnumMap);
        }

        @Override
        protected boolean useWeakValue(Class key, Map<Comparable, LabeledEnum> value2) {
            if (!ClassUtils.isCacheSafe(key, AbstractCachingLabeledEnumResolver.this.getClass().getClassLoader())) {
                if (AbstractCachingLabeledEnumResolver.this.logger != null && AbstractCachingLabeledEnumResolver.this.logger.isDebugEnabled()) {
                    AbstractCachingLabeledEnumResolver.this.logger.debug((Object)("Not strongly caching class [" + key.getName() + "] because it is not cache-safe"));
                }
                return true;
            }
            return false;
        }
    }
}

