/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.cache.annotation.CacheAnnotationParser;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringCacheAnnotationParser
implements CacheAnnotationParser,
Serializable {
    @Override
    public Collection<CacheOperation> parseCacheAnnotations(AnnotatedElement ae) {
        Collection<Caching> caching;
        Collection<CachePut> updates;
        Collection<CacheEvict> evicts;
        Collection<CacheOperation> ops2 = null;
        Collection<Cacheable> cacheables = this.getAnnotations(ae, Cacheable.class);
        if (cacheables != null) {
            ops2 = this.lazyInit(ops2);
            for (Cacheable cacheable : cacheables) {
                ops2.add(this.parseCacheableAnnotation(ae, cacheable));
            }
        }
        if ((evicts = this.getAnnotations(ae, CacheEvict.class)) != null) {
            ops2 = this.lazyInit(ops2);
            for (CacheEvict e : evicts) {
                ops2.add(this.parseEvictAnnotation(ae, e));
            }
        }
        if ((updates = this.getAnnotations(ae, CachePut.class)) != null) {
            ops2 = this.lazyInit(ops2);
            for (CachePut p : updates) {
                ops2.add(this.parseUpdateAnnotation(ae, p));
            }
        }
        if ((caching = this.getAnnotations(ae, Caching.class)) != null) {
            ops2 = this.lazyInit(ops2);
            for (Caching c : caching) {
                ops2.addAll(this.parseCachingAnnotation(ae, c));
            }
        }
        return ops2;
    }

    private <T extends Annotation> Collection<CacheOperation> lazyInit(Collection<CacheOperation> ops2) {
        return ops2 != null ? ops2 : new ArrayList(1);
    }

    CacheableOperation parseCacheableAnnotation(AnnotatedElement ae, Cacheable caching) {
        CacheableOperation cuo = new CacheableOperation();
        cuo.setCacheNames(caching.value());
        cuo.setCondition(caching.condition());
        cuo.setUnless(caching.unless());
        cuo.setKey(caching.key());
        cuo.setName(ae.toString());
        return cuo;
    }

    CacheEvictOperation parseEvictAnnotation(AnnotatedElement ae, CacheEvict caching) {
        CacheEvictOperation ceo = new CacheEvictOperation();
        ceo.setCacheNames(caching.value());
        ceo.setCondition(caching.condition());
        ceo.setKey(caching.key());
        ceo.setCacheWide(caching.allEntries());
        ceo.setBeforeInvocation(caching.beforeInvocation());
        ceo.setName(ae.toString());
        return ceo;
    }

    CacheOperation parseUpdateAnnotation(AnnotatedElement ae, CachePut caching) {
        CachePutOperation cuo = new CachePutOperation();
        cuo.setCacheNames(caching.value());
        cuo.setCondition(caching.condition());
        cuo.setUnless(caching.unless());
        cuo.setKey(caching.key());
        cuo.setName(ae.toString());
        return cuo;
    }

    Collection<CacheOperation> parseCachingAnnotation(AnnotatedElement ae, Caching caching) {
        Object[] updates;
        Object[] evicts;
        Collection<CacheOperation> ops2 = null;
        Object[] cacheables = caching.cacheable();
        if (!ObjectUtils.isEmpty(cacheables)) {
            ops2 = this.lazyInit(ops2);
            for (Object cacheable : cacheables) {
                ops2.add(this.parseCacheableAnnotation(ae, (Cacheable)cacheable));
            }
        }
        if (!ObjectUtils.isEmpty(evicts = caching.evict())) {
            ops2 = this.lazyInit(ops2);
            for (Object evict : evicts) {
                ops2.add(this.parseEvictAnnotation(ae, (CacheEvict)evict));
            }
        }
        if (!ObjectUtils.isEmpty(updates = caching.put())) {
            ops2 = this.lazyInit(ops2);
            for (Object update2 : updates) {
                ops2.add(this.parseUpdateAnnotation(ae, (CachePut)update2));
            }
        }
        return ops2;
    }

    private <T extends Annotation> Collection<T> getAnnotations(AnnotatedElement ae, Class<T> annotationType) {
        ArrayList<T> anns = new ArrayList<T>(2);
        T ann = ae.getAnnotation(annotationType);
        if (ann != null) {
            anns.add(ann);
        }
        for (Annotation metaAnn : ae.getAnnotations()) {
            ann = metaAnn.annotationType().getAnnotation(annotationType);
            if (ann == null) continue;
            anns.add(ann);
        }
        return anns.isEmpty() ? null : anns;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof SpringCacheAnnotationParser;
    }

    public int hashCode() {
        return SpringCacheAnnotationParser.class.hashCode();
    }
}

