/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.StringUtils;

public class StringTrimmerEditor
extends PropertyEditorSupport {
    private final String charsToDelete;
    private final boolean emptyAsNull;

    public StringTrimmerEditor(boolean emptyAsNull) {
        this.charsToDelete = null;
        this.emptyAsNull = emptyAsNull;
    }

    public StringTrimmerEditor(String charsToDelete, boolean emptyAsNull) {
        this.charsToDelete = charsToDelete;
        this.emptyAsNull = emptyAsNull;
    }

    public void setAsText(String text2) {
        if (text2 == null) {
            this.setValue(null);
        } else {
            String value2 = text2.trim();
            if (this.charsToDelete != null) {
                value2 = StringUtils.deleteAny(value2, this.charsToDelete);
            }
            if (this.emptyAsNull && "".equals(value2)) {
                this.setValue(null);
            } else {
                this.setValue(value2);
            }
        }
    }

    public String getAsText() {
        Object value2 = this.getValue();
        return value2 != null ? value2.toString() : "";
    }
}

