/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DB2Platform;
import org.eclipse.persistence.queries.ValueReadQuery;

public class DerbyPlatform
extends DB2Platform {
    public static final int MAX_CLOB = Integer.MAX_VALUE;
    public static final int MAX_BLOB = Integer.MAX_VALUE;
    protected boolean isSequenceSupported;
    protected boolean isConnectionDataInitialized;

    @Override
    protected void appendByteArray(byte[] bytes, Writer writer) throws IOException {
        super.appendByteArray(bytes, writer);
    }

    @Override
    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("VALUES CURRENT_TIMESTAMP");
            this.timestampQuery.setAllowNativeSQLQuery(true);
        }
        return this.timestampQuery;
    }

    @Override
    public Vector getNativeTableInfo(String table, String creator, AbstractSession session) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public String getProcedureEndString() {
        return this.getBatchEndString();
    }

    @Override
    public String getProcedureBeginString() {
        return this.getBatchBeginString();
    }

    @Override
    public String getInOutputProcedureToken() {
        return "INOUT";
    }

    @Override
    public boolean shouldPrintOutputTokenAtStart() {
        return false;
    }

    @Override
    public boolean isDerby() {
        return true;
    }

    @Override
    public boolean isDB2() {
        return false;
    }

    @Override
    public String getSelectForUpdateString() {
        return " FOR UPDATE WITH RS";
    }

    @Override
    public boolean shouldIgnoreException(SQLException exception) {
        return false;
    }

    @Override
    protected String getCreateTempTableSqlSuffix() {
        return " ON COMMIT DELETE ROWS NOT LOGGED";
    }

    @Override
    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery selectQuery = new ValueReadQuery();
        selectQuery.setSQLString("values IDENTITY_VAL_LOCAL()");
        return selectQuery;
    }

    @Override
    protected boolean shouldTempTableSpecifyPrimaryKeys() {
        return false;
    }

    @Override
    protected String getCreateTempTableSqlBodyForTable(DatabaseTable table) {
        return null;
    }

    @Override
    public void writeUpdateOriginalFromTempTableSql(Writer writer, DatabaseTable table, Collection pkFields, Collection assignedFields) throws IOException {
        writer.write("UPDATE ");
        String tableName = table.getQualifiedNameDelimited(this);
        writer.write(tableName);
        writer.write(" SET ");
        String tempTableName = this.getTempTableForTable(table).getQualifiedNameDelimited(this);
        boolean isFirst = true;
        Iterator itFields = assignedFields.iterator();
        while (itFields.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                writer.write(", ");
            }
            DatabaseField field2 = (DatabaseField)itFields.next();
            String fieldName = field2.getNameDelimited(this);
            writer.write(fieldName);
            writer.write(" = (SELECT ");
            writer.write(fieldName);
            writer.write(" FROM ");
            writer.write(tempTableName);
            DerbyPlatform.writeAutoJoinWhereClause(writer, null, tableName, pkFields, this);
            writer.write(")");
        }
        writer.write(" WHERE EXISTS(SELECT ");
        writer.write(((DatabaseField)pkFields.iterator().next()).getNameDelimited(this));
        writer.write(" FROM ");
        writer.write(tempTableName);
        DerbyPlatform.writeAutoJoinWhereClause(writer, null, tableName, pkFields, this);
        writer.write(")");
    }

    @Override
    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" GENERATED BY DEFAULT AS IDENTITY");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> fieldTypeMapping = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("SMALLINT DEFAULT 0", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("BIGINT", false));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("FLOAT", false));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("FLOAT", false));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("BIGINT", false));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("DECIMAL", 15));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("DECIMAL", 15));
        fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("CLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("BLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("CLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("BLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("CLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("TIME", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        return fieldTypeMapping;
    }

    @Override
    protected void setNullFromDatabaseField(DatabaseField databaseField, PreparedStatement statement, int index2) throws SQLException {
        int jdbcType = databaseField.getSqlType();
        if (jdbcType == Integer.MIN_VALUE) {
            jdbcType = statement.getParameterMetaData().getParameterType(index2);
        }
        statement.setNull(index2, jdbcType);
    }

    @Override
    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleFunction(42, "DOUBLE"));
        this.addOperator(DerbyPlatform.extractOperator());
    }

    public static ExpressionOperator extractOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(138);
        exOperator.setName("EXTRACT");
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).add("");
        ((Vector)v).add("(");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        int[] indices = new int[]{1, 0};
        exOperator.setArgumentIndices(indices);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    @Override
    public int computeMaxRowsForSQL(int firstResultIndex, int maxResults) {
        if (!this.isSequenceSupported) {
            return maxResults;
        }
        return maxResults - (firstResultIndex >= 0 ? firstResultIndex : 0);
    }

    @Override
    public void printSQLSelectStatement(DatabaseCall call, ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        if (!this.isSequenceSupported) {
            call.setFields(statement.printSQL(printer));
            return;
        }
        int max2 = 0;
        int firstRow = 0;
        if (statement.getQuery() != null) {
            max2 = statement.getQuery().getMaxRows();
            firstRow = statement.getQuery().getFirstResult();
        }
        if (!this.shouldUseRownumFiltering() || max2 <= 0 && firstRow <= 0) {
            call.setFields(statement.printSQL(printer));
            return;
        }
        if (max2 > 0) {
            statement.setUseUniqueFieldAliases(true);
            call.setFields(statement.printSQL(printer));
            printer.printString(" OFFSET ");
            printer.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
            printer.printString(" ROWS FETCH NEXT ");
            printer.printParameter(DatabaseCall.MAXROW_FIELD);
            printer.printString(" ROWS ONLY");
        } else {
            statement.setUseUniqueFieldAliases(true);
            call.setFields(statement.printSQL(printer));
            printer.printString(" OFFSET ");
            printer.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
            printer.printString(" ROWS");
        }
        call.setIgnoreFirstRowSetting(true);
        call.setIgnoreMaxResultsSetting(true);
    }

    @Override
    public boolean supportsSequenceObjects() {
        return this.isSequenceSupported;
    }

    @Override
    public boolean isAlterSequenceObjectSupported() {
        return false;
    }

    @Override
    public Writer buildSequenceObjectDeletionWriter(Writer writer, String fullSeqName) throws IOException {
        writer.write("DROP SEQUENCE ");
        writer.write(fullSeqName);
        writer.write(" RESTRICT");
        return writer;
    }

    @Override
    public void initializeConnectionData(Connection connection) throws SQLException {
        if (this.isConnectionDataInitialized) {
            return;
        }
        String databaseVersion = connection.getMetaData().getDatabaseProductVersion();
        this.isSequenceSupported = Helper.compareVersions(databaseVersion, "10.6.1") >= 0;
        this.isConnectionDataInitialized = true;
    }
}

