/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings.converters;

import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.sessions.Session;

public class XMLRootConverter
implements XMLConverter {
    private XPathFragment rootFragment;
    private XMLField associatedField;
    private DatabaseMapping mapping;

    public XMLRootConverter(XMLField associatedField) {
        this.associatedField = associatedField;
    }

    @Override
    public Object convertDataValueToObjectValue(Object dataValue, Session session, XMLUnmarshaller unmarshaller) {
        return this.convertDataValueToObjectValue(dataValue, session);
    }

    @Override
    public Object convertObjectValueToDataValue(Object objectValue, Session session, XMLMarshaller marshaller) {
        return this.convertObjectValueToDataValue(objectValue, session);
    }

    @Override
    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        XMLRoot root2 = new XMLRoot();
        root2.setLocalName(this.rootFragment.getLocalName());
        root2.setNamespaceURI(this.rootFragment.getNamespaceURI());
        if (this.mapping.isAbstractDirectMapping() && (dataValue == null || dataValue.getClass() != this.mapping.getAttributeClassification())) {
            try {
                dataValue = session.getDatasourcePlatform().convertObject(dataValue, this.mapping.getAttributeClassification());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.mapping.getDescriptor(), e);
            }
        }
        root2.setObject(dataValue);
        return root2;
    }

    @Override
    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        if (objectValue instanceof XMLRoot) {
            return ((XMLRoot)objectValue).getObject();
        }
        return objectValue;
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        XPathFragment fragment = this.associatedField.getXPathFragment();
        while (fragment.getNextFragment() != null && !fragment.getNextFragment().nameIsText()) {
            fragment = fragment.getNextFragment();
        }
        if (fragment.hasNamespace() && this.associatedField.getNamespaceResolver() != null) {
            String uri = this.associatedField.getNamespaceResolver().resolveNamespacePrefix(fragment.getPrefix());
            fragment.setNamespaceURI(uri);
        }
        this.rootFragment = fragment;
        this.mapping = mapping;
    }

    @Override
    public boolean isMutable() {
        return false;
    }
}

