/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.util.Collection;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;

public class UnitOfWorkQueryValueHolder
extends UnitOfWorkValueHolder {
    protected UnitOfWorkQueryValueHolder() {
    }

    protected UnitOfWorkQueryValueHolder(ValueHolderInterface attributeValue, Object clone2, DatabaseMapping mapping, UnitOfWorkImpl unitOfWork) {
        super(attributeValue, clone2, mapping, unitOfWork);
    }

    public UnitOfWorkQueryValueHolder(ValueHolderInterface attributeValue, Object clone2, ForeignReferenceMapping mapping, AbstractRecord row, UnitOfWorkImpl unitOfWork) {
        this(attributeValue, clone2, mapping, unitOfWork);
        this.row = row;
    }

    @Override
    protected Object buildBackupCloneFor(Object cloneAttributeValue) {
        return this.mapping.buildBackupCloneForPartObject(cloneAttributeValue, null, null, this.getUnitOfWork());
    }

    @Override
    public Object buildCloneFor(Object originalAttributeValue) {
        Integer refreshCascade = null;
        if (this.wrappedValueHolder instanceof QueryBasedValueHolder) {
            refreshCascade = ((QueryBasedValueHolder)this.getWrappedValueHolder()).getRefreshCascadePolicy();
        }
        Object clone2 = this.mapping.buildCloneForPartObject(originalAttributeValue, null, null, this.relationshipSourceObject, this.getUnitOfWork(), refreshCascade, true, true);
        if (this.wrappedValueHolder.isInstantiated() && refreshCascade != null) {
            ((QueryBasedValueHolder)this.getWrappedValueHolder()).setRefreshCascadePolicy(null);
        }
        return clone2;
    }

    @Override
    public void setValue(Object theValue) {
        if (!this.isInstantiated) {
            this.instantiate();
        }
        Object oldValue = this.getValue();
        super.setValue(theValue);
        this.updateForeignReferenceSet(theValue, oldValue);
    }

    public void updateForeignReferenceRemove(Object value2) {
        DatabaseMapping sourceMapping = this.getMapping();
        if (sourceMapping == null) {
            return;
        }
        if (sourceMapping.isPrivateOwned()) {
            return;
        }
        ForeignReferenceMapping partner = this.getRelationshipPartnerFor(value2);
        if (partner != null && value2 != null) {
            Object unwrappedValue = partner.getDescriptor().getObjectBuilder().unwrapObject(value2, this.getSession());
            Object oldParent = partner.getRealAttributeValueFromObject(unwrappedValue, this.getSession());
            Object sourceObject = this.getRelationshipSourceObject();
            if (oldParent == null) {
                return;
            }
            if (partner.isCollectionMapping() && (!(oldParent instanceof IndirectContainer) || ((IndirectContainer)oldParent).isInstantiated()) && !partner.getContainerPolicy().contains(sourceObject, oldParent, this.getSession())) {
                return;
            }
            if (partner.isObjectReferenceMapping()) {
                partner.setRealAttributeValueInObject(unwrappedValue, null);
            } else if (partner.isCollectionMapping()) {
                partner.getContainerPolicy().removeFrom(sourceObject, oldParent, this.getSession());
            }
        }
    }

    public void updateForeignReferenceSet(Object value2, Object oldValue) {
        if (value2 != null && value2 instanceof Collection) {
            return;
        }
        if (this.getMapping() == null) {
            return;
        }
        ForeignReferenceMapping partner = this.getRelationshipPartnerFor(value2);
        if (partner != null) {
            if (value2 != null) {
                Object unwrappedValue = partner.getDescriptor().getObjectBuilder().unwrapObject(value2, this.getSession());
                Object oldParent = partner.getRealAttributeValueFromObject(unwrappedValue, this.getSession());
                Object sourceObject = this.getRelationshipSourceObject();
                Object wrappedSource = this.getMapping().getDescriptor().getObjectBuilder().wrapObject(sourceObject, this.getSession());
                if (oldParent == sourceObject) {
                    return;
                }
                if (partner.isCollectionMapping() && (!(oldParent instanceof IndirectContainer) || ((IndirectContainer)oldParent).isInstantiated()) && partner.getContainerPolicy().contains(sourceObject, oldParent, this.getSession())) {
                    return;
                }
                if (oldParent != null) {
                    if (this.getMapping().isObjectReferenceMapping()) {
                        if (!partner.isCollectionMapping()) {
                            ((ObjectReferenceMapping)this.getMapping()).setRealAttributeValueInObject(oldParent, null);
                        }
                    } else if (this.getMapping().isCollectionMapping() && !partner.isManyToManyMapping()) {
                        this.getMapping().getContainerPolicy().removeFrom(unwrappedValue, this.getMapping().getRealAttributeValueFromObject(oldParent, this.getSession()), this.getSession());
                    }
                }
                if (oldValue != null) {
                    Object unwrappedOldValue = partner.getDescriptor().getObjectBuilder().unwrapObject(oldValue, this.getSession());
                    if (partner.isObjectReferenceMapping()) {
                        partner.setRealAttributeValueInObject(unwrappedOldValue, null);
                    } else if (partner.isCollectionMapping()) {
                        partner.getContainerPolicy().removeFrom(sourceObject, partner.getRealAttributeValueFromObject(unwrappedOldValue, this.getSession()), this.getSession());
                    }
                }
                if (partner.isObjectReferenceMapping()) {
                    partner.setRealAttributeValueInObject(unwrappedValue, wrappedSource);
                } else if (partner.isCollectionMapping()) {
                    partner.getContainerPolicy().addInto(wrappedSource, oldParent, this.getSession());
                }
            } else {
                this.updateForeignReferenceRemove(oldValue);
            }
        }
    }

    private ForeignReferenceMapping getRelationshipPartnerFor(Object partnerObject) {
        ForeignReferenceMapping partner = (ForeignReferenceMapping)this.getMapping().getRelationshipPartner();
        if (partner == null || partnerObject == null) {
            return partner;
        }
        if (partner.getDescriptor().hasInheritance()) {
            ClassDescriptor partnerObjectDescriptor = this.getSession().getDescriptor(partnerObject);
            if (!partner.getDescriptor().getJavaClass().isAssignableFrom(partnerObjectDescriptor.getJavaClass())) {
                return (ForeignReferenceMapping)partnerObjectDescriptor.getObjectBuilder().getMappingForAttributeName(partner.getAttributeName());
            }
        }
        return partner;
    }
}

