/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.expressions.ListExpressionOperator;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.expressions.ArgumentListFunctionExpression;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.CollectionExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.LiteralExpression;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.expressions.TableAliasLookup;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public abstract class Expression
implements Serializable,
Cloneable {
    static final long serialVersionUID = -5979150600092006081L;
    protected transient DatabaseTable lastTable;
    protected transient DatabaseTable currentAlias;
    protected boolean selectIfOrderedBy = true;
    protected int hashCode = 0;
    public static boolean shouldUseUpperCaseForIgnoreCase = true;

    public Expression addDate(String datePart, int numberToAdd) {
        return this.addDate(datePart, (Object)numberToAdd);
    }

    public Expression addDate(String datePart, Object numberToAdd) {
        ExpressionOperator anOperator = this.getOperator(90);
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(Expression.fromLiteral(datePart, this));
        args.add(numberToAdd);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression addMonths(int months) {
        return this.addMonths((Object)months);
    }

    public Expression addMonths(Object months) {
        ExpressionOperator anOperator = this.getOperator(47);
        return anOperator.expressionFor(this, months);
    }

    public DatabaseTable aliasForTable(DatabaseTable table) {
        return null;
    }

    public Expression allOf(String attributeName, Expression criteria) {
        ReportQuery subQuery = new ReportQuery();
        subQuery.setShouldRetrieveFirstPrimaryKey(true);
        ExpressionBuilder builder = criteria.getBuilder();
        criteria = builder.equal(this.anyOf(attributeName)).and(criteria.not());
        subQuery.setSelectionCriteria(criteria);
        return this.notExists(subQuery);
    }

    public Expression and(Expression theExpression) {
        if (theExpression == null) {
            return this;
        }
        ExpressionBuilder base = this.getBuilder();
        Expression expressionToUse = theExpression;
        if (theExpression.getBuilder() != base && (base == this || theExpression.getBuilder().getQueryClass() == null)) {
            expressionToUse = theExpression.rebuildOn(base);
        }
        if (base == this) {
            return expressionToUse;
        }
        ExpressionOperator anOperator = this.getOperator(1);
        return anOperator.expressionFor(this, expressionToUse);
    }

    public Expression anyOf(String attributeName) {
        return this.anyOf(attributeName, true);
    }

    public Expression anyOf(String attributeName, boolean shouldJoinBeIndependent) {
        throw new UnsupportedOperationException("anyOf");
    }

    public Expression anyOfAllowingNone(String attributeName) {
        return this.anyOfAllowingNone(attributeName, true);
    }

    public Expression anyOfAllowingNone(String attributeName, boolean shouldJoinBeIndependent) {
        throw new UnsupportedOperationException("anyOfAllowingNone");
    }

    @Deprecated
    public Expression as(Class castClass) {
        return this.treat(castClass);
    }

    public Expression as(String alias) {
        ExpressionOperator operator = this.getOperator(148);
        return operator.expressionFor(this, this.literal(alias));
    }

    public Expression treat(Class castClass) {
        return this;
    }

    public Expression ascending() {
        return this.getFunction(26);
    }

    public Expression nullsFirst() {
        return this.getFunction(139);
    }

    public Expression nullsLast() {
        return this.getFunction(140);
    }

    public Expression asciiValue() {
        ExpressionOperator anOperator = this.getOperator(45);
        return anOperator.expressionFor(this);
    }

    public Expression asOf(AsOfClause pastTime) {
        throw new UnsupportedOperationException("anyOfAllowingNone");
    }

    protected void assignAlias(String name, DatabaseTable tableOrExpression) {
    }

    public int assignTableAliasesStartingAt(int initialValue) {
        if (this.hasBeenAliased()) {
            return initialValue;
        }
        int counter = initialValue;
        List<DatabaseTable> ownedTables = this.getOwnedTables();
        if (ownedTables != null) {
            for (DatabaseTable table : ownedTables) {
                this.assignAlias("t" + counter, table);
                ++counter;
            }
        }
        return counter;
    }

    public Expression average() {
        return this.getFunction(21);
    }

    public Expression between(byte leftValue, byte rightValue) {
        return this.between((Object)leftValue, (Object)rightValue);
    }

    public Expression between(char leftChar, char rightChar) {
        return this.between(Character.valueOf(leftChar), Character.valueOf(rightChar));
    }

    public Expression between(double leftValue, double rightValue) {
        return this.between((Object)leftValue, (Object)rightValue);
    }

    public Expression between(float leftValue, float rightValue) {
        return this.between(Float.valueOf(leftValue), Float.valueOf(rightValue));
    }

    public Expression between(int leftValue, int rightValue) {
        return this.between((Object)leftValue, (Object)rightValue);
    }

    public Expression between(long leftValue, long rightValue) {
        return this.between((Object)leftValue, (Object)rightValue);
    }

    public Expression between(Object leftValue, Object rightValue) {
        ExpressionOperator anOperator = this.getOperator(15);
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(leftValue);
        args.add(rightValue);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression between(Expression leftExpression, Expression rightExpression) {
        return this.between((Object)leftExpression, (Object)rightExpression);
    }

    public Expression between(short leftValue, short rightValue) {
        return this.between((Object)leftValue, (Object)rightValue);
    }

    public Expression caseStatement(Map caseItems, Object defaultItem) {
        ArgumentListFunctionExpression expression = this.caseStatement();
        ((FunctionExpression)expression).addChild(this);
        for (Object key : caseItems.keySet()) {
            ((FunctionExpression)expression).addChild(Expression.from(key, this));
            ((FunctionExpression)expression).addChild(Expression.from(caseItems.get(key), this));
        }
        ((FunctionExpression)expression).addChild(Expression.from(defaultItem, this));
        return expression;
    }

    public ArgumentListFunctionExpression caseStatement() {
        ListExpressionOperator caseOperator = (ListExpressionOperator)this.getOperator(117);
        ListExpressionOperator clonedCaseOperator = new ListExpressionOperator();
        caseOperator.copyTo(clonedCaseOperator);
        ArgumentListFunctionExpression expression = new ArgumentListFunctionExpression();
        expression.setBaseExpression(this);
        expression.setOperator(clonedCaseOperator);
        return expression;
    }

    public Expression caseConditionStatement(Map<Expression, Object> caseConditions, Object defaultItem) {
        ArgumentListFunctionExpression expression = this.caseConditionStatement();
        Iterator<Expression> iterator2 = caseConditions.keySet().iterator();
        if (iterator2.hasNext()) {
            Expression key = iterator2.next();
            ((FunctionExpression)expression).addChild(key);
            expression.setBaseExpression(key);
            ((FunctionExpression)expression).addChild(Expression.from(caseConditions.get(key), this));
            while (iterator2.hasNext()) {
                key = iterator2.next();
                ((FunctionExpression)expression).addChild(key);
                ((FunctionExpression)expression).addChild(Expression.from(caseConditions.get(key), this));
            }
        }
        ((FunctionExpression)expression).addChild(Expression.from(defaultItem, this));
        return expression;
    }

    public ArgumentListFunctionExpression caseConditionStatement() {
        ListExpressionOperator caseOperator = (ListExpressionOperator)this.getOperator(136);
        ListExpressionOperator clonedCaseOperator = new ListExpressionOperator();
        caseOperator.copyTo(clonedCaseOperator);
        ArgumentListFunctionExpression expression = new ArgumentListFunctionExpression();
        expression.setBaseExpression(this);
        expression.setOperator(clonedCaseOperator);
        return expression;
    }

    public Expression nullIf(Object object) {
        ExpressionOperator anOperator = this.getOperator(131);
        ArrayList<Expression> args = new ArrayList<Expression>(1);
        args.add(Expression.from(object, this));
        return anOperator.expressionForArguments(this, args);
    }

    public ArgumentListFunctionExpression coalesce(Collection expressions) {
        ArgumentListFunctionExpression expression = this.coalesce();
        Iterator iterator2 = expressions.iterator();
        if (iterator2.hasNext()) {
            Expression base = Expression.from(iterator2.next(), this);
            expression.addChild(base);
            expression.setBaseExpression(base);
            while (iterator2.hasNext()) {
                expression.addChild(Expression.from(iterator2.next(), this));
            }
        }
        return expression;
    }

    public ArgumentListFunctionExpression coalesce() {
        ListExpressionOperator coalesceOperator = (ListExpressionOperator)this.getOperator(132);
        ListExpressionOperator clonedCoalesceOperator = new ListExpressionOperator();
        coalesceOperator.copyTo(clonedCoalesceOperator);
        ArgumentListFunctionExpression expression = new ArgumentListFunctionExpression();
        expression.setBaseExpression(this);
        expression.setOperator(clonedCoalesceOperator);
        return expression;
    }

    public Object clone() {
        IdentityHashMap alreadyDone = new IdentityHashMap();
        return this.copiedVersionFrom(alreadyDone);
    }

    public Expression cloneUsing(Expression newBase) {
        IdentityHashMap alreadyDone = new IdentityHashMap();
        alreadyDone.put(alreadyDone, newBase);
        return this.copiedVersionFrom(alreadyDone);
    }

    public Expression concat(Object left) {
        ExpressionOperator anOperator = this.getOperator(31);
        return anOperator.expressionFor(this, left);
    }

    public Expression containsAllKeyWords(String spaceSeparatedKeyWords) {
        StringTokenizer tokenizer = new StringTokenizer(spaceSeparatedKeyWords);
        Expression expression = null;
        while (tokenizer.hasMoreTokens()) {
            String token2 = tokenizer.nextToken();
            expression = expression == null ? this.containsSubstringIgnoringCase(token2) : expression.and(this.containsSubstringIgnoringCase(token2));
        }
        if (expression == null) {
            return this.like("%");
        }
        return expression;
    }

    public Expression containsAnyKeyWords(String spaceSeparatedKeyWords) {
        StringTokenizer tokenizer = new StringTokenizer(spaceSeparatedKeyWords);
        Expression expression = null;
        while (tokenizer.hasMoreTokens()) {
            String token2 = tokenizer.nextToken();
            expression = expression == null ? this.containsSubstringIgnoringCase(token2) : expression.or(this.containsSubstringIgnoringCase(token2));
        }
        if (expression == null) {
            return this.like("%");
        }
        return expression;
    }

    public Expression containsSubstring(String theValue) {
        return this.like("%" + theValue + "%");
    }

    public Expression containsSubstring(Expression expression) {
        return this.like(this.value("%").concat(expression).concat("%"));
    }

    public Expression containsSubstringIgnoringCase(String theValue) {
        if (shouldUseUpperCaseForIgnoreCase) {
            return this.toUpperCase().containsSubstring(theValue.toUpperCase());
        }
        return this.toLowerCase().containsSubstring(theValue.toLowerCase());
    }

    public Expression containsSubstringIgnoringCase(Expression expression) {
        if (shouldUseUpperCaseForIgnoreCase) {
            return this.toUpperCase().containsSubstring(expression.toUpperCase());
        }
        return this.toLowerCase().containsSubstring(expression.toLowerCase());
    }

    protected void convertNodeToUseOuterJoin() {
    }

    public Expression convertToUseOuterJoin() {
        ExpressionIterator iterator2 = new ExpressionIterator(){

            @Override
            public void iterate(Expression each) {
                each.convertNodeToUseOuterJoin();
            }
        };
        iterator2.iterateOn(this);
        return this;
    }

    public Expression copiedVersionFrom(Map alreadyDone) {
        if (alreadyDone == null) {
            return this;
        }
        Expression existing = (Expression)alreadyDone.get(this);
        if (existing == null) {
            return this.registerIn(alreadyDone);
        }
        return existing;
    }

    public Expression count() {
        return this.getFunction(19);
    }

    public Expression create(Expression base, Object singleArgument, ExpressionOperator anOperator) {
        return this;
    }

    public Expression createWithBaseLast(Expression base, Object singleArgument, ExpressionOperator anOperator) {
        return this;
    }

    public Expression create(Expression base, List arguments, ExpressionOperator anOperator) {
        return this;
    }

    public Expression currentTimeStamp() {
        return this.currentDate();
    }

    public Expression currentDate() {
        return this.getFunction(54);
    }

    public Expression currentDateDate() {
        return this.getFunction(123);
    }

    public Expression currentTime() {
        return this.getFunction(128);
    }

    public Expression dateDifference(String datePart, Date date) {
        ExpressionOperator anOperator = this.getOperator(94);
        FunctionExpression expression = new FunctionExpression();
        expression.setBaseExpression(this);
        expression.addChild(Expression.fromLiteral(datePart, this));
        expression.addChild(Expression.from(date, this));
        expression.addChild(this);
        expression.setOperator(anOperator);
        return expression;
    }

    public Expression dateDifference(String datePart, Expression comparisonExpression) {
        ExpressionOperator anOperator = this.getOperator(94);
        FunctionExpression expression = new FunctionExpression();
        expression.setBaseExpression(this);
        expression.addChild(Expression.fromLiteral(datePart, this));
        expression.addChild(comparisonExpression);
        expression.addChild(this);
        expression.setOperator(anOperator);
        return expression;
    }

    public Expression dateName(String datePart) {
        ExpressionOperator anOperator = this.getOperator(92);
        FunctionExpression expression = new FunctionExpression();
        expression.setBaseExpression(this);
        expression.addChild(Expression.fromLiteral(datePart, this));
        expression.addChild(this);
        expression.setOperator(anOperator);
        return expression;
    }

    public Expression datePart(String datePart) {
        ExpressionOperator anOperator = this.getOperator(93);
        FunctionExpression expression = new FunctionExpression();
        expression.setBaseExpression(this);
        expression.addChild(Expression.fromLiteral(datePart, this));
        expression.addChild(this);
        expression.setOperator(anOperator);
        return expression;
    }

    public Expression dateToString() {
        ExpressionOperator anOperator = this.getOperator(48);
        return anOperator.expressionFor(this);
    }

    public Expression decode(Map decodeableItems, String defaultItem) {
        ExpressionOperator anOperator = new ExpressionOperator();
        anOperator.setSelector(105);
        anOperator.setName("DECODE");
        anOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        anOperator.setType(5);
        anOperator.bePrefix();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(decodeableItems.size() + 1);
        ((Vector)v).add("DECODE(");
        int i = 0;
        while (i < decodeableItems.size() * 2 + 1) {
            ((Vector)v).add(", ");
            ++i;
        }
        ((Vector)v).add(")");
        anOperator.printsAs(v);
        FunctionExpression expression = new FunctionExpression();
        expression.setBaseExpression(this);
        expression.addChild(this);
        for (Object key : decodeableItems.keySet()) {
            expression.addChild(Expression.from(key, this));
            expression.addChild(Expression.from(decodeableItems.get(key), this));
        }
        expression.addChild(Expression.from(defaultItem, this));
        expression.setOperator(anOperator);
        return expression;
    }

    public Expression descending() {
        return this.getFunction(27);
    }

    public String descriptionOfNodeType() {
        return "Expression";
    }

    public Expression difference(String expression) {
        ExpressionOperator anOperator = this.getOperator(98);
        return anOperator.expressionFor(this, expression);
    }

    public Expression distinct() {
        return this.getFunction(87);
    }

    public boolean doesConform(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy) throws QueryException {
        return this.doesConform(object, session, translationRow, valueHolderPolicy, false);
    }

    public boolean doesConform(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean objectIsUnregistered) throws QueryException {
        throw QueryException.cannotConformExpression();
    }

    public boolean equals(Object expression) {
        return this == expression || expression != null && this.getClass().equals(expression.getClass()) && this.hashCode() == expression.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
        }
        return this.hashCode;
    }

    public int computeHashCode() {
        return 32;
    }

    public Expression equal(byte theValue) {
        return this.equal((Object)theValue);
    }

    public Expression equal(char theChar) {
        return this.equal(Character.valueOf(theChar));
    }

    public Expression equal(double theValue) {
        return this.equal((Object)theValue);
    }

    public Expression equal(float theValue) {
        return this.equal(Float.valueOf(theValue));
    }

    public Expression equal(int theValue) {
        return this.equal((Object)theValue);
    }

    public Expression equal(long theValue) {
        return this.equal((Object)theValue);
    }

    public Expression equal(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(4);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression equal(Expression theValue) {
        ExpressionOperator anOperator = this.getOperator(4);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression equal(short theValue) {
        return this.equal((Object)theValue);
    }

    public Expression equal(boolean theBoolean) {
        return this.equal((Object)theBoolean);
    }

    public Expression equalOuterJoin(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(6);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression equalOuterJoin(Expression theValue) {
        ExpressionOperator anOperator = this.getOperator(6);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression equalsIgnoreCase(String theValue) {
        if (shouldUseUpperCaseForIgnoreCase) {
            return this.toUpperCase().equal(theValue.toUpperCase());
        }
        return this.toLowerCase().equal(theValue.toLowerCase());
    }

    public Expression equalsIgnoreCase(Expression theValue) {
        if (shouldUseUpperCaseForIgnoreCase) {
            return this.toUpperCase().equal(theValue.toUpperCase());
        }
        return this.toLowerCase().equal(theValue.toLowerCase());
    }

    public Expression exists(ReportQuery subQuery) {
        ExpressionOperator anOperator = this.getOperator(86);
        return anOperator.expressionFor(this.subQuery(subQuery));
    }

    public boolean extractPrimaryKeyValues(boolean requireExactMatch, ClassDescriptor descriptor, AbstractRecord primaryKeyRow, AbstractRecord translationRow) {
        return this.extractValues(true, requireExactMatch, descriptor, primaryKeyRow, translationRow);
    }

    public boolean extractValues(boolean primaryKeyOnly, boolean requireExactMatch, ClassDescriptor descriptor, AbstractRecord primaryKeyRow, AbstractRecord translationRow) {
        return false;
    }

    public boolean extractFields(boolean requireExactMatch, boolean primaryKey, ClassDescriptor descriptor, List<DatabaseField> searchFields, Set<DatabaseField> foundFields) {
        return false;
    }

    public static Expression from(Object value2, Expression base) {
        if (value2 instanceof Expression) {
            Expression exp = (Expression)value2;
            if (exp.isValueExpression() || base.isExpressionBuilder()) {
                exp.setLocalBase(base);
            } else {
                base.setLocalBase(exp);
            }
            return exp;
        }
        if (value2 instanceof ReportQuery) {
            Expression exp = base.subQuery((ReportQuery)value2);
            exp.setLocalBase(base);
            base.setLocalBase(exp);
            return exp;
        }
        return Expression.fromConstant(value2, base);
    }

    public static Expression fromConstant(Object value2, Expression base) {
        return new ConstantExpression(value2, base);
    }

    public static Expression fromLiteral(String value2, Expression base) {
        return new LiteralExpression(value2, base);
    }

    public Expression get(String attributeName) {
        return this.get(attributeName, true);
    }

    public Expression get(String attributeName, boolean forceInnerJoin) {
        throw new UnsupportedOperationException("get");
    }

    public Expression getAllowingNull(String attributeName) {
        throw new UnsupportedOperationException("getAllowingNull");
    }

    public AsOfClause getAsOfClause() {
        return null;
    }

    public AsOfClause getAsOfClauseRecursively() {
        return null;
    }

    public abstract ExpressionBuilder getBuilder();

    public DatabaseField getClonedField() {
        return null;
    }

    public Expression getField(String fieldName) {
        throw QueryException.illegalUseOfGetField(fieldName);
    }

    public Expression getField(DatabaseField field2) {
        throw QueryException.illegalUseOfGetField(field2);
    }

    public Vector getFields() {
        return NonSynchronizedVector.newInstance(1);
    }

    public List<DatabaseField> getSelectionFields() {
        return this.getSelectionFields(null);
    }

    public List<DatabaseField> getSelectionFields(ReadQuery query) {
        return this.getFields();
    }

    public Object getFieldValue(Object objectValue, AbstractSession session) {
        if (objectValue instanceof Enum) {
            return ((Enum)objectValue).ordinal();
        }
        return objectValue;
    }

    public Expression join(Expression target, Expression onClause) {
        throw new UnsupportedOperationException("join");
    }

    public Expression leftJoin(Expression target, Expression onClause) {
        throw new UnsupportedOperationException("leftJoin");
    }

    public Expression getFunction(int selector) {
        ExpressionOperator anOperator = this.getOperator(selector);
        return anOperator.expressionFor(this);
    }

    public Expression getFunction(int selector, List arguments) {
        ExpressionOperator anOperator = this.getOperator(selector);
        return anOperator.expressionForArguments(this, arguments);
    }

    public Expression operator(String name, List arguments) {
        Integer selector = ExpressionOperator.getPlatformOperatorSelectors().get(name);
        if (selector == null) {
            return this.getFunctionWithArguments(name, arguments);
        }
        return this.getFunction((int)selector, arguments);
    }

    @Deprecated
    public Expression getFunction(int selector, Vector arguments) {
        return this.getFunction(selector, (List)arguments);
    }

    public Expression getFunction(String functionName) {
        ExpressionOperator anOperator = ExpressionOperator.simpleFunction(0, functionName);
        return anOperator.expressionFor(this);
    }

    public Expression getFunction(String functionName, Object argument) {
        ExpressionOperator anOperator = ExpressionOperator.simpleTwoArgumentFunction(0, functionName);
        return anOperator.expressionFor(this, argument);
    }

    @Deprecated
    public Expression getFunctionWithArguments(String functionName, Vector arguments) {
        return this.getFunctionWithArguments(functionName, (List)arguments);
    }

    public Expression getFunctionWithArguments(String functionName, List arguments) {
        ExpressionOperator anOperator = new ExpressionOperator();
        anOperator.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(arguments.size());
        ((Vector)v).add(String.valueOf(functionName) + "(");
        int index2 = 0;
        while (index2 < arguments.size()) {
            ((Vector)v).add(", ");
            ++index2;
        }
        ((Vector)v).add(")");
        anOperator.printsAs(v);
        anOperator.bePrefix();
        anOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return anOperator.expressionForArguments(this, arguments);
    }

    public Expression sql(String sql, List arguments) {
        ExpressionOperator anOperator = new ExpressionOperator();
        anOperator.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(arguments.size());
        int start = 0;
        int index2 = sql.indexOf(63);
        while (index2 != -1) {
            ((Vector)v).add(sql.substring(start, index2));
            start = index2 + 1;
            index2 = sql.indexOf(63, start);
        }
        if (start <= sql.length()) {
            ((Vector)v).add(sql.substring(start, sql.length()));
        }
        anOperator.printsAs(v);
        anOperator.bePrefix();
        anOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return anOperator.expressionForArguments(this, arguments);
    }

    public Expression type() {
        return null;
    }

    public String getName() {
        return "";
    }

    public ExpressionOperator getOperator() {
        return null;
    }

    public ExpressionOperator getOperator(int selector) {
        ExpressionOperator result2 = ExpressionOperator.getOperator(selector);
        if (result2 != null) {
            return result2;
        }
        result2 = new ExpressionOperator();
        result2.setSelector(selector);
        result2.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result2;
    }

    public List<DatabaseTable> getOwnedTables() {
        return null;
    }

    public Expression getParameter(String parameterName, Object type) {
        return new ParameterExpression(parameterName, this.getBuilder(), type);
    }

    public Expression getParameter(String parameterName) {
        return new ParameterExpression(parameterName, this.getBuilder(), null);
    }

    public Expression getParameter(DatabaseField field2) {
        return new ParameterExpression(field2, this.getBuilder());
    }

    public Expression getProperty(DatabaseField field2) {
        ParameterExpression paramExpression = new ParameterExpression(field2, this);
        paramExpression.setIsProperty(true);
        return paramExpression;
    }

    public AbstractSession getSession() {
        return this.getBuilder().getSession();
    }

    public Expression getTable(String tableName) {
        DatabaseTable table = new DatabaseTable(tableName);
        return this.getTable(table);
    }

    public Expression getTable(DatabaseTable table) {
        throw QueryException.illegalUseOfGetTable(table);
    }

    public Expression getAlias(Expression subSelect) {
        throw QueryException.illegalUseOfGetTable(subSelect);
    }

    public TableAliasLookup getTableAliases() {
        return null;
    }

    public Expression greaterThan(byte theValue) {
        return this.greaterThan((Object)theValue);
    }

    public Expression greaterThan(char theChar) {
        return this.greaterThan(Character.valueOf(theChar));
    }

    public Expression greaterThan(double theValue) {
        return this.greaterThan((Object)theValue);
    }

    public Expression greaterThan(float theValue) {
        return this.greaterThan(Float.valueOf(theValue));
    }

    public Expression greaterThan(int theValue) {
        return this.greaterThan((Object)theValue);
    }

    public Expression greaterThan(long theValue) {
        return this.greaterThan((Object)theValue);
    }

    public Expression greaterThan(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(9);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression greaterThan(Expression theValue) {
        ExpressionOperator anOperator = this.getOperator(9);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression greaterThan(short theValue) {
        return this.greaterThan((Object)theValue);
    }

    public Expression greaterThan(boolean theBoolean) {
        return this.greaterThan((Object)theBoolean);
    }

    public Expression greaterThanEqual(byte theValue) {
        return this.greaterThanEqual((Object)theValue);
    }

    public Expression greaterThanEqual(char theChar) {
        return this.greaterThanEqual(Character.valueOf(theChar));
    }

    public Expression greaterThanEqual(double theValue) {
        return this.greaterThanEqual((Object)theValue);
    }

    public Expression greaterThanEqual(float theValue) {
        return this.greaterThanEqual(Float.valueOf(theValue));
    }

    public Expression greaterThanEqual(int theValue) {
        return this.greaterThanEqual((Object)theValue);
    }

    public Expression greaterThanEqual(long theValue) {
        return this.greaterThanEqual((Object)theValue);
    }

    public Expression greaterThanEqual(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(10);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression greaterThanEqual(Expression theValue) {
        ExpressionOperator anOperator = this.getOperator(10);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression greaterThanEqual(short theValue) {
        return this.greaterThanEqual((Object)theValue);
    }

    public Expression greaterThanEqual(boolean theBoolean) {
        return this.greaterThanEqual((Object)theBoolean);
    }

    public boolean hasAsOfClause() {
        return false;
    }

    public boolean hasBeenAliased() {
        return false;
    }

    public Expression hexToRaw() {
        ExpressionOperator anOperator = this.getOperator(32);
        return anOperator.expressionFor(this);
    }

    public Expression ifNull(Object nullValue) {
        ExpressionOperator anOperator = this.getOperator(104);
        return anOperator.expressionFor(this, nullValue);
    }

    public Expression in(byte[] theBytes) {
        ArrayList<Byte> values = new ArrayList<Byte>(theBytes.length);
        int index2 = 0;
        while (index2 < theBytes.length) {
            values.add(theBytes[index2]);
            ++index2;
        }
        return this.in(values);
    }

    public Expression in(char[] theChars) {
        ArrayList<Character> values = new ArrayList<Character>(theChars.length);
        int index2 = 0;
        while (index2 < theChars.length) {
            values.add(Character.valueOf(theChars[index2]));
            ++index2;
        }
        return this.in(values);
    }

    public Expression in(double[] theDoubles) {
        ArrayList<Double> values = new ArrayList<Double>(theDoubles.length);
        int index2 = 0;
        while (index2 < theDoubles.length) {
            values.add(theDoubles[index2]);
            ++index2;
        }
        return this.in(values);
    }

    public Expression in(float[] theFloats) {
        ArrayList<Float> values = new ArrayList<Float>(theFloats.length);
        int index2 = 0;
        while (index2 < theFloats.length) {
            values.add(Float.valueOf(theFloats[index2]));
            ++index2;
        }
        return this.in(values);
    }

    public Expression in(int[] theInts) {
        ArrayList<Integer> values = new ArrayList<Integer>(theInts.length);
        int index2 = 0;
        while (index2 < theInts.length) {
            values.add(theInts[index2]);
            ++index2;
        }
        return this.in(values);
    }

    public Expression in(long[] theLongs) {
        ArrayList<Long> values = new ArrayList<Long>(theLongs.length);
        int index2 = 0;
        while (index2 < theLongs.length) {
            values.add(theLongs[index2]);
            ++index2;
        }
        return this.in(values);
    }

    public Expression in(Object[] theObjects) {
        ArrayList<Object> values = new ArrayList<Object>(theObjects.length);
        int index2 = 0;
        while (index2 < theObjects.length) {
            values.add(theObjects[index2]);
            ++index2;
        }
        return this.in(values);
    }

    public Expression in(short[] theShorts) {
        ArrayList<Short> values = new ArrayList<Short>(theShorts.length);
        int index2 = 0;
        while (index2 < theShorts.length) {
            values.add(theShorts[index2]);
            ++index2;
        }
        return this.in(values);
    }

    public Expression in(boolean[] theBooleans) {
        ArrayList<Boolean> values = new ArrayList<Boolean>(theBooleans.length);
        int index2 = 0;
        while (index2 < theBooleans.length) {
            values.add(theBooleans[index2]);
            ++index2;
        }
        return this.in(values);
    }

    public Expression in(Collection theObjects) {
        return this.in(new CollectionExpression(theObjects, this));
    }

    public Expression in(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(13);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression in(ReportQuery subQuery) {
        ExpressionOperator anOperator = this.getOperator(129);
        return anOperator.expressionFor(this, subQuery);
    }

    public Expression index() {
        throw QueryException.indexRequiresQueryKeyExpression(this);
    }

    public Expression indexOf(Object substring) {
        ExpressionOperator anOperator = this.getOperator(34);
        return anOperator.expressionFor(this, substring);
    }

    public boolean isClassTypeExpression() {
        return false;
    }

    public boolean isCompoundExpression() {
        return false;
    }

    public boolean isConstantExpression() {
        return false;
    }

    public boolean isDataExpression() {
        return false;
    }

    public Expression isEmpty(String attributeName) {
        return this.size(attributeName).equal(0);
    }

    public boolean isExpressionBuilder() {
        return false;
    }

    public boolean isFieldExpression() {
        return false;
    }

    public boolean isFunctionExpression() {
        return false;
    }

    public boolean isLiteralExpression() {
        return false;
    }

    public boolean isLogicalExpression() {
        return false;
    }

    public Expression isNull() {
        ExpressionOperator anOperator = this.getOperator(17);
        return anOperator.expressionFor(this);
    }

    public boolean isObjectExpression() {
        return false;
    }

    public boolean isParameterExpression() {
        return false;
    }

    public boolean isQueryKeyExpression() {
        return false;
    }

    public boolean isRelationExpression() {
        return false;
    }

    public boolean isSubSelectExpression() {
        return false;
    }

    public boolean isTableExpression() {
        return false;
    }

    public boolean isTreatExpression() {
        return false;
    }

    public boolean isMapEntryExpression() {
        return false;
    }

    public boolean isValueExpression() {
        return false;
    }

    public void iterateOn(ExpressionIterator iterator2) {
        iterator2.iterate(this);
    }

    public Expression lastDay() {
        ExpressionOperator anOperator = this.getOperator(49);
        return anOperator.expressionFor(this);
    }

    public Expression leftPad(int size2, Object substring) {
        return this.leftPad((Object)size2, substring);
    }

    public Expression leftPad(Object size2, Object substring) {
        ExpressionOperator anOperator = this.getOperator(36);
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(size2);
        args.add(substring);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression leftTrim() {
        ExpressionOperator anOperator = this.getOperator(37);
        return anOperator.expressionFor(this);
    }

    public Expression leftTrim(Object substring) {
        ExpressionOperator anOperator = this.getOperator(122);
        return anOperator.expressionFor(this, substring);
    }

    public Expression length() {
        ExpressionOperator anOperator = this.getOperator(46);
        return anOperator.expressionFor(this);
    }

    public Expression lessThan(byte theValue) {
        return this.lessThan((Object)theValue);
    }

    public Expression lessThan(char theChar) {
        return this.lessThan(Character.valueOf(theChar));
    }

    public Expression lessThan(double theValue) {
        return this.lessThan((Object)theValue);
    }

    public Expression lessThan(float theValue) {
        return this.lessThan(Float.valueOf(theValue));
    }

    public Expression lessThan(int theValue) {
        return this.lessThan((Object)theValue);
    }

    public Expression lessThan(long theValue) {
        return this.lessThan((Object)theValue);
    }

    public Expression lessThan(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(7);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression lessThan(Expression theValue) {
        ExpressionOperator anOperator = this.getOperator(7);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression lessThan(short theValue) {
        return this.lessThan((Object)theValue);
    }

    public Expression lessThan(boolean theBoolean) {
        return this.lessThan((Object)theBoolean);
    }

    public Expression lessThanEqual(byte theValue) {
        return this.lessThanEqual((Object)theValue);
    }

    public Expression lessThanEqual(char theChar) {
        return this.lessThanEqual(Character.valueOf(theChar));
    }

    public Expression lessThanEqual(double theValue) {
        return this.lessThanEqual((Object)theValue);
    }

    public Expression lessThanEqual(float theValue) {
        return this.lessThanEqual(Float.valueOf(theValue));
    }

    public Expression lessThanEqual(int theValue) {
        return this.lessThanEqual((Object)theValue);
    }

    public Expression lessThanEqual(long theValue) {
        return this.lessThanEqual((Object)theValue);
    }

    public Expression lessThanEqual(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(8);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression lessThanEqual(Expression theValue) {
        ExpressionOperator anOperator = this.getOperator(8);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression lessThanEqual(short theValue) {
        return this.lessThanEqual((Object)theValue);
    }

    public Expression lessThanEqual(boolean theBoolean) {
        return this.lessThanEqual((Object)theBoolean);
    }

    public Expression like(String value2) {
        return this.like(new ConstantExpression(value2, this));
    }

    public Expression like(String value2, String escapeSequence) {
        ExpressionOperator anOperator = this.getOperator(89);
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(value2);
        args.add(escapeSequence);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression like(Expression argument) {
        ExpressionOperator anOperator = this.getOperator(11);
        return anOperator.expressionFor(this, argument);
    }

    public Expression regexp(String regexp) {
        return this.regexp(new ConstantExpression(regexp, this));
    }

    public Expression regexp(Expression regexp) {
        ExpressionOperator anOperator = this.getOperator(141);
        return anOperator.expressionFor(this, regexp);
    }

    public Expression like(Expression value2, Expression escapeSequence) {
        ExpressionOperator anOperator = this.getOperator(89);
        ArrayList<Expression> args = new ArrayList<Expression>(2);
        args.add(value2);
        args.add(escapeSequence);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression likeIgnoreCase(String theValue) {
        if (shouldUseUpperCaseForIgnoreCase) {
            return this.toUpperCase().like(theValue.toUpperCase());
        }
        return this.toLowerCase().like(theValue.toLowerCase());
    }

    public Expression likeIgnoreCase(Expression theValue) {
        if (shouldUseUpperCaseForIgnoreCase) {
            return this.toUpperCase().like(theValue.toUpperCase());
        }
        return this.toLowerCase().like(theValue.toLowerCase());
    }

    public Expression locate(Object str) {
        ExpressionOperator anOperator = this.getOperator(112);
        ArrayList<Object> args = new ArrayList<Object>(1);
        args.add(str);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression locate(String str, int fromIndex) {
        return this.locate((Object)str, (Object)fromIndex);
    }

    public Expression locate(Object str, Object fromIndex) {
        ExpressionOperator anOperator = this.getOperator(113);
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(str);
        args.add(fromIndex);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression maximum() {
        return this.getFunction(22);
    }

    public Expression minimum() {
        return this.getFunction(23);
    }

    public Expression monthsBetween(Object otherDate) {
        ExpressionOperator anOperator = this.getOperator(50);
        return anOperator.expressionFor(this, otherDate);
    }

    public Expression mapEntry() {
        MapEntryExpression expression = new MapEntryExpression(this);
        expression.returnMapEntry();
        return expression;
    }

    public Expression mapKey() {
        return new MapEntryExpression(this);
    }

    public Expression newTime(String timeZoneFrom, String timeZoneTo) {
        ExpressionOperator anOperator = this.getOperator(103);
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(timeZoneFrom);
        args.add(timeZoneTo);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression nextDay(Object dayName) {
        ExpressionOperator anOperator = this.getOperator(51);
        return anOperator.expressionFor(this, dayName);
    }

    public Expression noneOf(String attributeName, Expression criteria) {
        ReportQuery subQuery = new ReportQuery();
        subQuery.setShouldRetrieveFirstPrimaryKey(true);
        ExpressionBuilder builder = criteria.getBuilder();
        criteria = builder.equal(this.anyOf(attributeName)).and(criteria);
        subQuery.setSelectionCriteria(criteria);
        return this.notExists(subQuery);
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        this.validateNode();
        return this;
    }

    public Expression not() {
        ExpressionOperator anOperator = this.getOperator(3);
        return anOperator.expressionFor(this);
    }

    public Expression notBetween(byte leftValue, byte rightValue) {
        return this.notBetween((Object)leftValue, (Object)rightValue);
    }

    public Expression notBetween(char leftChar, char rightChar) {
        return this.notBetween(Character.valueOf(leftChar), Character.valueOf(rightChar));
    }

    public Expression notBetween(double leftValue, double rightValue) {
        return this.notBetween((Object)leftValue, (Object)rightValue);
    }

    public Expression notBetween(float leftValue, float rightValue) {
        return this.notBetween(Float.valueOf(leftValue), Float.valueOf(rightValue));
    }

    public Expression notBetween(int leftValue, int rightValue) {
        return this.notBetween((Object)leftValue, (Object)rightValue);
    }

    public Expression notBetween(long leftValue, long rightValue) {
        return this.notBetween((Object)leftValue, (Object)rightValue);
    }

    public Expression notBetween(Object leftValue, Object rightValue) {
        return this.between(leftValue, rightValue).not();
    }

    public Expression notBetween(Expression leftExpression, Expression rightExpression) {
        return this.between(leftExpression, rightExpression).not();
    }

    public Expression notBetween(short leftValue, short rightValue) {
        return this.notBetween((Object)leftValue, (Object)rightValue);
    }

    public Expression notEmpty(String attributeName) {
        return this.size(attributeName).greaterThan(0);
    }

    public Expression notEqual(byte theValue) {
        return this.notEqual((Object)theValue);
    }

    public Expression notEqual(char theChar) {
        return this.notEqual(Character.valueOf(theChar));
    }

    public Expression notEqual(double theValue) {
        return this.notEqual((Object)theValue);
    }

    public Expression notEqual(float theValue) {
        return this.notEqual(Float.valueOf(theValue));
    }

    public Expression notEqual(int theValue) {
        return this.notEqual((Object)theValue);
    }

    public Expression notEqual(long theValue) {
        return this.notEqual((Object)theValue);
    }

    public Expression notEqual(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(5);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression notEqual(Expression theValue) {
        ExpressionOperator anOperator = this.getOperator(5);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression notEqual(short theValue) {
        return this.notEqual((Object)theValue);
    }

    public Expression notEqual(boolean theBoolean) {
        return this.notEqual((Object)theBoolean);
    }

    public Expression notExists(ReportQuery subQuery) {
        ExpressionOperator anOperator = this.getOperator(88);
        return anOperator.expressionFor(this.subQuery(subQuery));
    }

    public Expression notIn(byte[] theBytes) {
        ArrayList<Byte> values = new ArrayList<Byte>(theBytes.length);
        int index2 = 0;
        while (index2 < theBytes.length) {
            values.add(theBytes[index2]);
            ++index2;
        }
        return this.notIn(values);
    }

    public Expression notIn(char[] theChars) {
        ArrayList<Character> values = new ArrayList<Character>(theChars.length);
        int index2 = 0;
        while (index2 < theChars.length) {
            values.add(Character.valueOf(theChars[index2]));
            ++index2;
        }
        return this.notIn(values);
    }

    public Expression notIn(double[] theDoubles) {
        ArrayList<Double> values = new ArrayList<Double>(theDoubles.length);
        int index2 = 0;
        while (index2 < theDoubles.length) {
            values.add(theDoubles[index2]);
            ++index2;
        }
        return this.notIn(values);
    }

    public Expression notIn(float[] theFloats) {
        ArrayList<Float> values = new ArrayList<Float>(theFloats.length);
        int index2 = 0;
        while (index2 < theFloats.length) {
            values.add(Float.valueOf(theFloats[index2]));
            ++index2;
        }
        return this.notIn(values);
    }

    public Expression notIn(int[] theInts) {
        ArrayList<Integer> values = new ArrayList<Integer>(theInts.length);
        int index2 = 0;
        while (index2 < theInts.length) {
            values.add(theInts[index2]);
            ++index2;
        }
        return this.notIn(values);
    }

    public Expression notIn(long[] theLongs) {
        ArrayList<Long> values = new ArrayList<Long>(theLongs.length);
        int index2 = 0;
        while (index2 < theLongs.length) {
            values.add(theLongs[index2]);
            ++index2;
        }
        return this.notIn(values);
    }

    public Expression notIn(Object[] theObjects) {
        ArrayList<Object> values = new ArrayList<Object>(theObjects.length);
        int index2 = 0;
        while (index2 < theObjects.length) {
            values.add(theObjects[index2]);
            ++index2;
        }
        return this.notIn(values);
    }

    public Expression notIn(ReportQuery subQuery) {
        ExpressionOperator anOperator = this.getOperator(130);
        return anOperator.expressionFor(this, subQuery);
    }

    public Expression notIn(short[] theShorts) {
        ArrayList<Short> values = new ArrayList<Short>(theShorts.length);
        int index2 = 0;
        while (index2 < theShorts.length) {
            values.add(theShorts[index2]);
            ++index2;
        }
        return this.notIn(values);
    }

    public Expression notIn(boolean[] theBooleans) {
        ArrayList<Boolean> values = new ArrayList<Boolean>(theBooleans.length);
        int index2 = 0;
        while (index2 < theBooleans.length) {
            values.add(theBooleans[index2]);
            ++index2;
        }
        return this.notIn(values);
    }

    public Expression notIn(Collection theObjects) {
        return this.notIn(new CollectionExpression(theObjects, this));
    }

    public Expression notIn(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(14);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression notLike(String aString) {
        return this.notLike(new ConstantExpression(aString, this));
    }

    public Expression notLike(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(12);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression notLike(String value2, String escapeSequence) {
        ExpressionOperator anOperator = this.getOperator(134);
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(value2);
        args.add(escapeSequence);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression notLike(Expression value2, Expression escapeSequence) {
        ExpressionOperator anOperator = this.getOperator(134);
        ArrayList<Expression> args = new ArrayList<Expression>(2);
        args.add(value2);
        args.add(escapeSequence);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression notNull() {
        ExpressionOperator anOperator = this.getOperator(18);
        return anOperator.expressionFor(this);
    }

    public Expression or(Expression theExpression) {
        if (theExpression == null) {
            return this;
        }
        ExpressionBuilder base = this.getBuilder();
        Expression expressionToUse = theExpression;
        if (theExpression.getBuilder() != base && theExpression.getBuilder().getQueryClass() == null) {
            expressionToUse = theExpression.rebuildOn(base);
        }
        if (base == this) {
            return expressionToUse;
        }
        ExpressionOperator anOperator = this.getOperator(2);
        return anOperator.expressionFor(this, expressionToUse);
    }

    public Expression performOperator(ExpressionOperator anOperator, List args) {
        return anOperator.expressionForArguments(this, args);
    }

    protected void postCopyIn(Map alreadyDone) {
    }

    public Expression postfixSQL(String sqlString) {
        ExpressionOperator anOperator = new ExpressionOperator();
        anOperator.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(1);
        ((Vector)v).add(sqlString);
        anOperator.printsAs(v);
        anOperator.bePostfix();
        anOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return anOperator.expressionFor(this);
    }

    public Expression prefixSQL(String sqlString) {
        ExpressionOperator anOperator = new ExpressionOperator();
        anOperator.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(1);
        ((Vector)v).add(sqlString);
        anOperator.printsAs(v);
        anOperator.bePrefix();
        anOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return anOperator.expressionFor(this);
    }

    public abstract void printSQL(ExpressionSQLPrinter var1);

    public void printJava(ExpressionJavaPrinter printer) {
    }

    public abstract Expression rebuildOn(Expression var1);

    public abstract void resetPlaceHolderBuilder(ExpressionBuilder var1);

    public Expression ref() {
        return this.getFunction(83);
    }

    protected Expression registerIn(Map alreadyDone) {
        Expression copy = this.shallowClone();
        alreadyDone.put(this, copy);
        copy.postCopyIn(alreadyDone);
        return copy;
    }

    public Expression replace(Object stringToReplace, Object stringToReplaceWith) {
        ExpressionOperator anOperator = this.getOperator(38);
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(stringToReplace);
        args.add(stringToReplaceWith);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression replicate(int constant) {
        return this.replicate((Object)constant);
    }

    public Expression replicate(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(100);
        return anOperator.expressionFor(this, theValue);
    }

    protected void resetCache() {
    }

    public Expression reverse() {
        return this.getFunction(99);
    }

    public Expression right(int characters2) {
        return this.right((Object)characters2);
    }

    public Expression right(Object characters2) {
        ExpressionOperator anOperator = this.getOperator(101);
        return anOperator.expressionFor(this, characters2);
    }

    public Expression rightPad(int size2, Object substring) {
        return this.rightPad((Object)size2, substring);
    }

    public Expression rightPad(Object size2, Object substring) {
        ExpressionOperator anOperator = this.getOperator(39);
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(size2);
        args.add(substring);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression rightTrim() {
        ExpressionOperator anOperator = this.getOperator(40);
        return anOperator.expressionFor(this);
    }

    public Expression rightTrim(Object substring) {
        ExpressionOperator anOperator = this.getOperator(116);
        return anOperator.expressionFor(this, substring);
    }

    public Expression roundDate(Object yearOrMonthOrDayRoundToken) {
        ExpressionOperator anOperator = this.getOperator(52);
        return anOperator.expressionFor(this, yearOrMonthOrDayRoundToken);
    }

    public boolean selectIfOrderedBy() {
        return this.selectIfOrderedBy;
    }

    public void setLocalBase(Expression exp) {
    }

    public void setSelectIfOrderedBy(boolean selectIfOrderedBy) {
        this.selectIfOrderedBy = selectIfOrderedBy;
    }

    public Expression shallowClone() {
        Expression result2 = null;
        try {
            result2 = (Expression)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.toString());
        }
        return result2;
    }

    public Expression size(String attributeName) {
        return SubSelectExpression.createSubSelectExpressionForCount(this, this, attributeName, null);
    }

    public Expression size(Class returnType) {
        if (((BaseExpression)this).getBaseExpression() == null) {
            return SubSelectExpression.createSubSelectExpressionForCount(this, this, null, returnType);
        }
        return SubSelectExpression.createSubSelectExpressionForCount(((BaseExpression)this).getBaseExpression(), this, null, returnType);
    }

    public Expression standardDeviation() {
        return this.getFunction(24);
    }

    public Expression subQuery(ReportQuery subQuery) {
        return new SubSelectExpression(subQuery, this);
    }

    public Expression substring(int startPosition, int size2) {
        return this.substring((Object)startPosition, (Object)size2);
    }

    public Expression substring(Object startPosition, Object size2) {
        ExpressionOperator anOperator = this.getOperator(41);
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(startPosition);
        args.add(size2);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression substring(int startPosition) {
        return this.substring((Object)startPosition);
    }

    public Expression substring(Object startPosition) {
        ExpressionOperator anOperator = this.getOperator(133);
        ArrayList<Object> args = new ArrayList<Object>(1);
        args.add(startPosition);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression sum() {
        return this.getFunction(20);
    }

    public Expression toCharacter() {
        ExpressionOperator anOperator = this.getOperator(30);
        return anOperator.expressionFor(this);
    }

    public Expression toDate() {
        ExpressionOperator anOperator = this.getOperator(53);
        return anOperator.expressionFor(this);
    }

    public Expression toChar() {
        ExpressionOperator anOperator = this.getOperator(114);
        return anOperator.expressionFor(this);
    }

    public Expression toChar(String format2) {
        ExpressionOperator anOperator = this.getOperator(115);
        return anOperator.expressionFor(this, format2);
    }

    public Expression toLowerCase() {
        ExpressionOperator anOperator = this.getOperator(29);
        return anOperator.expressionFor(this);
    }

    public Expression toNumber() {
        ExpressionOperator anOperator = this.getOperator(42);
        return anOperator.expressionFor(this);
    }

    public String toString() {
        try {
            StringWriter innerWriter = new StringWriter();
            BufferedWriter outerWriter = new BufferedWriter(innerWriter);
            this.toString(outerWriter, 0);
            outerWriter.flush();
            return innerWriter.toString();
        }
        catch (IOException iOException) {
            return ToStringLocalization.buildMessage("error_printing_expression", null);
        }
    }

    public void toString(BufferedWriter writer, int indent) throws IOException {
        writer.newLine();
        int i = 0;
        while (i < indent) {
            writer.write("   ");
            ++i;
        }
        writer.write(this.descriptionOfNodeType());
        writer.write(" ");
        this.writeDescriptionOn(writer);
        this.writeSubexpressionsTo(writer, indent + 1);
    }

    public Expression toUpperCase() {
        ExpressionOperator anOperator = this.getOperator(28);
        return anOperator.expressionFor(this);
    }

    public Expression toUppercaseCasedWords() {
        ExpressionOperator anOperator = this.getOperator(33);
        return anOperator.expressionFor(this);
    }

    public Expression translate(Object fromString, Object toString2) {
        ExpressionOperator anOperator = this.getOperator(43);
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(fromString);
        args.add(toString2);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression trim() {
        ExpressionOperator anOperator = this.getOperator(44);
        return anOperator.expressionFor(this);
    }

    public Expression trim(Object substring) {
        ExpressionOperator anOperator = this.getOperator(121);
        return anOperator.expressionForWithBaseLast(this, substring);
    }

    public Expression extractXml(String xpath) {
        ExpressionOperator anOperator = this.getOperator(106);
        return anOperator.expressionFor(this, xpath);
    }

    public Expression extract(String part) {
        ExpressionOperator anOperator = this.getOperator(138);
        return anOperator.expressionFor(this, this.literal(part));
    }

    public Expression cast(String type) {
        ExpressionOperator anOperator = this.getOperator(137);
        return anOperator.expressionFor(this, this.literal(type));
    }

    public Expression extractValue(String xpath) {
        ExpressionOperator anOperator = this.getOperator(107);
        return anOperator.expressionFor(this, xpath);
    }

    public Expression existsNode(String xpath) {
        ExpressionOperator anOperator = this.getOperator(108);
        return anOperator.expressionFor(this, xpath);
    }

    public Expression isFragment() {
        ExpressionOperator anOperator = this.getOperator(111);
        return anOperator.expressionFor(this);
    }

    public Expression getStringVal() {
        ExpressionOperator anOperator = this.getOperator(109);
        return anOperator.expressionFor(this);
    }

    public Expression getNumberVal() {
        ExpressionOperator anOperator = this.getOperator(110);
        return anOperator.expressionFor(this);
    }

    public Expression truncateDate(String datePart) {
        ExpressionOperator anOperator = this.getOperator(102);
        return anOperator.expressionFor(this, datePart);
    }

    public Expression twist(Expression expression, Expression newBase) {
        if (expression == null) {
            return null;
        }
        return expression.twistedForBaseAndContext(newBase, this, null);
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        return this;
    }

    public void validateNode() {
    }

    public Expression value() {
        ExpressionOperator anOperator = this.getOperator(85);
        return anOperator.expressionFor(this);
    }

    public Expression value(byte constant) {
        return this.value((Object)constant);
    }

    public Expression value(char constant) {
        return this.value(Character.valueOf(constant));
    }

    public Expression value(double constant) {
        return this.value((Object)constant);
    }

    public Expression value(float constant) {
        return this.value(Float.valueOf(constant));
    }

    public Expression value(int constant) {
        return this.value((Object)constant);
    }

    public Expression value(long constant) {
        return this.value((Object)constant);
    }

    public Expression value(Object constant) {
        return new ConstantExpression(constant, this);
    }

    public Expression value(short constant) {
        return this.value((Object)constant);
    }

    public Expression value(boolean constant) {
        return this.value((Object)constant);
    }

    public Expression literal(String literal) {
        return new LiteralExpression(literal, this);
    }

    public Expression alias(String alias) {
        return this.literal(alias);
    }

    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        throw QueryException.cannotConformExpression();
    }

    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy) {
        return this.valueFromObject(object, session, translationRow, valueHolderPolicy, false);
    }

    public Expression variance() {
        return this.getFunction(25);
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write("some expression");
    }

    protected void writeField(ExpressionSQLPrinter printer, DatabaseField field2, SQLSelectStatement statement) {
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        if (statement.requiresAliases()) {
            if (field2.getTable() != this.lastTable) {
                this.lastTable = field2.getTable();
                this.currentAlias = this.aliasForTable(this.lastTable);
            }
            printer.printString(this.currentAlias.getQualifiedNameDelimited(printer.getPlatform()));
            printer.printString(".");
        }
        printer.printString(field2.getNameDelimited(printer.getPlatform()));
        if (statement.getUseUniqueFieldAliases()) {
            printer.printString(" AS " + statement.generatedAlias(field2.getNameDelimited(printer.getPlatform())));
        }
    }

    protected void writeAlias(ExpressionSQLPrinter printer, DatabaseField field2, SQLSelectStatement statement) {
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        if (statement.requiresAliases()) {
            if (field2.getTable() != this.lastTable) {
                this.lastTable = field2.getTable();
                this.currentAlias = this.aliasForTable(this.lastTable);
            }
            printer.printString(this.currentAlias.getQualifiedNameDelimited(printer.getPlatform()));
        } else {
            printer.printString(field2.getTable().getQualifiedNameDelimited(printer.getPlatform()));
        }
    }

    public void writeFields(ExpressionSQLPrinter printer, Vector newFields, SQLSelectStatement statement) {
        for (DatabaseField field2 : this.getSelectionFields(statement.getQuery())) {
            newFields.add(field2);
            this.writeField(printer, field2, statement);
        }
    }

    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
    }

    public Expression any(byte[] theBytes) {
        ArrayList<Byte> values = new ArrayList<Byte>(theBytes.length);
        int index2 = 0;
        while (index2 < theBytes.length) {
            values.add(theBytes[index2]);
            ++index2;
        }
        return this.any(values);
    }

    public Expression any(char[] theChars) {
        ArrayList<Character> values = new ArrayList<Character>(theChars.length);
        int index2 = 0;
        while (index2 < theChars.length) {
            values.add(Character.valueOf(theChars[index2]));
            ++index2;
        }
        return this.any(values);
    }

    public Expression any(double[] theDoubles) {
        ArrayList<Double> values = new ArrayList<Double>(theDoubles.length);
        int index2 = 0;
        while (index2 < theDoubles.length) {
            values.add(theDoubles[index2]);
            ++index2;
        }
        return this.any(values);
    }

    public Expression any(float[] theFloats) {
        ArrayList<Float> values = new ArrayList<Float>(theFloats.length);
        int index2 = 0;
        while (index2 < theFloats.length) {
            values.add(Float.valueOf(theFloats[index2]));
            ++index2;
        }
        return this.any(values);
    }

    public Expression any(int[] theInts) {
        ArrayList<Integer> values = new ArrayList<Integer>(theInts.length);
        int index2 = 0;
        while (index2 < theInts.length) {
            values.add(theInts[index2]);
            ++index2;
        }
        return this.any(values);
    }

    public Expression any(long[] theLongs) {
        ArrayList<Long> values = new ArrayList<Long>(theLongs.length);
        int index2 = 0;
        while (index2 < theLongs.length) {
            values.add(theLongs[index2]);
            ++index2;
        }
        return this.any(values);
    }

    public Expression any(Object[] theObjects) {
        ArrayList<Object> values = new ArrayList<Object>(theObjects.length);
        int index2 = 0;
        while (index2 < theObjects.length) {
            values.add(theObjects[index2]);
            ++index2;
        }
        return this.any(values);
    }

    public Expression any(short[] theShorts) {
        ArrayList<Short> values = new ArrayList<Short>(theShorts.length);
        int index2 = 0;
        while (index2 < theShorts.length) {
            values.add(theShorts[index2]);
            ++index2;
        }
        return this.any(values);
    }

    public Expression any(boolean[] theBooleans) {
        ArrayList<Boolean> values = new ArrayList<Boolean>(theBooleans.length);
        int index2 = 0;
        while (index2 < theBooleans.length) {
            values.add(theBooleans[index2]);
            ++index2;
        }
        return this.any(values);
    }

    @Deprecated
    public Expression any(Vector theObjects) {
        return this.any((List)theObjects);
    }

    public Expression any(List theObjects) {
        return this.any(new ConstantExpression(theObjects, this));
    }

    public Expression any(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(118);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression union(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(142);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression intersect(ReportQuery query) {
        return this.intersect(this.subQuery(query));
    }

    public Expression intersectAll(ReportQuery query) {
        return this.intersectAll(this.subQuery(query));
    }

    public Expression intersect(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(144);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression except(ReportQuery query) {
        return this.except(this.subQuery(query));
    }

    public Expression exceptAll(ReportQuery query) {
        return this.exceptAll(this.subQuery(query));
    }

    public Expression except(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(146);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression union(ReportQuery query) {
        return this.union(this.subQuery(query));
    }

    public Expression unionAll(ReportQuery query) {
        return this.unionAll(this.subQuery(query));
    }

    public Expression unionAll(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(143);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression intersectAll(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(145);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression exceptAll(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(147);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression any(ReportQuery subQuery) {
        return this.any(this.subQuery(subQuery));
    }

    public Expression some(byte[] theBytes) {
        ArrayList<Byte> values = new ArrayList<Byte>(theBytes.length);
        int index2 = 0;
        while (index2 < theBytes.length) {
            values.add(theBytes[index2]);
            ++index2;
        }
        return this.some(values);
    }

    public Expression some(char[] theChars) {
        ArrayList<Character> values = new ArrayList<Character>(theChars.length);
        int index2 = 0;
        while (index2 < theChars.length) {
            values.add(Character.valueOf(theChars[index2]));
            ++index2;
        }
        return this.some(values);
    }

    public Expression some(double[] theDoubles) {
        ArrayList<Double> values = new ArrayList<Double>(theDoubles.length);
        int index2 = 0;
        while (index2 < theDoubles.length) {
            values.add(theDoubles[index2]);
            ++index2;
        }
        return this.some(values);
    }

    public Expression some(float[] theFloats) {
        ArrayList<Float> values = new ArrayList<Float>(theFloats.length);
        int index2 = 0;
        while (index2 < theFloats.length) {
            values.add(Float.valueOf(theFloats[index2]));
            ++index2;
        }
        return this.some(values);
    }

    public Expression some(int[] theInts) {
        ArrayList<Integer> values = new ArrayList<Integer>(theInts.length);
        int index2 = 0;
        while (index2 < theInts.length) {
            values.add(theInts[index2]);
            ++index2;
        }
        return this.some(values);
    }

    public Expression some(long[] theLongs) {
        ArrayList<Long> values = new ArrayList<Long>(theLongs.length);
        int index2 = 0;
        while (index2 < theLongs.length) {
            values.add(theLongs[index2]);
            ++index2;
        }
        return this.some(values);
    }

    public Expression some(Object[] theObjects) {
        ArrayList<Object> values = new ArrayList<Object>(theObjects.length);
        int index2 = 0;
        while (index2 < theObjects.length) {
            values.add(theObjects[index2]);
            ++index2;
        }
        return this.some(values);
    }

    public Expression some(short[] theShorts) {
        ArrayList<Short> values = new ArrayList<Short>(theShorts.length);
        int index2 = 0;
        while (index2 < theShorts.length) {
            values.add(theShorts[index2]);
            ++index2;
        }
        return this.some(values);
    }

    public Expression some(boolean[] theBooleans) {
        ArrayList<Boolean> values = new ArrayList<Boolean>(theBooleans.length);
        int index2 = 0;
        while (index2 < theBooleans.length) {
            values.add(theBooleans[index2]);
            ++index2;
        }
        return this.some(values);
    }

    @Deprecated
    public Expression some(Vector theObjects) {
        return this.some(new ConstantExpression(theObjects, this));
    }

    public Expression some(List theObjects) {
        return this.some(new ConstantExpression(theObjects, this));
    }

    public Expression some(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(119);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression some(ReportQuery subQuery) {
        return this.some(this.subQuery(subQuery));
    }

    public Expression all(byte[] theBytes) {
        ArrayList<Byte> values = new ArrayList<Byte>(theBytes.length);
        int index2 = 0;
        while (index2 < theBytes.length) {
            values.add(theBytes[index2]);
            ++index2;
        }
        return this.all(values);
    }

    public Expression all(char[] theChars) {
        ArrayList<Character> values = new ArrayList<Character>(theChars.length);
        int index2 = 0;
        while (index2 < theChars.length) {
            values.add(Character.valueOf(theChars[index2]));
            ++index2;
        }
        return this.all(values);
    }

    public Expression all(double[] theDoubles) {
        ArrayList<Double> values = new ArrayList<Double>(theDoubles.length);
        int index2 = 0;
        while (index2 < theDoubles.length) {
            values.add(theDoubles[index2]);
            ++index2;
        }
        return this.all(values);
    }

    public Expression all(float[] theFloats) {
        ArrayList<Float> values = new ArrayList<Float>(theFloats.length);
        int index2 = 0;
        while (index2 < theFloats.length) {
            values.add(Float.valueOf(theFloats[index2]));
            ++index2;
        }
        return this.all(values);
    }

    public Expression all(int[] theInts) {
        ArrayList<Integer> values = new ArrayList<Integer>(theInts.length);
        int index2 = 0;
        while (index2 < theInts.length) {
            values.add(theInts[index2]);
            ++index2;
        }
        return this.all(values);
    }

    public Expression all(long[] theLongs) {
        ArrayList<Long> values = new ArrayList<Long>(theLongs.length);
        int index2 = 0;
        while (index2 < theLongs.length) {
            values.add(theLongs[index2]);
            ++index2;
        }
        return this.all(values);
    }

    public Expression all(Object[] theObjects) {
        ArrayList<Object> values = new ArrayList<Object>(theObjects.length);
        int index2 = 0;
        while (index2 < theObjects.length) {
            values.add(theObjects[index2]);
            ++index2;
        }
        return this.all(values);
    }

    public Expression all(short[] theShorts) {
        ArrayList<Short> values = new ArrayList<Short>(theShorts.length);
        int index2 = 0;
        while (index2 < theShorts.length) {
            values.add(theShorts[index2]);
            ++index2;
        }
        return this.all(values);
    }

    public Expression all(boolean[] theBooleans) {
        ArrayList<Boolean> values = new ArrayList<Boolean>(theBooleans.length);
        int index2 = 0;
        while (index2 < theBooleans.length) {
            values.add(theBooleans[index2]);
            ++index2;
        }
        return this.all(values);
    }

    @Deprecated
    public Expression all(Vector theObjects) {
        return this.all((List)theObjects);
    }

    public Expression all(List theObjects) {
        return this.all(new ConstantExpression(theObjects, this));
    }

    public Expression all(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(120);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression all(ReportQuery subQuery) {
        return this.all(this.subQuery(subQuery));
    }

    public ClassDescriptor getLeafDescriptor(DatabaseQuery query, ClassDescriptor rootDescriptor, AbstractSession session) {
        return null;
    }

    public DatabaseMapping getLeafMapping(DatabaseQuery query, ClassDescriptor rootDescriptor, AbstractSession session) {
        return null;
    }
}

