/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.changetracking;

import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangeTrackingPolicy;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AggregateAttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.FetchGroup;

public class AttributeChangeTrackingPolicy
extends ObjectChangeTrackingPolicy {
    @Override
    public ObjectChangeSet calculateChangesForExistingObject(Object clone2, UnitOfWorkChangeSet changeSet, UnitOfWorkImpl unitOfWork, ClassDescriptor descriptor, boolean shouldRaiseEvent) {
        return this.calculateChanges(clone2, null, false, changeSet, unitOfWork, descriptor, shouldRaiseEvent);
    }

    @Override
    public ObjectChangeSet createObjectChangeSet(Object clone2, Object backUp, UnitOfWorkChangeSet changeSet, boolean isNew, AbstractSession session, ClassDescriptor descriptor) {
        ObjectChangeSet changes = null;
        if (!isNew) {
            AttributeChangeListener listener = (AttributeChangeListener)((ChangeTracker)clone2)._persistence_getPropertyChangeListener();
            if (listener != null) {
                changes = listener.getObjectChangeSet();
            }
            if (changes != null) {
                if (changes.getUOWChangeSet() != changeSet) {
                    changes = changeSet.mergeObjectChanges(changes, (UnitOfWorkChangeSet)changes.getUOWChangeSet());
                }
                if (changes.hasDeferredAttributes()) {
                    Iterator<String> iterator2 = changes.getDeferredSet().iterator();
                    while (iterator2.hasNext()) {
                        DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(iterator2.next());
                        mapping.calculateDeferredChanges((ChangeRecord)changes.getChangesForAttributeNamed(mapping.getAttributeName()), session);
                    }
                    changes.getDeferredSet().clear();
                }
            } else {
                changes = descriptor.getObjectBuilder().createObjectChangeSet(clone2, changeSet, isNew, session);
            }
        } else {
            changes = descriptor.getObjectBuilder().createObjectChangeSet(clone2, changeSet, isNew, true, session);
            if (descriptor.shouldUseFullChangeSetsForNewObjects() || descriptor.isAggregateDescriptor()) {
                FetchGroup fetchGroup = null;
                if (descriptor.hasFetchGroupManager()) {
                    fetchGroup = descriptor.getFetchGroupManager().getObjectFetchGroup(clone2);
                }
                Vector<DatabaseMapping> mappings = descriptor.getMappings();
                int size2 = mappings.size();
                int index2 = 0;
                while (index2 < size2) {
                    DatabaseMapping mapping = (DatabaseMapping)mappings.get(index2);
                    if (fetchGroup == null || fetchGroup.containsAttributeInternal(mapping.getAttributeName())) {
                        changes.addChange(mapping.compareForChange(clone2, null, changes, session));
                    }
                    ++index2;
                }
            }
        }
        if (descriptor.usesOptimisticLocking() && changes.getId() != null) {
            changes.setOptimisticLockingPolicyAndInitialWriteLockValue(descriptor.getOptimisticLockingPolicy(), session);
        }
        return changes;
    }

    @Override
    public boolean isAttributeChangeTrackingPolicy() {
        return true;
    }

    @Override
    public void updateWithChanges(Object object, ObjectChangeSet changeSet, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
        this.clearChanges(object, uow, descriptor, false);
    }

    @Override
    public void updateListenerForSelfMerge(ObjectChangeListener listener, ForeignReferenceMapping mapping, Object source, Object target, UnitOfWorkImpl unitOfWork) {
        ChangeRecord record = (ChangeRecord)((AttributeChangeListener)listener).getObjectChangeSet().getChangesForAttributeNamed(mapping.getAttributeName());
        mapping.updateChangeRecordForSelfMerge(record, source, target, (UnitOfWorkChangeSet)((AttributeChangeListener)listener).getObjectChangeSet().getUOWChangeSet(), unitOfWork);
    }

    @Override
    public void revertChanges(Object clone2, ClassDescriptor descriptor, UnitOfWorkImpl uow, Map cloneMapping, boolean forRefresh) {
        this.clearChanges(clone2, uow, descriptor, forRefresh);
        cloneMapping.put(clone2, clone2);
    }

    @Override
    public void setAggregateChangeListener(Object parent, Object aggregate, UnitOfWorkImpl uow, ClassDescriptor descriptor, String mappingAttribute) {
        ((ChangeTracker)aggregate)._persistence_setPropertyChangeListener(new AggregateAttributeChangeListener(descriptor, uow, (AttributeChangeListener)((ChangeTracker)parent)._persistence_getPropertyChangeListener(), mappingAttribute, aggregate));
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            AggregateObjectMapping aggregateMapping;
            Object nestedAggregate;
            if (!mapping.isAggregateObjectMapping() || (nestedAggregate = (aggregateMapping = (AggregateObjectMapping)mapping).getAttributeValueFromObject(aggregate)) == null || !(nestedAggregate instanceof ChangeTracker)) continue;
            descriptor.getObjectChangePolicy().setAggregateChangeListener(aggregate, nestedAggregate, uow, aggregateMapping.getReferenceDescriptor(), aggregateMapping.getAttributeName());
        }
    }

    @Override
    public PropertyChangeListener setChangeListener(Object clone2, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
        AttributeChangeListener listener = new AttributeChangeListener(descriptor, uow, clone2);
        ((ChangeTracker)clone2)._persistence_setPropertyChangeListener(listener);
        return listener;
    }

    @Override
    public void setChangeSetOnListener(ObjectChangeSet objectChangeSet, Object clone2) {
        ((AttributeChangeListener)((ChangeTracker)clone2)._persistence_getPropertyChangeListener()).setObjectChangeSet(objectChangeSet);
    }

    @Override
    public Object buildBackupClone(Object clone2, ObjectBuilder builder, UnitOfWorkImpl uow) {
        return clone2;
    }
}

