/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.cli;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Arg;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.shell.BourneShell;
import org.codehaus.plexus.util.cli.shell.CmdShell;
import org.codehaus.plexus.util.cli.shell.CommandShell;
import org.codehaus.plexus.util.cli.shell.Shell;

public class Commandline
implements Cloneable {
    protected static final String OS_NAME = "os.name";
    protected static final String WINDOWS = "Windows";
    protected Vector arguments = new Vector();
    protected Map envVars = Collections.synchronizedMap(new LinkedHashMap());
    private long pid = -1L;
    private Shell shell;
    protected String executable;
    private File workingDir;

    public Commandline(String toProcess, Shell shell) {
        this.shell = shell;
        String[] tmp = new String[]{};
        try {
            tmp = CommandLineUtils.translateCommandline(toProcess);
        }
        catch (Exception e) {
            System.err.println("Error translating Commandline.");
        }
        if (tmp != null && tmp.length > 0) {
            this.setExecutable(tmp[0]);
            for (int i = 1; i < tmp.length; ++i) {
                this.createArgument().setValue(tmp[i]);
            }
        }
    }

    public Commandline(Shell shell) {
        this.shell = shell;
    }

    public Commandline(String toProcess) {
        this.setDefaultShell();
        String[] tmp = new String[]{};
        try {
            tmp = CommandLineUtils.translateCommandline(toProcess);
        }
        catch (Exception e) {
            System.err.println("Error translating Commandline.");
        }
        if (tmp != null && tmp.length > 0) {
            this.setExecutable(tmp[0]);
            for (int i = 1; i < tmp.length; ++i) {
                this.createArgument().setValue(tmp[i]);
            }
        }
    }

    public Commandline() {
        this.setDefaultShell();
    }

    public long getPid() {
        if (this.pid == -1L) {
            this.pid = Long.parseLong(String.valueOf(System.currentTimeMillis()));
        }
        return this.pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    private void setDefaultShell() {
        if (Os.isFamily("windows")) {
            if (Os.isFamily("win9x")) {
                this.setShell(new CommandShell());
            } else {
                this.setShell(new CmdShell());
            }
        } else {
            this.setShell(new BourneShell());
        }
    }

    public Argument createArgument() {
        return this.createArgument(false);
    }

    public Argument createArgument(boolean insertAtStart) {
        Argument argument = new Argument();
        if (insertAtStart) {
            this.arguments.insertElementAt(argument, 0);
        } else {
            this.arguments.addElement(argument);
        }
        return argument;
    }

    public Arg createArg() {
        return this.createArg(false);
    }

    public Arg createArg(boolean insertAtStart) {
        Argument argument = new Argument();
        if (insertAtStart) {
            this.arguments.insertElementAt(argument, 0);
        } else {
            this.arguments.addElement(argument);
        }
        return argument;
    }

    public void addArg(Arg argument) {
        this.addArg(argument, false);
    }

    public void addArg(Arg argument, boolean insertAtStart) {
        if (insertAtStart) {
            this.arguments.insertElementAt(argument, 0);
        } else {
            this.arguments.addElement(argument);
        }
    }

    public void setExecutable(String executable) {
        this.shell.setExecutable(executable);
        this.executable = executable;
    }

    public String getExecutable() {
        String exec = this.shell.getExecutable();
        if (exec == null) {
            exec = this.executable;
        }
        return exec;
    }

    public void addArguments(String[] line) {
        for (int i = 0; i < line.length; ++i) {
            this.createArgument().setValue(line[i]);
        }
    }

    public void addEnvironment(String name, String value2) {
        this.envVars.put(name, value2);
    }

    public void addSystemEnvironment() throws Exception {
        Properties systemEnvVars = CommandLineUtils.getSystemEnvVars();
        for (String string2 : systemEnvVars.keySet()) {
            if (this.envVars.containsKey(string2)) continue;
            this.addEnvironment(string2, systemEnvVars.getProperty(string2));
        }
    }

    public String[] getEnvironmentVariables() throws CommandLineException {
        try {
            this.addSystemEnvironment();
        }
        catch (Exception e) {
            throw new CommandLineException("Error setting up environmental variables", e);
        }
        String[] environmentVars = new String[this.envVars.size()];
        int i = 0;
        for (String name : this.envVars.keySet()) {
            String value2 = (String)this.envVars.get(name);
            environmentVars[i] = name + "=" + value2;
            ++i;
        }
        return environmentVars;
    }

    public String[] getCommandline() {
        String[] args = this.getArguments();
        String executable = this.getExecutable();
        if (executable == null) {
            return args;
        }
        String[] result2 = new String[args.length + 1];
        result2[0] = executable;
        System.arraycopy(args, 0, result2, 1, args.length);
        return result2;
    }

    public String[] getShellCommandline() {
        this.verifyShellState();
        return this.getShell().getShellCommandLine(this.getArguments()).toArray(new String[0]);
    }

    public String[] getArguments() {
        Vector<String> result2 = new Vector<String>(this.arguments.size() * 2);
        for (int i = 0; i < this.arguments.size(); ++i) {
            Argument arg = (Argument)this.arguments.elementAt(i);
            String[] s2 = arg.getParts();
            if (s2 == null) continue;
            for (int j = 0; j < s2.length; ++j) {
                result2.addElement(s2[j]);
            }
        }
        Object[] res = new String[result2.size()];
        result2.copyInto(res);
        return res;
    }

    public String toString() {
        return StringUtils.join(this.getShellCommandline(), " ");
    }

    public int size() {
        return this.getCommandline().length;
    }

    public Object clone() {
        Commandline c = new Commandline((Shell)this.shell.clone());
        c.executable = this.executable;
        c.workingDir = this.workingDir;
        c.addArguments(this.getArguments());
        return c;
    }

    public void clear() {
        this.executable = null;
        this.workingDir = null;
        this.shell.setExecutable(null);
        this.shell.clearArguments();
        this.arguments.removeAllElements();
    }

    public void clearArgs() {
        this.arguments.removeAllElements();
    }

    public Marker createMarker() {
        return new Marker(this.arguments.size());
    }

    public void setWorkingDirectory(String path) {
        this.shell.setWorkingDirectory(path);
        this.workingDir = new File(path);
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.shell.setWorkingDirectory(workingDirectory);
        this.workingDir = workingDirectory;
    }

    public File getWorkingDirectory() {
        File workDir = this.shell.getWorkingDirectory();
        if (workDir == null) {
            workDir = this.workingDir;
        }
        return workDir;
    }

    public Process execute() throws CommandLineException {
        Process process;
        this.verifyShellState();
        String[] environment = this.getEnvironmentVariables();
        File workingDir = this.shell.getWorkingDirectory();
        try {
            if (workingDir == null) {
                process = Runtime.getRuntime().exec(this.getShellCommandline(), environment);
            } else {
                if (!workingDir.exists()) {
                    throw new CommandLineException("Working directory \"" + workingDir.getPath() + "\" does not exist!");
                }
                if (!workingDir.isDirectory()) {
                    throw new CommandLineException("Path \"" + workingDir.getPath() + "\" does not specify a directory.");
                }
                process = Runtime.getRuntime().exec(this.getShellCommandline(), environment, workingDir);
            }
        }
        catch (IOException ex) {
            throw new CommandLineException("Error while executing process.", ex);
        }
        return process;
    }

    private void verifyShellState() {
        if (this.shell.getWorkingDirectory() == null) {
            this.shell.setWorkingDirectory(this.workingDir);
        }
        if (this.shell.getExecutable() == null) {
            this.shell.setExecutable(this.executable);
        }
    }

    public Properties getSystemEnvVars() throws Exception {
        return CommandLineUtils.getSystemEnvVars();
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public Shell getShell() {
        return this.shell;
    }

    public static String[] translateCommandline(String toProcess) throws Exception {
        return CommandLineUtils.translateCommandline(toProcess);
    }

    public static String quoteArgument(String argument) throws CommandLineException {
        return CommandLineUtils.quote(argument);
    }

    public static String toString(String[] line) {
        return CommandLineUtils.toString(line);
    }

    public static class Argument
    implements Arg {
        private String[] parts;

        public void setValue(String value2) {
            if (value2 != null) {
                this.parts = new String[]{value2};
            }
        }

        public void setLine(String line) {
            if (line == null) {
                return;
            }
            try {
                this.parts = CommandLineUtils.translateCommandline(line);
            }
            catch (Exception e) {
                System.err.println("Error translating Commandline.");
            }
        }

        public void setFile(File value2) {
            this.parts = new String[]{value2.getAbsolutePath()};
        }

        public String[] getParts() {
            return this.parts;
        }
    }

    public class Marker {
        private int position;
        private int realPos = -1;

        Marker(int position) {
            this.position = position;
        }

        public int getPosition() {
            if (this.realPos == -1) {
                this.realPos = Commandline.this.getExecutable() == null ? 0 : 1;
                for (int i = 0; i < this.position; ++i) {
                    Arg arg = (Arg)Commandline.this.arguments.elementAt(i);
                    this.realPos += arg.getParts().length;
                }
            }
            return this.realPos;
        }
    }
}

