/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.context;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;

public class DefaultContext
implements Context {
    private static Hidden HIDDEN_MAKER = new Hidden();
    private Map contextData;
    private Context parent;
    private boolean readOnly;

    public DefaultContext(Map contextData, Context parent) {
        this.parent = parent;
        this.contextData = contextData;
    }

    public DefaultContext(Map contextData) {
        this(contextData, null);
    }

    public DefaultContext(Context parent) {
        this(new Hashtable(), parent);
    }

    public DefaultContext() {
        this((Context)null);
    }

    public boolean contains(Object key) {
        Object data2 = this.contextData.get(key);
        if (null != data2) {
            return !(data2 instanceof Hidden);
        }
        if (null == this.parent) {
            return false;
        }
        return this.parent.contains(key);
    }

    public Object get(Object key) throws ContextException {
        Object data2 = this.contextData.get(key);
        if (data2 != null) {
            if (data2 instanceof Hidden) {
                throw new ContextException("Unable to locate " + key);
            }
            return data2;
        }
        if (this.parent == null) {
            throw new ContextException("Unable to resolve context key: " + key);
        }
        return this.parent.get(key);
    }

    public void put(Object key, Object value2) throws IllegalStateException {
        this.checkWriteable();
        if (null == value2) {
            this.contextData.remove(key);
        } else {
            this.contextData.put(key, value2);
        }
    }

    public void hide(Object key) throws IllegalStateException {
        this.checkWriteable();
        this.contextData.put(key, HIDDEN_MAKER);
    }

    protected Map getContextData() {
        return this.contextData;
    }

    protected Context getParent() {
        return this.parent;
    }

    public void makeReadOnly() {
        this.readOnly = true;
    }

    protected void checkWriteable() throws IllegalStateException {
        if (this.readOnly) {
            throw new IllegalStateException("Context is read only and can not be modified");
        }
    }

    private static class Hidden
    implements Serializable {
        private Hidden() {
        }
    }
}

