/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoURLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlexusIoZipFileResourceCollection
extends AbstractPlexusIoArchiveResourceCollection {
    public static final String ROLE_HINT = "zipFile";
    public static final String JAR_ROLE_HINT = "jarFile";

    @Override
    protected Iterator<PlexusIoResource> getEntries() throws IOException {
        File f = this.getFile();
        if (f == null) {
            throw new IOException("The zip file has not been set.");
        }
        final URL url = new URL("jar:" + f.toURI().toURL() + "!/");
        ZipFile zipFile = new ZipFile(f);
        final Enumeration<? extends ZipEntry> en = zipFile.entries();
        return new Iterator<PlexusIoResource>(){

            @Override
            public boolean hasNext() {
                return en.hasMoreElements();
            }

            @Override
            public PlexusIoResource next() {
                final ZipEntry entry2 = (ZipEntry)en.nextElement();
                PlexusIoURLResource res = new PlexusIoURLResource(){

                    public URL getURL() throws IOException {
                        String spec = entry2.getName();
                        if (spec.startsWith("/")) {
                            spec = "./" + spec;
                        }
                        return new URL(url, spec);
                    }
                };
                boolean dir = entry2.isDirectory();
                res.setName(entry2.getName());
                res.setDirectory(dir);
                res.setExisting(true);
                res.setFile(!dir);
                long l = entry2.getTime();
                res.setLastModified(l == -1L ? 0L : l);
                res.setSize(dir ? -1L : entry2.getSize());
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing isn't implemented.");
            }
        };
    }
}

