/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipException;
import org.codehaus.plexus.archiver.zip.AsiExtraField;
import org.codehaus.plexus.archiver.zip.UnrecognizedExtraField;
import org.codehaus.plexus.archiver.zip.ZipExtraField;
import org.codehaus.plexus.archiver.zip.ZipShort;

public class ExtraFieldUtils {
    private static Hashtable implementations = new Hashtable();

    public static void register(Class c) {
        try {
            ZipExtraField ze = (ZipExtraField)c.newInstance();
            implementations.put(ze.getHeaderId(), c);
        }
        catch (ClassCastException cc) {
            throw new RuntimeException(c + " doesn't implement ZipExtraField");
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(c + " is not a concrete class");
        }
        catch (IllegalAccessException ie) {
            throw new RuntimeException(c + "'s no-arg constructor is not public");
        }
    }

    public static ZipExtraField createExtraField(ZipShort headerId) throws InstantiationException, IllegalAccessException {
        Class c = (Class)implementations.get(headerId);
        if (c != null) {
            return (ZipExtraField)c.newInstance();
        }
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(headerId);
        return u;
    }

    public static ZipExtraField[] parse(byte[] data2) throws ZipException {
        int start;
        int length;
        Vector<ZipExtraField> v = new Vector<ZipExtraField>();
        for (start = 0; start <= data2.length - 4; start += length + 4) {
            ZipShort headerId = new ZipShort(data2, start);
            length = new ZipShort(data2, start + 2).getValue();
            if (start + 4 + length > data2.length) {
                throw new ZipException("data starting at " + start + " is in unknown format");
            }
            try {
                ZipExtraField ze = ExtraFieldUtils.createExtraField(headerId);
                ze.parseFromLocalFileData(data2, start + 4, length);
                v.addElement(ze);
                continue;
            }
            catch (InstantiationException ie) {
                throw new ZipException(ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new ZipException(iae.getMessage());
            }
        }
        if (start != data2.length) {
            throw new ZipException("data starting at " + start + " is in unknown format");
        }
        Object[] result2 = new ZipExtraField[v.size()];
        v.copyInto(result2);
        return result2;
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] data2) {
        int sum2 = 4 * data2.length;
        for (int i = 0; i < data2.length; ++i) {
            sum2 += data2[i].getLocalFileDataLength().getValue();
        }
        byte[] result2 = new byte[sum2];
        int start = 0;
        for (int i = 0; i < data2.length; ++i) {
            System.arraycopy(data2[i].getHeaderId().getBytes(), 0, result2, start, 2);
            System.arraycopy(data2[i].getLocalFileDataLength().getBytes(), 0, result2, start + 2, 2);
            byte[] local = data2[i].getLocalFileDataData();
            System.arraycopy(local, 0, result2, start + 4, local.length);
            start += local.length + 4;
        }
        return result2;
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] data2) {
        int sum2 = 4 * data2.length;
        for (int i = 0; i < data2.length; ++i) {
            sum2 += data2[i].getCentralDirectoryLength().getValue();
        }
        byte[] result2 = new byte[sum2];
        int start = 0;
        for (int i = 0; i < data2.length; ++i) {
            System.arraycopy(data2[i].getHeaderId().getBytes(), 0, result2, start, 2);
            System.arraycopy(data2[i].getCentralDirectoryLength().getBytes(), 0, result2, start + 2, 2);
            byte[] local = data2[i].getCentralDirectoryData();
            System.arraycopy(local, 0, result2, start + 4, local.length);
            start += local.length + 4;
        }
        return result2;
    }

    static {
        ExtraFieldUtils.register(AsiExtraField.class);
    }
}

