/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.util;

import java.io.InputStream;
import java.util.List;
import org.codehaus.plexus.archiver.ArchiveFileFilter;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.logging.Logger;

public class FilterSupport {
    private final List filters;
    private final Logger logger;

    public FilterSupport(List filters, Logger logger) {
        this.filters = filters;
        this.logger = logger;
    }

    public boolean include(InputStream dataStream, String entryName) throws ArchiveFilterException {
        boolean included = true;
        if (this.filters != null && !this.filters.isEmpty()) {
            for (ArchiveFileFilter filter2 : this.filters) {
                included = filter2.include(dataStream, entryName);
                if (included) continue;
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug("Entry: '" + entryName + "' excluded by filter: " + filter2.getClass().getName());
                break;
            }
        }
        return included;
    }
}

