/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.tar;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.bzip2.CBZip2OutputStream;
import org.codehaus.plexus.archiver.tar.TarEntry;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.tar.TarOutputStream;
import org.codehaus.plexus.archiver.util.EnumeratedAttribute;
import org.codehaus.plexus.archiver.util.ResourceUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class TarArchiver
extends AbstractArchiver {
    private boolean longWarningGiven = false;
    private TarLongFileMode longFileMode = new TarLongFileMode();
    private TarCompressionMethod compression = new TarCompressionMethod();
    private TarOptions options = new TarOptions();
    private TarOutputStream tOut;

    public TarOptions getOptions() {
        return this.options;
    }

    public void setOptions(TarOptions options) {
        this.options = options;
        this.setDefaultFileMode(options.getMode());
        this.setDefaultDirectoryMode(options.getMode());
    }

    public void setLongfile(TarLongFileMode mode) {
        this.longFileMode = mode;
    }

    public void setCompression(TarCompressionMethod mode) {
        this.compression = mode;
    }

    protected void execute() throws ArchiverException, IOException {
        if (!this.checkForced()) {
            return;
        }
        ResourceIterator iter2 = this.getResources();
        if (!iter2.hasNext()) {
            throw new ArchiverException("You must set at least one file.");
        }
        File tarFile = this.getDestFile();
        if (tarFile == null) {
            throw new ArchiverException("You must set the destination tar file.");
        }
        if (tarFile.exists() && !tarFile.isFile()) {
            throw new ArchiverException(tarFile + " isn't a file.");
        }
        if (tarFile.exists() && !tarFile.canWrite()) {
            throw new ArchiverException(tarFile + " is read-only.");
        }
        this.getLogger().info("Building tar: " + tarFile.getAbsolutePath());
        this.tOut = new TarOutputStream(this.compression.compress(new BufferedOutputStream(new FileOutputStream(tarFile))));
        this.tOut.setDebug(true);
        if (this.longFileMode.isTruncateMode()) {
            this.tOut.setLongFileMode(1);
        } else if (this.longFileMode.isFailMode() || this.longFileMode.isOmitMode()) {
            this.tOut.setLongFileMode(0);
        } else {
            this.tOut.setLongFileMode(2);
        }
        this.longWarningGiven = false;
        while (iter2.hasNext()) {
            ArchiveEntry entry2 = iter2.next();
            if (ResourceUtils.isSame(entry2.getResource(), tarFile)) {
                throw new ArchiverException("A tar file cannot include itself.");
            }
            String fileName = entry2.getName();
            String name = StringUtils.replace(fileName, File.separatorChar, '/');
            this.tarFile(entry2, this.tOut, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void tarFile(ArchiveEntry entry, TarOutputStream tOut, String vPath) throws ArchiverException, IOException {
        block15: {
            fIn = null;
            if (vPath.length() <= 0) {
                return;
            }
            if (entry.getResource().isDirectory() && !vPath.endsWith("/")) {
                vPath = vPath + "/";
            }
            if (vPath.startsWith("/") && !this.options.getPreserveLeadingSlashes()) {
                l = vPath.length();
                if (l <= 1) {
                    return;
                }
                vPath = vPath.substring(1, l);
            }
            if (vPath.length() < 100) ** GOTO lbl27
            if (!this.longFileMode.isOmitMode()) break block15;
            this.getLogger().info("Omitting: " + vPath);
            IOUtil.close(fIn);
            return;
        }
        try {
            if (this.longFileMode.isWarnMode()) {
                this.getLogger().warn("Entry: " + vPath + " longer than " + 100 + " characters.");
                if (!this.longWarningGiven) {
                    this.getLogger().warn("Resulting tar file can only be processed successfully by GNU compatible tar commands");
                    this.longWarningGiven = true;
                }
            } else if (this.longFileMode.isFailMode()) {
                throw new ArchiverException("Entry: " + vPath + " longer than " + 100 + "characters.");
            }
lbl27:
            // 4 sources

            te = new TarEntry(vPath);
            teLastModified = entry.getResource().getLastModified();
            te.setModTime(teLastModified == 0L ? System.currentTimeMillis() : teLastModified);
            if (!entry.getResource().isDirectory()) {
                size = entry.getResource().getSize();
                te.setSize(size == -1L ? 0L : size);
                te.setMode(entry.getMode());
            } else {
                te.setMode(entry.getMode());
            }
            attributes = entry.getResourceAttributes();
            te.setUserName(attributes != null && attributes.getUserName() != null ? attributes.getUserName() : this.options.getUserName());
            te.setGroupName(attributes != null && attributes.getGroupName() != null ? attributes.getGroupName() : this.options.getGroup());
            te.setUserId(attributes != null && attributes.getUserId() != null ? attributes.getUserId().intValue() : this.options.getUid());
            te.setGroupId(attributes != null && attributes.getGroupId() != null ? attributes.getGroupId().intValue() : this.options.getGid());
            tOut.putNextEntry(te);
            if (!entry.getResource().isDirectory()) {
                fIn = entry.getInputStream();
                buffer = new byte[8192];
                count = 0;
                do {
                    tOut.write(buffer, 0, count);
                } while ((count = fIn.read(buffer, 0, buffer.length)) != -1);
            }
            tOut.closeEntry();
        }
        catch (Throwable var11_12) {
            IOUtil.close(fIn);
            throw var11_12;
        }
        IOUtil.close(fIn);
    }

    public boolean isSupportingForced() {
        return true;
    }

    protected void cleanUp() {
        super.cleanUp();
        this.tOut = null;
    }

    protected void close() throws IOException {
        IOUtil.close(this.tOut);
    }

    protected String getArchiveType() {
        return "TAR";
    }

    public static final class TarCompressionMethod
    extends EnumeratedAttribute {
        private static final String NONE = "none";
        private static final String GZIP = "gzip";
        private static final String BZIP2 = "bzip2";

        public TarCompressionMethod() {
            try {
                this.setValue(NONE);
            }
            catch (ArchiverException archiverException) {
                // empty catch block
            }
        }

        public String[] getValues() {
            return new String[]{NONE, GZIP, BZIP2};
        }

        private OutputStream compress(OutputStream ostream) throws IOException {
            String value2 = this.getValue();
            if (GZIP.equals(value2)) {
                return new GZIPOutputStream(ostream);
            }
            if (BZIP2.equals(value2)) {
                ostream.write(66);
                ostream.write(90);
                return new CBZip2OutputStream(ostream);
            }
            return ostream;
        }
    }

    public class TarOptions {
        private int fileMode = 33188;
        private int dirMode = 16877;
        private String userName = "";
        private String groupName = "";
        private int uid;
        private int gid;
        private boolean preserveLeadingSlashes = false;

        public void setMode(String octalString) {
            this.setMode(Integer.parseInt(octalString, 8));
        }

        public void setMode(int mode) {
            this.fileMode = 0x8000 | mode & 0xFFF;
        }

        public int getMode() {
            return this.fileMode;
        }

        public void setDirMode(String octalString) {
            this.setDirMode(Integer.parseInt(octalString, 8));
        }

        public void setDirMode(int mode) {
            this.dirMode = 0x4000 | mode & 0xFFF;
        }

        public int getDirMode() {
            return this.dirMode;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUid(int uid) {
            this.uid = uid;
        }

        public int getUid() {
            return this.uid;
        }

        public void setGroup(String groupName) {
            this.groupName = groupName;
        }

        public String getGroup() {
            return this.groupName;
        }

        public void setGid(int gid) {
            this.gid = gid;
        }

        public int getGid() {
            return this.gid;
        }

        public boolean getPreserveLeadingSlashes() {
            return this.preserveLeadingSlashes;
        }

        public void setPreserveLeadingSlashes(boolean preserveLeadingSlashes) {
            this.preserveLeadingSlashes = preserveLeadingSlashes;
        }
    }
}

