/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.gzip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.IOUtil;

public class GZipUnArchiver
extends AbstractUnArchiver {
    public GZipUnArchiver() {
    }

    public GZipUnArchiver(File sourceFile) {
        super(sourceFile);
    }

    protected void execute() throws ArchiverException {
        if (this.getSourceFile().lastModified() > this.getDestFile().lastModified()) {
            this.getLogger().info("Expanding " + this.getSourceFile().getAbsolutePath() + " to " + this.getDestFile().getAbsolutePath());
            FileOutputStream out = null;
            GZIPInputStream zIn = null;
            FileInputStream fis = null;
            try {
                out = new FileOutputStream(this.getDestFile());
                fis = new FileInputStream(this.getSourceFile());
                zIn = new GZIPInputStream(fis);
                byte[] buffer = new byte[8192];
                int count2 = 0;
                do {
                    out.write(buffer, 0, count2);
                } while ((count2 = zIn.read(buffer, 0, buffer.length)) != -1);
            }
            catch (IOException ioe) {
                try {
                    String msg = "Problem expanding gzip " + ioe.getMessage();
                    throw new ArchiverException(msg, ioe);
                }
                catch (Throwable throwable) {
                    IOUtil.close(fis);
                    IOUtil.close(out);
                    IOUtil.close(zIn);
                    throw throwable;
                }
            }
            IOUtil.close(fis);
            IOUtil.close(out);
            IOUtil.close(zIn);
        }
    }

    protected void execute(String path, File outputDirectory) {
        throw new UnsupportedOperationException("Targeted extraction not supported in GZIP format.");
    }
}

