/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.mutable;

import org.apache.commons.lang.mutable.Mutable;

public class MutableInt
extends Number
implements Comparable,
Mutable {
    private static final long serialVersionUID = 512176391864L;
    private int value;

    public MutableInt() {
    }

    public MutableInt(int value2) {
        this.value = value2;
    }

    public MutableInt(Number value2) {
        this.value = value2.intValue();
    }

    public MutableInt(String value2) throws NumberFormatException {
        this.value = Integer.parseInt(value2);
    }

    public Object getValue() {
        return new Integer(this.value);
    }

    public void setValue(int value2) {
        this.value = value2;
    }

    public void setValue(Object value2) {
        this.setValue(((Number)value2).intValue());
    }

    public void increment() {
        ++this.value;
    }

    public void decrement() {
        --this.value;
    }

    public void add(int operand) {
        this.value += operand;
    }

    public void add(Number operand) {
        this.value += operand.intValue();
    }

    public void subtract(int operand) {
        this.value -= operand;
    }

    public void subtract(Number operand) {
        this.value -= operand.intValue();
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public Integer toInteger() {
        return new Integer(this.intValue());
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableInt) {
            return this.value == ((MutableInt)obj).intValue();
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public int compareTo(Object obj) {
        MutableInt other = (MutableInt)obj;
        int anotherVal = other.value;
        return this.value < anotherVal ? -1 : (this.value == anotherVal ? 0 : 1);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

