/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PooledHeapByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.buffer.UnsafeHeapSwappedByteBuf;
import io.netty.util.Recycler;
import io.netty.util.internal.PlatformDependent;

final class PooledUnsafeHeapByteBuf
extends PooledHeapByteBuf {
    private static final Recycler<PooledUnsafeHeapByteBuf> RECYCLER = new Recycler<PooledUnsafeHeapByteBuf>(){

        @Override
        protected PooledUnsafeHeapByteBuf newObject(Recycler.Handle handle2) {
            return new PooledUnsafeHeapByteBuf(handle2, 0);
        }
    };

    static PooledUnsafeHeapByteBuf newUnsafeInstance(int maxCapacity) {
        PooledUnsafeHeapByteBuf buf = RECYCLER.get();
        buf.reuse(maxCapacity);
        return buf;
    }

    private PooledUnsafeHeapByteBuf(Recycler.Handle recyclerHandle, int maxCapacity) {
        super(recyclerHandle, maxCapacity);
    }

    @Override
    protected byte _getByte(int index2) {
        return UnsafeByteBufUtil.getByte((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected short _getShort(int index2) {
        return UnsafeByteBufUtil.getShort((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return UnsafeByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getInt(int index2) {
        return UnsafeByteBufUtil.getInt((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected long _getLong(int index2) {
        return UnsafeByteBufUtil.getLong((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected void _setByte(int index2, int value2) {
        UnsafeByteBufUtil.setByte((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setShort(int index2, int value2) {
        UnsafeByteBufUtil.setShort((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setMedium(int index2, int value2) {
        UnsafeByteBufUtil.setMedium((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setInt(int index2, int value2) {
        UnsafeByteBufUtil.setInt((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setLong(int index2, long value2) {
        UnsafeByteBufUtil.setLong((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected Recycler<?> recycler() {
        return RECYCLER;
    }

    @Override
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeHeapSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }
}

