/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.mcs.exception.FileNotExistsException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.exception.WrongContentRangeException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadFileBolt
extends AbstractDpsBolt {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadFileBolt.class);
    private final String ecloudMcsAddress;

    public ReadFileBolt(String ecloudMcsAddress) {
        this.ecloudMcsAddress = ecloudMcsAddress;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void execute(StormTaskTuple t) {
        String file = t.getParameters().get("DPS_TASK_INPUT_DATA");
        FileServiceClient fileClient = new FileServiceClient(this.ecloudMcsAddress);
        String authorizationHeader = t.getParameter("AUTHORIZATION_HEADER");
        fileClient.useAuthorizationHeader(authorizationHeader);
        t.getParameters().remove("DPS_TASK_INPUT_DATA");
        this.emitFile(t, fileClient, file);
    }

    void emitFile(StormTaskTuple t, FileServiceClient fileClient, String file) {
        try {
            LOGGER.info("HERE THE LINK: {}", (Object)file);
            InputStream is = this.getFile(fileClient, file);
            t.setFileData(is);
            t.setFileUrl(file);
            this.outputCollector.emit((List)t.toStormTuple());
        }
        catch (FileNotExistsException | RepresentationNotExistsException | WrongContentRangeException ex) {
            LOGGER.warn("Can not retrieve file at {}", (Object)file);
            this.emitErrorNotification(t.getTaskId(), file, "Can not retrieve file", "");
        }
        catch (DriverException | MCSException | IOException ex) {
            LOGGER.error("ReadFileBolt error: {}" + ex.getMessage());
            this.emitErrorNotification(t.getTaskId(), file, ex.getMessage(), t.getParameters().toString());
        }
    }

    private InputStream getFile(FileServiceClient fileClient, String file) throws MCSException, IOException, DriverException {
        int retries = 10;
        while (true) {
            try {
                return fileClient.getFile(file);
            }
            catch (DriverException | MCSException e) {
                if (retries-- > 0) {
                    LOGGER.warn("Error while getting a file. Retries left:{} ", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                LOGGER.error("Error while getting a file.");
                throw e;
            }
            break;
        }
    }
}

