/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LinkedTreeMap;
import java.util.Map;
import java.util.Set;

public final class JsonObject
extends JsonElement {
    private final LinkedTreeMap<String, JsonElement> members = new LinkedTreeMap();

    @Override
    JsonObject deepCopy() {
        JsonObject result2 = new JsonObject();
        for (Map.Entry<String, JsonElement> entry2 : this.members.entrySet()) {
            result2.add(entry2.getKey(), entry2.getValue().deepCopy());
        }
        return result2;
    }

    public void add(String property, JsonElement value2) {
        if (value2 == null) {
            value2 = JsonNull.INSTANCE;
        }
        this.members.put(property, value2);
    }

    public JsonElement remove(String property) {
        return this.members.remove(property);
    }

    public void addProperty(String property, String value2) {
        this.add(property, this.createJsonElement(value2));
    }

    public void addProperty(String property, Number value2) {
        this.add(property, this.createJsonElement(value2));
    }

    public void addProperty(String property, Boolean value2) {
        this.add(property, this.createJsonElement(value2));
    }

    public void addProperty(String property, Character value2) {
        this.add(property, this.createJsonElement(value2));
    }

    private JsonElement createJsonElement(Object value2) {
        return value2 == null ? JsonNull.INSTANCE : new JsonPrimitive(value2);
    }

    public Set<Map.Entry<String, JsonElement>> entrySet() {
        return this.members.entrySet();
    }

    public int size() {
        return this.members.size();
    }

    public boolean has(String memberName) {
        return this.members.containsKey(memberName);
    }

    public JsonElement get(String memberName) {
        return this.members.get(memberName);
    }

    public JsonPrimitive getAsJsonPrimitive(String memberName) {
        return (JsonPrimitive)this.members.get(memberName);
    }

    public JsonArray getAsJsonArray(String memberName) {
        return (JsonArray)this.members.get(memberName);
    }

    public JsonObject getAsJsonObject(String memberName) {
        return (JsonObject)this.members.get(memberName);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof JsonObject && ((JsonObject)o).members.equals(this.members);
    }

    public int hashCode() {
        return this.members.hashCode();
    }
}

