/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jaxb.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DomElementJsonDeserializer
extends StdDeserializer<Element> {
    private static final long serialVersionUID = 1L;
    private final DocumentBuilder builder;

    public DomElementJsonDeserializer() {
        super(Element.class);
        try {
            DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
            bf.setNamespaceAware(true);
            this.builder = bf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException();
        }
    }

    public DomElementJsonDeserializer(DocumentBuilder builder) {
        super(Element.class);
        this.builder = builder;
    }

    @Override
    public Element deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Document document2 = this.builder.newDocument();
        JsonNode root2 = (JsonNode)jp.readValueAsTree();
        return this.fromNode(document2, root2);
    }

    protected Element fromNode(Document document2, JsonNode jsonNode) throws IOException {
        JsonNode childsNode;
        String name;
        String ns = jsonNode.get("namespace") != null ? jsonNode.get("namespace").asText() : null;
        String string2 = name = jsonNode.get("name") != null ? jsonNode.get("name").asText() : null;
        if (name == null) {
            throw new JsonMappingException("No name for DOM element was provided in the JSON object.");
        }
        Element element = document2.createElementNS(ns, name);
        JsonNode attributesNode = jsonNode.get("attributes");
        if (attributesNode != null && attributesNode instanceof ArrayNode) {
            Iterator<JsonNode> atts = attributesNode.elements();
            while (atts.hasNext()) {
                String value2;
                JsonNode node = atts.next();
                ns = node.get("namespace") != null ? node.get("namespace").asText() : null;
                name = node.get("name") != null ? node.get("name").asText() : null;
                String string3 = value2 = node.get("$") != null ? node.get("$").asText() : null;
                if (name == null) continue;
                element.setAttributeNS(ns, name, value2);
            }
        }
        if ((childsNode = jsonNode.get("children")) != null && childsNode instanceof ArrayNode) {
            Iterator<JsonNode> els = childsNode.elements();
            while (els.hasNext()) {
                String value3;
                JsonNode node = els.next();
                name = node.get("name") != null ? node.get("name").asText() : null;
                String string4 = value3 = node.get("$") != null ? node.get("$").asText() : null;
                if (value3 != null) {
                    element.appendChild(document2.createTextNode(value3));
                    continue;
                }
                if (name == null) continue;
                element.appendChild(this.fromNode(document2, node));
            }
        }
        return element;
    }
}

