/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import org.zeroturnaround.zip.ZipEntrySource;

public class ByteSource
implements ZipEntrySource {
    private final String path;
    private final byte[] bytes;
    private final long time;
    private final int compressionMethod;
    private final long crc;

    public ByteSource(String path, byte[] bytes) {
        this(path, bytes, System.currentTimeMillis());
    }

    public ByteSource(String path, byte[] bytes, long time) {
        this(path, bytes, time, -1);
    }

    public ByteSource(String path, byte[] bytes, int compressionMethod) {
        this(path, bytes, System.currentTimeMillis(), compressionMethod);
    }

    public ByteSource(String path, byte[] bytes, long time, int compressionMethod) {
        this.path = path;
        this.bytes = (byte[])bytes.clone();
        this.time = time;
        this.compressionMethod = compressionMethod;
        if (compressionMethod != -1) {
            CRC32 crc32 = new CRC32();
            crc32.update(bytes);
            this.crc = crc32.getValue();
        } else {
            this.crc = -1L;
        }
    }

    public String getPath() {
        return this.path;
    }

    public ZipEntry getEntry() {
        ZipEntry entry2 = new ZipEntry(this.path);
        if (this.bytes != null) {
            entry2.setSize(this.bytes.length);
        }
        if (this.compressionMethod != -1) {
            entry2.setMethod(this.compressionMethod);
        }
        if (this.crc != -1L) {
            entry2.setCrc(this.crc);
        }
        entry2.setTime(this.time);
        return entry2;
    }

    public InputStream getInputStream() throws IOException {
        if (this.bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(this.bytes);
    }

    public String toString() {
        return "ByteSource[" + this.path + "]";
    }
}

