/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.impl;

import org.xmlpull.v1.builder.XmlAttribute;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlNamespace;

public class XmlAttributeImpl
implements XmlAttribute {
    private XmlElement owner_;
    private String prefix_;
    private XmlNamespace namespace_;
    private String name_;
    private String value_;
    private String type_ = "CDATA";
    private boolean default_;

    public Object clone() throws CloneNotSupportedException {
        XmlAttributeImpl cloned = (XmlAttributeImpl)super.clone();
        cloned.owner_ = null;
        cloned.prefix_ = this.prefix_;
        cloned.namespace_ = this.namespace_;
        cloned.name_ = this.name_;
        cloned.value_ = this.value_;
        cloned.default_ = this.default_;
        return cloned;
    }

    XmlAttributeImpl(XmlElement owner, String name, String value2) {
        this.owner_ = owner;
        this.name_ = name;
        if (value2 == null) {
            throw new IllegalArgumentException("attribute value can not be null");
        }
        this.value_ = value2;
    }

    XmlAttributeImpl(XmlElement owner, XmlNamespace namespace, String name, String value2) {
        this(owner, name, value2);
        this.namespace_ = namespace;
    }

    XmlAttributeImpl(XmlElement owner, String type, XmlNamespace namespace, String name, String value2) {
        this(owner, namespace, name, value2);
        this.type_ = type;
    }

    XmlAttributeImpl(XmlElement owner, String type, XmlNamespace namespace, String name, String value2, boolean specified) {
        this(owner, namespace, name, value2);
        if (type == null) {
            throw new IllegalArgumentException("attribute type can not be null");
        }
        this.type_ = type;
        this.default_ = !specified;
    }

    public XmlElement getOwner() {
        return this.owner_;
    }

    public XmlNamespace getNamespace() {
        return this.namespace_;
    }

    public String getNamespaceName() {
        return this.namespace_ != null ? this.namespace_.getNamespaceName() : null;
    }

    public String getName() {
        return this.name_;
    }

    public String getValue() {
        return this.value_;
    }

    public String getType() {
        return this.type_;
    }

    public boolean isSpecified() {
        return !this.default_;
    }

    public String toString() {
        return "name=" + this.name_ + " value=" + this.value_;
    }
}

