/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class DomContentHandler
implements ContentHandler {
    private final Document document;
    private final List<Element> elements = new ArrayList<Element>();
    private final Node node;

    DomContentHandler(Node node) {
        Assert.notNull(node, "node must not be null");
        this.node = node;
        this.document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Assert.notNull(this.document, "document must not be null");
    }

    private Node getParent() {
        if (!this.elements.isEmpty()) {
            return this.elements.get(this.elements.size() - 1);
        }
        return this.node;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Node parent = this.getParent();
        Element element = this.document.createElementNS(uri, qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attrUri = attributes.getURI(i);
            String attrQname = attributes.getQName(i);
            String value2 = attributes.getValue(i);
            if (attrQname.startsWith("xmlns")) continue;
            element.setAttributeNS(attrUri, attrQname, value2);
        }
        element = (Element)parent.appendChild(element);
        this.elements.add(element);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elements.remove(this.elements.size() - 1);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String data2 = new String(ch, start, length);
        Node parent = this.getParent();
        Node lastChild = parent.getLastChild();
        if (lastChild != null && lastChild.getNodeType() == 3) {
            ((Text)lastChild).appendData(data2);
        } else {
            Text text2 = this.document.createTextNode(data2);
            parent.appendChild(text2);
        }
    }

    public void processingInstruction(String target, String data2) throws SAXException {
        Node parent = this.getParent();
        ProcessingInstruction pi = this.document.createProcessingInstruction(target, data2);
        parent.appendChild(pi);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }
}

