/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.header.writers;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class HstsHeaderWriter
implements HeaderWriter {
    private static final long DEFAULT_MAX_AGE_SECONDS = 31536000L;
    private static final String HSTS_HEADER_NAME = "Strict-Transport-Security";
    private final Log logger = LogFactory.getLog(this.getClass());
    private RequestMatcher requestMatcher;
    private long maxAgeInSeconds;
    private boolean includeSubDomains;
    private String hstsHeaderValue;

    public HstsHeaderWriter(RequestMatcher requestMatcher, long maxAgeInSeconds, boolean includeSubDomains) {
        this.requestMatcher = requestMatcher;
        this.maxAgeInSeconds = maxAgeInSeconds;
        this.includeSubDomains = includeSubDomains;
        this.updateHstsHeaderValue();
    }

    public HstsHeaderWriter(long maxAgeInSeconds, boolean includeSubDomains) {
        this(new SecureRequestMatcher(), maxAgeInSeconds, includeSubDomains);
    }

    public HstsHeaderWriter(long maxAgeInSeconds) {
        this(new SecureRequestMatcher(), maxAgeInSeconds, true);
    }

    public HstsHeaderWriter(boolean includeSubDomains) {
        this(new SecureRequestMatcher(), 31536000L, includeSubDomains);
    }

    public HstsHeaderWriter() {
        this(31536000L);
    }

    public void writeHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (this.requestMatcher.matches(request)) {
            response.setHeader(HSTS_HEADER_NAME, this.hstsHeaderValue);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Not injecting HSTS header since it did not match the requestMatcher " + this.requestMatcher));
        }
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull(requestMatcher, "requestMatcher cannot be null");
        this.requestMatcher = requestMatcher;
    }

    public void setMaxAgeInSeconds(long maxAgeInSeconds) {
        if (maxAgeInSeconds < 0L) {
            throw new IllegalArgumentException("maxAgeInSeconds must be non-negative. Got " + maxAgeInSeconds);
        }
        this.maxAgeInSeconds = maxAgeInSeconds;
        this.updateHstsHeaderValue();
    }

    public void setIncludeSubDomains(boolean includeSubDomains) {
        this.includeSubDomains = includeSubDomains;
        this.updateHstsHeaderValue();
    }

    private void updateHstsHeaderValue() {
        String headerValue = "max-age=" + this.maxAgeInSeconds;
        if (this.includeSubDomains) {
            headerValue = headerValue + " ; includeSubDomains";
        }
        this.hstsHeaderValue = headerValue;
    }

    private static final class SecureRequestMatcher
    implements RequestMatcher {
        private SecureRequestMatcher() {
        }

        public boolean matches(HttpServletRequest request) {
            return request.isSecure();
        }
    }
}

