/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.parameters;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.PrioritizedParameterNameDiscoverer;
import org.springframework.security.access.method.P;
import org.springframework.security.core.parameters.AnnotationParameterNameDiscoverer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSecurityParameterNameDiscoverer
extends PrioritizedParameterNameDiscoverer {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String DEFAULT_PARAMETER_NAME_DISCOVERER_CLASSNAME = "org.springframework.core.DefaultParameterNameDiscoverer";
    private static final boolean DEFAULT_PARAM_DISCOVERER_PRESENT = ClassUtils.isPresent("org.springframework.core.DefaultParameterNameDiscoverer", DefaultSecurityParameterNameDiscoverer.class.getClassLoader());
    private static final String DATA_PARAM_CLASSNAME = "org.springframework.data.repository.query.Param";
    private static final boolean DATA_PARAM_PRESENT = ClassUtils.isPresent("org.springframework.data.repository.query.Param", DefaultSecurityParameterNameDiscoverer.class.getClassLoader());

    public DefaultSecurityParameterNameDiscoverer() {
        this(Collections.emptyList());
    }

    public DefaultSecurityParameterNameDiscoverer(List<? extends ParameterNameDiscoverer> parameterNameDiscovers) {
        Assert.notNull(parameterNameDiscovers, "parameterNameDiscovers cannot be null");
        for (ParameterNameDiscoverer parameterNameDiscoverer : parameterNameDiscovers) {
            this.addDiscoverer(parameterNameDiscoverer);
        }
        HashSet<String> annotationClassesToUse = new HashSet<String>(2);
        annotationClassesToUse.add(P.class.getName());
        if (DATA_PARAM_PRESENT) {
            annotationClassesToUse.add(DATA_PARAM_CLASSNAME);
        }
        this.addDiscoverer(new AnnotationParameterNameDiscoverer(annotationClassesToUse));
        if (DEFAULT_PARAM_DISCOVERER_PRESENT) {
            try {
                Class<?> clazz = ClassUtils.forName(DEFAULT_PARAMETER_NAME_DISCOVERER_CLASSNAME, this.getClass().getClassLoader());
                this.addDiscoverer((ParameterNameDiscoverer)clazz.newInstance());
            }
            catch (Exception exception) {
                this.logger.warn((Object)"Could not use org.springframework.core.DefaultParameterNameDiscoverer. Falling back to LocalVariableTableParameterNameDiscoverer.", (Throwable)exception);
                this.addDiscoverer(new LocalVariableTableParameterNameDiscoverer());
            }
        } else {
            this.addDiscoverer(new LocalVariableTableParameterNameDiscoverer());
        }
    }
}

