/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.GenericTypeResolver;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.SecurityConfigurer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecurityConfigurerAdapter<O, B extends SecurityBuilder<O>>
implements SecurityConfigurer<O, B> {
    private B securityBuilder;
    private CompositeObjectPostProcessor objectPostProcessor = new CompositeObjectPostProcessor();

    @Override
    public void init(B builder) throws Exception {
    }

    @Override
    public void configure(B builder) throws Exception {
    }

    public B and() {
        return this.getBuilder();
    }

    protected final B getBuilder() {
        if (this.securityBuilder == null) {
            throw new IllegalStateException("securityBuilder cannot be null");
        }
        return this.securityBuilder;
    }

    protected <T> T postProcess(T object) {
        return (T)this.objectPostProcessor.postProcess(object);
    }

    public void addObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
        this.objectPostProcessor.addObjectPostProcessor(objectPostProcessor);
    }

    public void setBuilder(B builder) {
        this.securityBuilder = builder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompositeObjectPostProcessor
    implements ObjectPostProcessor<Object> {
        private List<ObjectPostProcessor<? extends Object>> postProcessors = new ArrayList<ObjectPostProcessor<? extends Object>>();

        private CompositeObjectPostProcessor() {
        }

        @Override
        public Object postProcess(Object object) {
            for (ObjectPostProcessor<? extends Object> opp : this.postProcessors) {
                Class<?> oppClass = opp.getClass();
                Class<?> oppType = GenericTypeResolver.resolveTypeArgument(oppClass, ObjectPostProcessor.class);
                if (oppType != null && !oppType.isAssignableFrom(object.getClass())) continue;
                object = opp.postProcess(object);
            }
            return object;
        }

        private boolean addObjectPostProcessor(ObjectPostProcessor<? extends Object> objectPostProcessor) {
            return this.postProcessors.add(objectPostProcessor);
        }
    }
}

