/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.ValueRef;

public class VariableReference
extends SpelNodeImpl {
    private static final String THIS = "this";
    private static final String ROOT = "root";
    private final String name;

    public VariableReference(String variableName, int pos) {
        super(pos, new SpelNodeImpl[0]);
        this.name = variableName;
    }

    public ValueRef getValueRef(ExpressionState state) throws SpelEvaluationException {
        if (this.name.equals(THIS)) {
            return new ValueRef.TypedValueHolderValueRef(state.getActiveContextObject(), this);
        }
        if (this.name.equals(ROOT)) {
            return new ValueRef.TypedValueHolderValueRef(state.getRootContextObject(), this);
        }
        TypedValue result2 = state.lookupVariable(this.name);
        return new VariableRef(this.name, result2, state.getEvaluationContext());
    }

    public TypedValue getValueInternal(ExpressionState state) throws SpelEvaluationException {
        if (this.name.equals(THIS)) {
            return state.getActiveContextObject();
        }
        if (this.name.equals(ROOT)) {
            return state.getRootContextObject();
        }
        TypedValue result2 = state.lookupVariable(this.name);
        return result2;
    }

    public void setValue(ExpressionState state, Object value2) throws SpelEvaluationException {
        state.setVariable(this.name, value2);
    }

    public String toStringAST() {
        return "#" + this.name;
    }

    public boolean isWritable(ExpressionState expressionState) throws SpelEvaluationException {
        return !this.name.equals(THIS) && !this.name.equals(ROOT);
    }

    class VariableRef
    implements ValueRef {
        private String name;
        private TypedValue value;
        private EvaluationContext eContext;

        public VariableRef(String name, TypedValue value2, EvaluationContext evaluationContext) {
            this.name = name;
            this.value = value2;
            this.eContext = evaluationContext;
        }

        public TypedValue getValue() {
            return this.value;
        }

        public void setValue(Object newValue) {
            this.eContext.setVariable(this.name, newValue);
        }

        public boolean isWritable() {
            return true;
        }
    }
}

