/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.util.Map;
import javax.management.MBeanServer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.jmx.export.annotation.AnnotationMBeanExporter;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.jmx.support.WebSphereMBeanServerFactoryBean;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public class MBeanExportConfiguration
implements ImportAware,
BeanFactoryAware {
    private static final String MBEAN_EXPORTER_BEAN_NAME = "mbeanExporter";
    private AnnotationAttributes attributes;
    private BeanFactory beanFactory;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map<String, Object> map2 = importMetadata.getAnnotationAttributes(EnableMBeanExport.class.getName());
        this.attributes = AnnotationAttributes.fromMap(map2);
        Assert.notNull(this.attributes, "@EnableMBeanExport is not present on importing class " + importMetadata.getClassName());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Bean(name={"mbeanExporter"})
    @Role(value=2)
    public AnnotationMBeanExporter mbeanExporter() {
        AnnotationMBeanExporter exporter = new AnnotationMBeanExporter();
        this.setupDomain(exporter);
        this.setupServer(exporter);
        this.setupRegistrationPolicy(exporter);
        return exporter;
    }

    private void setupDomain(AnnotationMBeanExporter exporter) {
        String defaultDomain = this.attributes.getString("defaultDomain");
        if (StringUtils.hasText(defaultDomain)) {
            exporter.setDefaultDomain(defaultDomain);
        }
    }

    private void setupServer(AnnotationMBeanExporter exporter) {
        String server = this.attributes.getString("server");
        if (StringUtils.hasText(server)) {
            exporter.setServer(this.beanFactory.getBean(server, MBeanServer.class));
        } else {
            SpecificPlatform specificPlatform = SpecificPlatform.get();
            if (specificPlatform != null) {
                exporter.setServer(specificPlatform.getMBeanServer());
            }
        }
    }

    private void setupRegistrationPolicy(AnnotationMBeanExporter exporter) {
        RegistrationPolicy registrationPolicy = (RegistrationPolicy)((Object)this.attributes.getEnum("registration"));
        exporter.setRegistrationPolicy(registrationPolicy);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SpecificPlatform {
        WEBLOGIC("weblogic.management.Helper"){

            @Override
            public FactoryBean<?> getMBeanServerFactory() {
                JndiObjectFactoryBean factory = new JndiObjectFactoryBean();
                factory.setJndiName("java:comp/env/jmx/runtime");
                return factory;
            }
        }
        ,
        WEBSPHERE("com.ibm.websphere.management.AdminServiceFactory"){

            public FactoryBean<MBeanServer> getMBeanServerFactory() {
                return new WebSphereMBeanServerFactoryBean();
            }
        };

        private final String identifyingClass;

        private SpecificPlatform(String identifyingClass) {
            this.identifyingClass = identifyingClass;
        }

        public MBeanServer getMBeanServer() {
            try {
                Object server = this.getMBeanServerFactory().getObject();
                Assert.isInstanceOf(MBeanServer.class, server);
                return (MBeanServer)server;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        protected abstract FactoryBean<?> getMBeanServerFactory();

        public static SpecificPlatform get() {
            ClassLoader classLoader = MBeanExportConfiguration.class.getClassLoader();
            for (SpecificPlatform environment : SpecificPlatform.values()) {
                if (!ClassUtils.isPresent(environment.identifyingClass, classLoader)) continue;
                return environment;
            }
            return null;
        }
    }
}

