/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.Aware;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.ConstructorResolver;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAutowireCapableBeanFactory
extends AbstractBeanFactory
implements AutowireCapableBeanFactory {
    private InstantiationStrategy instantiationStrategy = new CglibSubclassingInstantiationStrategy();
    private ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private boolean allowCircularReferences = true;
    private boolean allowRawInjectionDespiteWrapping = false;
    private final Set<Class> ignoredDependencyTypes = new HashSet<Class>();
    private final Set<Class> ignoredDependencyInterfaces = new HashSet<Class>();
    private final Map<String, BeanWrapper> factoryBeanInstanceCache = new ConcurrentHashMap<String, BeanWrapper>(16);
    private final Map<Class, PropertyDescriptor[]> filteredPropertyDescriptorsCache = new ConcurrentHashMap<Class, PropertyDescriptor[]>(64);

    public AbstractAutowireCapableBeanFactory() {
        this.ignoreDependencyInterface(BeanNameAware.class);
        this.ignoreDependencyInterface(BeanFactoryAware.class);
        this.ignoreDependencyInterface(BeanClassLoaderAware.class);
    }

    public AbstractAutowireCapableBeanFactory(BeanFactory parentBeanFactory) {
        this();
        this.setParentBeanFactory(parentBeanFactory);
    }

    public void setInstantiationStrategy(InstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    protected InstantiationStrategy getInstantiationStrategy() {
        return this.instantiationStrategy;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    protected ParameterNameDiscoverer getParameterNameDiscoverer() {
        return this.parameterNameDiscoverer;
    }

    public void setAllowCircularReferences(boolean allowCircularReferences) {
        this.allowCircularReferences = allowCircularReferences;
    }

    public void setAllowRawInjectionDespiteWrapping(boolean allowRawInjectionDespiteWrapping) {
        this.allowRawInjectionDespiteWrapping = allowRawInjectionDespiteWrapping;
    }

    public void ignoreDependencyType(Class<?> type) {
        this.ignoredDependencyTypes.add(type);
    }

    public void ignoreDependencyInterface(Class<?> ifc) {
        this.ignoredDependencyInterfaces.add(ifc);
    }

    @Override
    public void copyConfigurationFrom(ConfigurableBeanFactory otherFactory) {
        super.copyConfigurationFrom(otherFactory);
        if (otherFactory instanceof AbstractAutowireCapableBeanFactory) {
            AbstractAutowireCapableBeanFactory otherAutowireFactory = (AbstractAutowireCapableBeanFactory)otherFactory;
            this.instantiationStrategy = otherAutowireFactory.instantiationStrategy;
            this.allowCircularReferences = otherAutowireFactory.allowCircularReferences;
            this.ignoredDependencyTypes.addAll(otherAutowireFactory.ignoredDependencyTypes);
            this.ignoredDependencyInterfaces.addAll(otherAutowireFactory.ignoredDependencyInterfaces);
        }
    }

    @Override
    public <T> T createBean(Class<T> beanClass) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(beanClass);
        bd.setScope("prototype");
        bd.allowCaching = false;
        return (T)this.createBean(beanClass.getName(), bd, null);
    }

    @Override
    public void autowireBean(Object existingBean) {
        RootBeanDefinition bd = new RootBeanDefinition(ClassUtils.getUserClass(existingBean));
        bd.setScope("prototype");
        bd.allowCaching = false;
        BeanWrapperImpl bw = new BeanWrapperImpl(existingBean);
        this.initBeanWrapper(bw);
        this.populateBean(bd.getBeanClass().getName(), bd, bw);
    }

    @Override
    public Object configureBean(Object existingBean, String beanName) throws BeansException {
        this.markBeanAsCreated(beanName);
        BeanDefinition mbd = this.getMergedBeanDefinition(beanName);
        AbstractBeanDefinition bd = null;
        if (mbd instanceof RootBeanDefinition) {
            RootBeanDefinition rbd = (RootBeanDefinition)mbd;
            AbstractBeanDefinition abstractBeanDefinition = bd = rbd.isPrototype() ? rbd : rbd.cloneBeanDefinition();
        }
        if (!mbd.isPrototype()) {
            if (bd == null) {
                bd = new RootBeanDefinition(mbd);
            }
            bd.setScope("prototype");
            ((RootBeanDefinition)bd).allowCaching = false;
        }
        BeanWrapperImpl bw = new BeanWrapperImpl(existingBean);
        this.initBeanWrapper(bw);
        this.populateBean(beanName, (RootBeanDefinition)bd, bw);
        return this.initializeBean(beanName, existingBean, (RootBeanDefinition)bd);
    }

    @Override
    public Object resolveDependency(DependencyDescriptor descriptor, String beanName) throws BeansException {
        return this.resolveDependency(descriptor, beanName, null, null);
    }

    @Override
    public Object createBean(Class<?> beanClass, int autowireMode, boolean dependencyCheck) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(beanClass, autowireMode, dependencyCheck);
        bd.setScope("prototype");
        return this.createBean(beanClass.getName(), bd, null);
    }

    @Override
    public Object autowire(Class<?> beanClass, int autowireMode, boolean dependencyCheck) throws BeansException {
        final RootBeanDefinition bd = new RootBeanDefinition(beanClass, autowireMode, dependencyCheck);
        bd.setScope("prototype");
        if (bd.getResolvedAutowireMode() == 3) {
            return this.autowireConstructor(beanClass.getName(), bd, null, null).getWrappedInstance();
        }
        final AbstractAutowireCapableBeanFactory parent = this;
        Object bean = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return AbstractAutowireCapableBeanFactory.this.getInstantiationStrategy().instantiate(bd, null, parent);
            }
        }, this.getAccessControlContext()) : this.getInstantiationStrategy().instantiate(bd, null, parent);
        this.populateBean(beanClass.getName(), bd, new BeanWrapperImpl(bean));
        return bean;
    }

    @Override
    public void autowireBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) throws BeansException {
        if (autowireMode == 3) {
            throw new IllegalArgumentException("AUTOWIRE_CONSTRUCTOR not supported for existing bean instance");
        }
        RootBeanDefinition bd = new RootBeanDefinition(ClassUtils.getUserClass(existingBean), autowireMode, dependencyCheck);
        bd.setScope("prototype");
        BeanWrapperImpl bw = new BeanWrapperImpl(existingBean);
        this.initBeanWrapper(bw);
        this.populateBean(bd.getBeanClass().getName(), bd, bw);
    }

    @Override
    public void applyBeanPropertyValues(Object existingBean, String beanName) throws BeansException {
        this.markBeanAsCreated(beanName);
        BeanDefinition bd = this.getMergedBeanDefinition(beanName);
        BeanWrapperImpl bw = new BeanWrapperImpl(existingBean);
        this.initBeanWrapper(bw);
        this.applyPropertyValues(beanName, bd, bw, bd.getPropertyValues());
    }

    @Override
    public Object initializeBean(Object existingBean, String beanName) {
        return this.initializeBean(beanName, existingBean, null);
    }

    @Override
    public Object applyBeanPostProcessorsBeforeInitialization(Object existingBean, String beanName) throws BeansException {
        Object result2 = existingBean;
        for (BeanPostProcessor beanProcessor : this.getBeanPostProcessors()) {
            result2 = beanProcessor.postProcessBeforeInitialization(result2, beanName);
            if (result2 != null) continue;
            return result2;
        }
        return result2;
    }

    @Override
    public Object applyBeanPostProcessorsAfterInitialization(Object existingBean, String beanName) throws BeansException {
        Object result2 = existingBean;
        for (BeanPostProcessor beanProcessor : this.getBeanPostProcessors()) {
            result2 = beanProcessor.postProcessAfterInitialization(result2, beanName);
            if (result2 != null) continue;
            return result2;
        }
        return result2;
    }

    @Override
    protected Object createBean(String beanName, RootBeanDefinition mbd, Object[] args) throws BeanCreationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating instance of bean '" + beanName + "'"));
        }
        this.resolveBeanClass(mbd, beanName, new Class[0]);
        try {
            mbd.prepareMethodOverrides();
        }
        catch (BeanDefinitionValidationException ex) {
            throw new BeanDefinitionStoreException(mbd.getResourceDescription(), beanName, "Validation of method overrides failed", ex);
        }
        try {
            Object bean = this.resolveBeforeInstantiation(beanName, mbd);
            if (bean != null) {
                return bean;
            }
        }
        catch (Throwable ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "BeanPostProcessor before instantiation of bean failed", ex);
        }
        Object beanInstance = this.doCreateBean(beanName, mbd, args);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Finished creating instance of bean '" + beanName + "'"));
        }
        return beanInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doCreateBean(final String beanName, final RootBeanDefinition mbd, Object[] args) {
        Object earlySingletonReference;
        boolean earlySingletonExposure;
        BeanWrapper instanceWrapper = null;
        if (mbd.isSingleton()) {
            instanceWrapper = this.factoryBeanInstanceCache.remove(beanName);
        }
        if (instanceWrapper == null) {
            instanceWrapper = this.createBeanInstance(beanName, mbd, args);
        }
        final Object bean = instanceWrapper != null ? instanceWrapper.getWrappedInstance() : null;
        Class beanType = instanceWrapper != null ? instanceWrapper.getWrappedClass() : null;
        Object object = mbd.postProcessingLock;
        synchronized (object) {
            if (!mbd.postProcessed) {
                this.applyMergedBeanDefinitionPostProcessors(mbd, beanType, beanName);
                mbd.postProcessed = true;
            }
        }
        boolean bl = earlySingletonExposure = mbd.isSingleton() && this.allowCircularReferences && this.isSingletonCurrentlyInCreation(beanName);
        if (earlySingletonExposure) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Eagerly caching bean '" + beanName + "' to allow for resolving potential circular references"));
            }
            this.addSingletonFactory(beanName, new ObjectFactory(){

                public Object getObject() throws BeansException {
                    return AbstractAutowireCapableBeanFactory.this.getEarlyBeanReference(beanName, mbd, bean);
                }
            });
        }
        Object exposedObject = bean;
        try {
            this.populateBean(beanName, mbd, instanceWrapper);
            if (exposedObject != null) {
                exposedObject = this.initializeBean(beanName, exposedObject, mbd);
            }
        }
        catch (Throwable ex) {
            if (ex instanceof BeanCreationException && beanName.equals(((BeanCreationException)ex).getBeanName())) {
                throw (BeanCreationException)ex;
            }
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Initialization of bean failed", ex);
        }
        if (earlySingletonExposure && (earlySingletonReference = this.getSingleton(beanName, false)) != null) {
            if (exposedObject == bean) {
                exposedObject = earlySingletonReference;
            } else if (!this.allowRawInjectionDespiteWrapping && this.hasDependentBean(beanName)) {
                String[] dependentBeans = this.getDependentBeans(beanName);
                LinkedHashSet<String> actualDependentBeans = new LinkedHashSet<String>(dependentBeans.length);
                for (String dependentBean : dependentBeans) {
                    if (this.removeSingletonIfCreatedForTypeCheckOnly(dependentBean)) continue;
                    actualDependentBeans.add(dependentBean);
                }
                if (!actualDependentBeans.isEmpty()) {
                    throw new BeanCurrentlyInCreationException(beanName, "Bean with name '" + beanName + "' has been injected into other beans [" + StringUtils.collectionToCommaDelimitedString(actualDependentBeans) + "] in its raw version as part of a circular reference, but has eventually been " + "wrapped. This means that said other beans do not use the final version of the " + "bean. This is often the result of over-eager type matching - consider using " + "'getBeanNamesOfType' with the 'allowEagerInit' flag turned off, for example.");
                }
            }
        }
        try {
            this.registerDisposableBeanIfNecessary(beanName, bean, mbd);
        }
        catch (BeanDefinitionValidationException ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Invalid destruction signature", ex);
        }
        return exposedObject;
    }

    protected Class<?> predictBeanType(String beanName, RootBeanDefinition mbd, Class ... typesToMatch) {
        Class<?> targetType = mbd.getTargetType();
        if (targetType == null) {
            Class<?> clazz = targetType = mbd.getFactoryMethodName() != null ? this.getTypeForFactoryMethod(beanName, mbd, typesToMatch) : this.resolveBeanClass(mbd, beanName, typesToMatch);
            if (ObjectUtils.isEmpty(typesToMatch) || this.getTempClassLoader() == null) {
                mbd.setTargetType(targetType);
            }
        }
        if (targetType != null && !mbd.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors()) {
            for (BeanPostProcessor bp : this.getBeanPostProcessors()) {
                SmartInstantiationAwareBeanPostProcessor ibp;
                Class<?> predicted;
                if (!(bp instanceof SmartInstantiationAwareBeanPostProcessor) || (predicted = (ibp = (SmartInstantiationAwareBeanPostProcessor)bp).predictBeanType(targetType, beanName)) == null || typesToMatch.length == 1 && FactoryBean.class.equals((Object)typesToMatch[0]) && !FactoryBean.class.isAssignableFrom(predicted)) continue;
                return predicted;
            }
        }
        return targetType;
    }

    protected Class<?> getTypeForFactoryMethod(String beanName, RootBeanDefinition mbd, Class[] typesToMatch) {
        Class<?> factoryClass;
        boolean isStatic = true;
        String factoryBeanName = mbd.getFactoryBeanName();
        if (factoryBeanName != null) {
            if (factoryBeanName.equals(beanName)) {
                throw new BeanDefinitionStoreException(mbd.getResourceDescription(), beanName, "factory-bean reference points back to the same bean definition");
            }
            factoryClass = this.getType(factoryBeanName);
            isStatic = false;
        } else {
            factoryClass = this.resolveBeanClass(mbd, beanName, typesToMatch);
        }
        if (factoryClass == null) {
            return null;
        }
        List<ConstructorArgumentValues.ValueHolder> argumentValues = mbd.getConstructorArgumentValues().getGenericArgumentValues();
        Object[] args = new Object[argumentValues.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = argumentValues.get(i).getValue();
        }
        int minNrOfArgs = mbd.getConstructorArgumentValues().getArgumentCount();
        Method[] candidates = ReflectionUtils.getUniqueDeclaredMethods(factoryClass);
        HashSet returnTypes = new HashSet(1);
        for (Method factoryMethod : candidates) {
            Class<?> returnType;
            if (Modifier.isStatic(factoryMethod.getModifiers()) != isStatic || !factoryMethod.getName().equals(mbd.getFactoryMethodName()) || factoryMethod.getParameterTypes().length < minNrOfArgs || (returnType = GenericTypeResolver.resolveReturnTypeForGenericMethod(factoryMethod, args)) == null) continue;
            returnTypes.add(returnType);
        }
        if (returnTypes.size() == 1) {
            return (Class)returnTypes.iterator().next();
        }
        return null;
    }

    @Override
    protected Class<?> getTypeForFactoryBean(String beanName, RootBeanDefinition mbd) {
        FactoryBean fb;
        BeanDefinition fbDef;
        class Holder {
            Class<?> value = null;

            Holder() {
            }
        }
        final Holder objectType = new Holder();
        String factoryBeanName = mbd.getFactoryBeanName();
        final String factoryMethodName = mbd.getFactoryMethodName();
        if (factoryBeanName != null && factoryMethodName != null && (fbDef = this.getBeanDefinition(factoryBeanName)) instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)fbDef).hasBeanClass()) {
            Class<?> fbClass = ClassUtils.getUserClass(((AbstractBeanDefinition)fbDef).getBeanClass());
            ReflectionUtils.doWithMethods(fbClass, new ReflectionUtils.MethodCallback(){
                {
                }

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    if (method.getName().equals(factoryMethodName) && FactoryBean.class.isAssignableFrom(method.getReturnType())) {
                        objectType.value = GenericTypeResolver.resolveReturnTypeArgument(method, FactoryBean.class);
                    }
                }
            });
            if (objectType.value != null) {
                return objectType.value;
            }
        }
        FactoryBean factoryBean = fb = mbd.isSingleton() ? this.getSingletonFactoryBeanForTypeCheck(beanName, mbd) : this.getNonSingletonFactoryBeanForTypeCheck(beanName, mbd);
        if (fb != null) {
            objectType.value = this.getTypeForFactoryBean(fb);
            if (objectType.value != null) {
                return objectType.value;
            }
        }
        return super.getTypeForFactoryBean(beanName, mbd);
    }

    protected Object getEarlyBeanReference(String beanName, RootBeanDefinition mbd, Object bean) {
        Object exposedObject = bean;
        if (bean != null && !mbd.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors()) {
            for (BeanPostProcessor bp : this.getBeanPostProcessors()) {
                SmartInstantiationAwareBeanPostProcessor ibp;
                if (!(bp instanceof SmartInstantiationAwareBeanPostProcessor) || (exposedObject = (ibp = (SmartInstantiationAwareBeanPostProcessor)bp).getEarlyBeanReference(exposedObject, beanName)) != null) continue;
                return exposedObject;
            }
        }
        return exposedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FactoryBean getSingletonFactoryBeanForTypeCheck(String beanName, RootBeanDefinition mbd) {
        Object object = this.getSingletonMutex();
        synchronized (object) {
            BeanWrapper bw = this.factoryBeanInstanceCache.get(beanName);
            if (bw != null) {
                return (FactoryBean)bw.getWrappedInstance();
            }
            if (this.isSingletonCurrentlyInCreation(beanName)) {
                return null;
            }
            Object instance = null;
            try {
                this.beforeSingletonCreation(beanName);
                instance = this.resolveBeforeInstantiation(beanName, mbd);
                if (instance == null) {
                    bw = this.createBeanInstance(beanName, mbd, null);
                    instance = bw.getWrappedInstance();
                }
            }
            finally {
                this.afterSingletonCreation(beanName);
            }
            FactoryBean fb = this.getFactoryBean(beanName, instance);
            if (bw != null) {
                this.factoryBeanInstanceCache.put(beanName, bw);
            }
            return fb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FactoryBean getNonSingletonFactoryBeanForTypeCheck(String beanName, RootBeanDefinition mbd) {
        if (this.isPrototypeCurrentlyInCreation(beanName)) {
            return null;
        }
        Object instance = null;
        try {
            this.beforePrototypeCreation(beanName);
            instance = this.resolveBeforeInstantiation(beanName, mbd);
            if (instance == null) {
                BeanWrapper bw = this.createBeanInstance(beanName, mbd, null);
                instance = bw.getWrappedInstance();
            }
        }
        finally {
            this.afterPrototypeCreation(beanName);
        }
        return this.getFactoryBean(beanName, instance);
    }

    protected void applyMergedBeanDefinitionPostProcessors(RootBeanDefinition mbd, Class<?> beanType, String beanName) throws BeansException {
        try {
            for (BeanPostProcessor bp : this.getBeanPostProcessors()) {
                if (!(bp instanceof MergedBeanDefinitionPostProcessor)) continue;
                MergedBeanDefinitionPostProcessor bdp = (MergedBeanDefinitionPostProcessor)bp;
                bdp.postProcessMergedBeanDefinition(mbd, beanType, beanName);
            }
        }
        catch (Exception ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Post-processing failed of bean type [" + beanType + "] failed", ex);
        }
    }

    protected Object resolveBeforeInstantiation(String beanName, RootBeanDefinition mbd) {
        Object bean = null;
        if (!Boolean.FALSE.equals(mbd.beforeInstantiationResolved)) {
            if (mbd.hasBeanClass() && !mbd.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors() && (bean = this.applyBeanPostProcessorsBeforeInstantiation(mbd.getBeanClass(), beanName)) != null) {
                bean = this.applyBeanPostProcessorsAfterInitialization(bean, beanName);
            }
            mbd.beforeInstantiationResolved = bean != null;
        }
        return bean;
    }

    protected Object applyBeanPostProcessorsBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        for (BeanPostProcessor bp : this.getBeanPostProcessors()) {
            InstantiationAwareBeanPostProcessor ibp;
            Object result2;
            if (!(bp instanceof InstantiationAwareBeanPostProcessor) || (result2 = (ibp = (InstantiationAwareBeanPostProcessor)bp).postProcessBeforeInstantiation(beanClass, beanName)) == null) continue;
            return result2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BeanWrapper createBeanInstance(String beanName, RootBeanDefinition mbd, Object[] args) {
        Class<?> beanClass = this.resolveBeanClass(mbd, beanName, new Class[0]);
        if (beanClass != null && !Modifier.isPublic(beanClass.getModifiers()) && !mbd.isNonPublicAccessAllowed()) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Bean class isn't public, and non-public access not allowed: " + beanClass.getName());
        }
        if (mbd.getFactoryMethodName() != null) {
            return this.instantiateUsingFactoryMethod(beanName, mbd, args);
        }
        boolean resolved = false;
        boolean autowireNecessary = false;
        if (args == null) {
            Object object = mbd.constructorArgumentLock;
            synchronized (object) {
                if (mbd.resolvedConstructorOrFactoryMethod != null) {
                    resolved = true;
                    autowireNecessary = mbd.constructorArgumentsResolved;
                }
            }
        }
        if (resolved) {
            if (autowireNecessary) {
                return this.autowireConstructor(beanName, mbd, null, null);
            }
            return this.instantiateBean(beanName, mbd);
        }
        Constructor[] ctors = this.determineConstructorsFromBeanPostProcessors(beanClass, beanName);
        if (ctors != null || mbd.getResolvedAutowireMode() == 3 || mbd.hasConstructorArgumentValues() || !ObjectUtils.isEmpty(args)) {
            return this.autowireConstructor(beanName, mbd, ctors, args);
        }
        return this.instantiateBean(beanName, mbd);
    }

    protected Constructor[] determineConstructorsFromBeanPostProcessors(Class<?> beanClass, String beanName) throws BeansException {
        if (beanClass != null && this.hasInstantiationAwareBeanPostProcessors()) {
            for (BeanPostProcessor bp : this.getBeanPostProcessors()) {
                SmartInstantiationAwareBeanPostProcessor ibp;
                Constructor[] ctors;
                if (!(bp instanceof SmartInstantiationAwareBeanPostProcessor) || (ctors = (ibp = (SmartInstantiationAwareBeanPostProcessor)bp).determineCandidateConstructors(beanClass, beanName)) == null) continue;
                return ctors;
            }
        }
        return null;
    }

    protected BeanWrapper instantiateBean(final String beanName, final RootBeanDefinition mbd) {
        try {
            final AbstractAutowireCapableBeanFactory parent = this;
            Object beanInstance = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return AbstractAutowireCapableBeanFactory.this.getInstantiationStrategy().instantiate(mbd, beanName, parent);
                }
            }, this.getAccessControlContext()) : this.getInstantiationStrategy().instantiate(mbd, beanName, parent);
            BeanWrapperImpl bw = new BeanWrapperImpl(beanInstance);
            this.initBeanWrapper(bw);
            return bw;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Instantiation of bean failed", ex);
        }
    }

    protected BeanWrapper instantiateUsingFactoryMethod(String beanName, RootBeanDefinition mbd, Object[] explicitArgs) {
        return new ConstructorResolver(this).instantiateUsingFactoryMethod(beanName, mbd, explicitArgs);
    }

    protected BeanWrapper autowireConstructor(String beanName, RootBeanDefinition mbd, Constructor[] ctors, Object[] explicitArgs) {
        return new ConstructorResolver(this).autowireConstructor(beanName, mbd, ctors, explicitArgs);
    }

    protected void populateBean(String beanName, RootBeanDefinition mbd, BeanWrapper bw) {
        boolean needsDepCheck;
        PropertyValues pvs = mbd.getPropertyValues();
        if (bw == null) {
            if (!pvs.isEmpty()) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Cannot apply property values to null instance");
            }
            return;
        }
        boolean continueWithPropertyPopulation = true;
        if (!mbd.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors()) {
            for (BeanPostProcessor bp : this.getBeanPostProcessors()) {
                InstantiationAwareBeanPostProcessor ibp;
                if (!(bp instanceof InstantiationAwareBeanPostProcessor) || (ibp = (InstantiationAwareBeanPostProcessor)bp).postProcessAfterInstantiation(bw.getWrappedInstance(), beanName)) continue;
                continueWithPropertyPopulation = false;
                break;
            }
        }
        if (!continueWithPropertyPopulation) {
            return;
        }
        if (mbd.getResolvedAutowireMode() == 1 || mbd.getResolvedAutowireMode() == 2) {
            MutablePropertyValues newPvs = new MutablePropertyValues(pvs);
            if (mbd.getResolvedAutowireMode() == 1) {
                this.autowireByName(beanName, mbd, bw, newPvs);
            }
            if (mbd.getResolvedAutowireMode() == 2) {
                this.autowireByType(beanName, mbd, bw, newPvs);
            }
            pvs = newPvs;
        }
        boolean hasInstAwareBpps = this.hasInstantiationAwareBeanPostProcessors();
        boolean bl = needsDepCheck = mbd.getDependencyCheck() != 0;
        if (hasInstAwareBpps || needsDepCheck) {
            PropertyDescriptor[] filteredPds = this.filterPropertyDescriptorsForDependencyCheck(bw, mbd.allowCaching);
            if (hasInstAwareBpps) {
                for (BeanPostProcessor bp : this.getBeanPostProcessors()) {
                    InstantiationAwareBeanPostProcessor ibp;
                    if (!(bp instanceof InstantiationAwareBeanPostProcessor) || (pvs = (ibp = (InstantiationAwareBeanPostProcessor)bp).postProcessPropertyValues(pvs, filteredPds, bw.getWrappedInstance(), beanName)) != null) continue;
                    return;
                }
            }
            if (needsDepCheck) {
                this.checkDependencies(beanName, mbd, filteredPds, pvs);
            }
        }
        this.applyPropertyValues(beanName, mbd, bw, pvs);
    }

    protected void autowireByName(String beanName, AbstractBeanDefinition mbd, BeanWrapper bw, MutablePropertyValues pvs) {
        String[] propertyNames;
        for (String propertyName : propertyNames = this.unsatisfiedNonSimpleProperties(mbd, bw)) {
            if (this.containsBean(propertyName)) {
                Object bean = this.getBean(propertyName);
                pvs.add(propertyName, bean);
                this.registerDependentBean(propertyName, beanName);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added autowiring by name from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + propertyName + "'"));
                continue;
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace((Object)("Not autowiring property '" + propertyName + "' of bean '" + beanName + "' by name: no matching bean found"));
        }
    }

    protected void autowireByType(String beanName, AbstractBeanDefinition mbd, BeanWrapper bw, MutablePropertyValues pvs) {
        String[] propertyNames;
        TypeConverter converter = this.getCustomTypeConverter();
        if (converter == null) {
            converter = bw;
        }
        LinkedHashSet<String> autowiredBeanNames = new LinkedHashSet<String>(4);
        for (String propertyName : propertyNames = this.unsatisfiedNonSimpleProperties(mbd, bw)) {
            try {
                boolean eager;
                PropertyDescriptor pd = bw.getPropertyDescriptor(propertyName);
                if (Object.class.equals(pd.getPropertyType())) continue;
                MethodParameter methodParam = BeanUtils.getWriteMethodParameter(pd);
                AutowireByTypeDependencyDescriptor desc = new AutowireByTypeDependencyDescriptor(methodParam, eager = !PriorityOrdered.class.isAssignableFrom(bw.getWrappedClass()));
                Object autowiredArgument = this.resolveDependency(desc, beanName, autowiredBeanNames, converter);
                if (autowiredArgument != null) {
                    pvs.add(propertyName, autowiredArgument);
                }
                for (String autowiredBeanName : autowiredBeanNames) {
                    this.registerDependentBean(autowiredBeanName, beanName);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + autowiredBeanName + "'"));
                }
                autowiredBeanNames.clear();
            }
            catch (BeansException ex) {
                throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, propertyName, ex);
            }
        }
    }

    protected String[] unsatisfiedNonSimpleProperties(AbstractBeanDefinition mbd, BeanWrapper bw) {
        PropertyDescriptor[] pds;
        TreeSet<String> result2 = new TreeSet<String>();
        MutablePropertyValues pvs = mbd.getPropertyValues();
        for (PropertyDescriptor pd : pds = bw.getPropertyDescriptors()) {
            if (pd.getWriteMethod() == null || this.isExcludedFromDependencyCheck(pd) || pvs.contains(pd.getName()) || BeanUtils.isSimpleProperty(pd.getPropertyType())) continue;
            result2.add(pd.getName());
        }
        return StringUtils.toStringArray(result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyDescriptor[] filterPropertyDescriptorsForDependencyCheck(BeanWrapper bw, boolean cache) {
        PropertyDescriptor[] filtered2 = this.filteredPropertyDescriptorsCache.get(bw.getWrappedClass());
        if (filtered2 == null) {
            if (cache) {
                Map<Class, PropertyDescriptor[]> map2 = this.filteredPropertyDescriptorsCache;
                synchronized (map2) {
                    filtered2 = this.filteredPropertyDescriptorsCache.get(bw.getWrappedClass());
                    if (filtered2 == null) {
                        filtered2 = this.filterPropertyDescriptorsForDependencyCheck(bw);
                        this.filteredPropertyDescriptorsCache.put(bw.getWrappedClass(), filtered2);
                    }
                }
            } else {
                filtered2 = this.filterPropertyDescriptorsForDependencyCheck(bw);
            }
        }
        return filtered2;
    }

    protected PropertyDescriptor[] filterPropertyDescriptorsForDependencyCheck(BeanWrapper bw) {
        LinkedList<PropertyDescriptor> pds = new LinkedList<PropertyDescriptor>(Arrays.asList(bw.getPropertyDescriptors()));
        Iterator it = pds.iterator();
        while (it.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)it.next();
            if (!this.isExcludedFromDependencyCheck(pd)) continue;
            it.remove();
        }
        return pds.toArray(new PropertyDescriptor[pds.size()]);
    }

    protected boolean isExcludedFromDependencyCheck(PropertyDescriptor pd) {
        return AutowireUtils.isExcludedFromDependencyCheck(pd) || this.ignoredDependencyTypes.contains(pd.getPropertyType()) || AutowireUtils.isSetterDefinedInInterface(pd, this.ignoredDependencyInterfaces);
    }

    protected void checkDependencies(String beanName, AbstractBeanDefinition mbd, PropertyDescriptor[] pds, PropertyValues pvs) throws UnsatisfiedDependencyException {
        int dependencyCheck = mbd.getDependencyCheck();
        for (PropertyDescriptor pd : pds) {
            boolean unsatisfied;
            if (pd.getWriteMethod() == null || pvs.contains(pd.getName())) continue;
            boolean isSimple = BeanUtils.isSimpleProperty(pd.getPropertyType());
            boolean bl = unsatisfied = dependencyCheck == 3 || isSimple && dependencyCheck == 2 || !isSimple && dependencyCheck == 1;
            if (!unsatisfied) continue;
            throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, pd.getName(), "Set this property value or disable dependency checking for this bean.");
        }
    }

    protected void applyPropertyValues(String beanName, BeanDefinition mbd, BeanWrapper bw, PropertyValues pvs) {
        List<PropertyValue> original;
        if (pvs == null || pvs.isEmpty()) {
            return;
        }
        MutablePropertyValues mpvs = null;
        if (System.getSecurityManager() != null && bw instanceof BeanWrapperImpl) {
            ((BeanWrapperImpl)bw).setSecurityContext(this.getAccessControlContext());
        }
        if (pvs instanceof MutablePropertyValues) {
            mpvs = (MutablePropertyValues)pvs;
            if (mpvs.isConverted()) {
                try {
                    bw.setPropertyValues(mpvs);
                    return;
                }
                catch (BeansException ex) {
                    throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Error setting property values", ex);
                }
            }
            original = mpvs.getPropertyValueList();
        } else {
            original = Arrays.asList(pvs.getPropertyValues());
        }
        TypeConverter converter = this.getCustomTypeConverter();
        if (converter == null) {
            converter = bw;
        }
        BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this, beanName, mbd, converter);
        ArrayList<PropertyValue> deepCopy = new ArrayList<PropertyValue>(original.size());
        boolean resolveNecessary = false;
        for (PropertyValue pv : original) {
            boolean convertible;
            Object resolvedValue;
            if (pv.isConverted()) {
                deepCopy.add(pv);
                continue;
            }
            String propertyName = pv.getName();
            Object originalValue = pv.getValue();
            Object convertedValue = resolvedValue = valueResolver.resolveValueIfNecessary(pv, originalValue);
            boolean bl = convertible = bw.isWritableProperty(propertyName) && !PropertyAccessorUtils.isNestedOrIndexedProperty(propertyName);
            if (convertible) {
                convertedValue = this.convertForProperty(resolvedValue, propertyName, bw, converter);
            }
            if (resolvedValue == originalValue) {
                if (convertible) {
                    pv.setConvertedValue(convertedValue);
                }
                deepCopy.add(pv);
                continue;
            }
            if (convertible && originalValue instanceof TypedStringValue && !((TypedStringValue)originalValue).isDynamic() && !(convertedValue instanceof Collection) && !ObjectUtils.isArray(convertedValue)) {
                pv.setConvertedValue(convertedValue);
                deepCopy.add(pv);
                continue;
            }
            resolveNecessary = true;
            deepCopy.add(new PropertyValue(pv, convertedValue));
        }
        if (mpvs != null && !resolveNecessary) {
            mpvs.setConverted();
        }
        try {
            bw.setPropertyValues(new MutablePropertyValues(deepCopy));
        }
        catch (BeansException ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Error setting property values", ex);
        }
    }

    private Object convertForProperty(Object value2, String propertyName, BeanWrapper bw, TypeConverter converter) {
        if (converter instanceof BeanWrapperImpl) {
            return ((BeanWrapperImpl)converter).convertForProperty(value2, propertyName);
        }
        PropertyDescriptor pd = bw.getPropertyDescriptor(propertyName);
        MethodParameter methodParam = BeanUtils.getWriteMethodParameter(pd);
        return converter.convertIfNecessary(value2, pd.getPropertyType(), methodParam);
    }

    protected Object initializeBean(final String beanName, final Object bean, RootBeanDefinition mbd) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    AbstractAutowireCapableBeanFactory.this.invokeAwareMethods(beanName, bean);
                    return null;
                }
            }, this.getAccessControlContext());
        } else {
            this.invokeAwareMethods(beanName, bean);
        }
        Object wrappedBean = bean;
        if (mbd == null || !mbd.isSynthetic()) {
            wrappedBean = this.applyBeanPostProcessorsBeforeInitialization(wrappedBean, beanName);
        }
        try {
            this.invokeInitMethods(beanName, wrappedBean, mbd);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(mbd != null ? mbd.getResourceDescription() : null, beanName, "Invocation of init method failed", ex);
        }
        if (mbd == null || !mbd.isSynthetic()) {
            wrappedBean = this.applyBeanPostProcessorsAfterInitialization(wrappedBean, beanName);
        }
        return wrappedBean;
    }

    private void invokeAwareMethods(String beanName, Object bean) {
        if (bean instanceof Aware) {
            if (bean instanceof BeanNameAware) {
                ((BeanNameAware)bean).setBeanName(beanName);
            }
            if (bean instanceof BeanClassLoaderAware) {
                ((BeanClassLoaderAware)bean).setBeanClassLoader(this.getBeanClassLoader());
            }
            if (bean instanceof BeanFactoryAware) {
                ((BeanFactoryAware)bean).setBeanFactory(this);
            }
        }
    }

    protected void invokeInitMethods(String beanName, final Object bean, RootBeanDefinition mbd) throws Throwable {
        String initMethodName;
        boolean isInitializingBean = bean instanceof InitializingBean;
        if (isInitializingBean && (mbd == null || !mbd.isExternallyManagedInitMethod("afterPropertiesSet"))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking afterPropertiesSet() on bean with name '" + beanName + "'"));
            }
            if (System.getSecurityManager() != null) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            ((InitializingBean)bean).afterPropertiesSet();
                            return null;
                        }
                    }, this.getAccessControlContext());
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            } else {
                ((InitializingBean)bean).afterPropertiesSet();
            }
        }
        if (!(mbd == null || (initMethodName = mbd.getInitMethodName()) == null || isInitializingBean && "afterPropertiesSet".equals(initMethodName) || mbd.isExternallyManagedInitMethod(initMethodName))) {
            this.invokeCustomInitMethod(beanName, bean, mbd);
        }
    }

    protected void invokeCustomInitMethod(String beanName, final Object bean, RootBeanDefinition mbd) throws Throwable {
        Method initMethod;
        String initMethodName = mbd.getInitMethodName();
        Method method = initMethod = mbd.isNonPublicAccessAllowed() ? BeanUtils.findMethod(bean.getClass(), initMethodName, new Class[0]) : ClassUtils.getMethodIfAvailable(bean.getClass(), initMethodName, new Class[0]);
        if (initMethod == null) {
            if (mbd.isEnforceInitMethod()) {
                throw new BeanDefinitionValidationException("Couldn't find an init method named '" + initMethodName + "' on bean with name '" + beanName + "'");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No default init method named '" + initMethodName + "' found on bean with name '" + beanName + "'"));
            }
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking init method  '" + initMethodName + "' on bean with name '" + beanName + "'"));
        }
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ReflectionUtils.makeAccessible(initMethod);
                    return null;
                }
            });
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        initMethod.invoke(bean, new Object[0]);
                        return null;
                    }
                }, this.getAccessControlContext());
            }
            catch (PrivilegedActionException pae) {
                InvocationTargetException ex = (InvocationTargetException)pae.getException();
                throw ex.getTargetException();
            }
        }
        try {
            ReflectionUtils.makeAccessible(initMethod);
            initMethod.invoke(bean, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    @Override
    protected Object postProcessObjectFromFactoryBean(Object object, String beanName) {
        return this.applyBeanPostProcessorsAfterInitialization(object, beanName);
    }

    @Override
    protected void removeSingleton(String beanName) {
        super.removeSingleton(beanName);
        this.factoryBeanInstanceCache.remove(beanName);
    }

    private static class AutowireByTypeDependencyDescriptor
    extends DependencyDescriptor {
        public AutowireByTypeDependencyDescriptor(MethodParameter methodParameter, boolean eager) {
            super(methodParameter, false, eager);
        }

        public String getDependencyName() {
            return null;
        }
    }
}

