/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.access.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpringBeanELResolver
extends ELResolver {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public Object getValue(ELContext elContext, Object base, Object property) throws ELException {
        if (base == null) {
            String beanName = property.toString();
            BeanFactory bf = this.getBeanFactory(elContext);
            if (bf.containsBean(beanName)) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Successfully resolved variable '" + beanName + "' in Spring BeanFactory"));
                }
                elContext.setPropertyResolved(true);
                return bf.getBean(beanName);
            }
        }
        return null;
    }

    public Class<?> getType(ELContext elContext, Object base, Object property) throws ELException {
        if (base == null) {
            String beanName = property.toString();
            BeanFactory bf = this.getBeanFactory(elContext);
            if (bf.containsBean(beanName)) {
                elContext.setPropertyResolved(true);
                return bf.getType(beanName);
            }
        }
        return null;
    }

    public void setValue(ELContext elContext, Object base, Object property, Object value2) throws ELException {
        if (base == null) {
            String beanName = property.toString();
            BeanFactory bf = this.getBeanFactory(elContext);
            if (bf.containsBean(beanName)) {
                throw new PropertyNotWritableException("Variable '" + beanName + "' refers to a Spring bean which by definition is not writable");
            }
        }
    }

    public boolean isReadOnly(ELContext elContext, Object base, Object property) throws ELException {
        if (base == null) {
            String beanName = property.toString();
            BeanFactory bf = this.getBeanFactory(elContext);
            if (bf.containsBean(beanName)) {
                return true;
            }
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elContext, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext elContext, Object base) {
        return Object.class;
    }

    protected abstract BeanFactory getBeanFactory(ELContext var1);
}

