/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.CompressionType;

public final class FileType {
    private static final Map<String, FileType> MAP = new LinkedHashMap<String, FileType>();
    public static final FileType UNKNOWN = new FileType("", null, null);
    private final String suffix;
    private final ArchiveFormat archiveFormat;
    private final CompressionType compression;

    private FileType(String suffix, ArchiveFormat archiveFormat) {
        this(suffix, archiveFormat, null);
    }

    private FileType(String suffix, CompressionType compression) {
        this(suffix, null, compression);
    }

    private FileType(String suffix, ArchiveFormat archiveFormat, CompressionType compression) {
        this.suffix = suffix;
        this.compression = compression;
        this.archiveFormat = archiveFormat;
    }

    public boolean isArchive() {
        return this.archiveFormat != null;
    }

    public boolean isCompressed() {
        return this.compression != null;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public ArchiveFormat getArchiveFormat() {
        return this.archiveFormat;
    }

    public CompressionType getCompressionType() {
        return this.compression;
    }

    public String toString() {
        return this.getSuffix();
    }

    public static FileType get(String filename) {
        for (Map.Entry<String, FileType> entry2 : MAP.entrySet()) {
            if (!filename.toLowerCase().endsWith(entry2.getKey())) continue;
            return entry2.getValue();
        }
        return UNKNOWN;
    }

    public static FileType get(File file) {
        return FileType.get(file.getName());
    }

    private static void add(String suffix, ArchiveFormat archiveFormat) {
        MAP.put(suffix, new FileType(suffix, archiveFormat));
    }

    private static void add(String suffix, CompressionType compressionType) {
        MAP.put(suffix, new FileType(suffix, compressionType));
    }

    private static void add(String suffix, ArchiveFormat archiveFormat, CompressionType compressionType) {
        MAP.put(suffix, new FileType(suffix, archiveFormat, compressionType));
    }

    static {
        FileType.add(".tar.gz", ArchiveFormat.TAR, CompressionType.GZIP);
        FileType.add(".tgz", ArchiveFormat.TAR, CompressionType.GZIP);
        FileType.add(".tar.bz2", ArchiveFormat.TAR, CompressionType.BZIP2);
        FileType.add(".tbz2", ArchiveFormat.TAR, CompressionType.BZIP2);
        FileType.add(".7z", ArchiveFormat.SEVEN_Z);
        FileType.add(".a", ArchiveFormat.AR);
        FileType.add(".ar", ArchiveFormat.AR);
        FileType.add(".cpio", ArchiveFormat.CPIO);
        FileType.add(".dump", ArchiveFormat.DUMP);
        FileType.add(".jar", ArchiveFormat.JAR);
        FileType.add(".tar", ArchiveFormat.TAR);
        FileType.add(".zip", ArchiveFormat.ZIP);
        FileType.add(".zipx", ArchiveFormat.ZIP);
        FileType.add(".bz2", CompressionType.BZIP2);
        FileType.add(".xz", CompressionType.XZ);
        FileType.add(".gzip", CompressionType.GZIP);
        FileType.add(".gz", CompressionType.GZIP);
        FileType.add(".pack", CompressionType.PACK200);
    }
}

