/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.arj.ArjArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

abstract class AttributeAccessor<E extends ArchiveEntry> {
    private E entry;

    public AttributeAccessor(E entry2) {
        this.entry = entry2;
    }

    public E getEntry() {
        return this.entry;
    }

    public abstract int getMode() throws IOException;

    public static AttributeAccessor<?> create(ArchiveEntry entry2) {
        if (entry2 instanceof TarArchiveEntry) {
            return new TarAttributeAccessor((TarArchiveEntry)entry2);
        }
        if (entry2 instanceof ZipArchiveEntry) {
            return new ZipAttributeAccessor((ZipArchiveEntry)entry2);
        }
        if (entry2 instanceof CpioArchiveEntry) {
            return new CpioAttributeAccessor((CpioArchiveEntry)entry2);
        }
        if (entry2 instanceof ArjArchiveEntry) {
            return new ArjAttributeAccessor((ArjArchiveEntry)entry2);
        }
        if (entry2 instanceof ArArchiveEntry) {
            return new ArAttributeAccessor((ArArchiveEntry)entry2);
        }
        return new FallbackAttributeAccessor(entry2);
    }

    public static class ArAttributeAccessor
    extends AttributeAccessor<ArArchiveEntry> {
        public ArAttributeAccessor(ArArchiveEntry entry2) {
            super(entry2);
        }

        @Override
        public int getMode() throws IOException {
            return ((ArArchiveEntry)this.getEntry()).getMode();
        }
    }

    public static class ArjAttributeAccessor
    extends AttributeAccessor<ArjArchiveEntry> {
        public ArjAttributeAccessor(ArjArchiveEntry entry2) {
            super(entry2);
        }

        @Override
        public int getMode() throws IOException {
            return ((ArjArchiveEntry)this.getEntry()).getMode();
        }
    }

    public static class CpioAttributeAccessor
    extends AttributeAccessor<CpioArchiveEntry> {
        public CpioAttributeAccessor(CpioArchiveEntry entry2) {
            super(entry2);
        }

        @Override
        public int getMode() {
            return (int)((CpioArchiveEntry)this.getEntry()).getMode();
        }
    }

    public static class ZipAttributeAccessor
    extends AttributeAccessor<ZipArchiveEntry> {
        public ZipAttributeAccessor(ZipArchiveEntry entry2) {
            super(entry2);
        }

        @Override
        public int getMode() {
            return ((ZipArchiveEntry)this.getEntry()).getUnixMode();
        }
    }

    public static class TarAttributeAccessor
    extends AttributeAccessor<TarArchiveEntry> {
        public TarAttributeAccessor(TarArchiveEntry entry2) {
            super(entry2);
        }

        @Override
        public int getMode() {
            return ((TarArchiveEntry)this.getEntry()).getMode();
        }
    }

    public static class FallbackAttributeAccessor
    extends AttributeAccessor<ArchiveEntry> {
        protected FallbackAttributeAccessor(ArchiveEntry entry2) {
            super(entry2);
        }

        @Override
        public int getMode() {
            return 0;
        }
    }
}

