/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.mimepull;

import java.util.Properties;

final class PropUtil {
    private PropUtil() {
    }

    public static boolean getBooleanSystemProperty(String name, boolean def) {
        try {
            return PropUtil.getBoolean(PropUtil.getProp(System.getProperties(), name), def);
        }
        catch (SecurityException securityException) {
            try {
                String value2 = System.getProperty(name);
                if (value2 == null) {
                    return def;
                }
                if (def) {
                    return !value2.equalsIgnoreCase("false");
                }
                return value2.equalsIgnoreCase("true");
            }
            catch (SecurityException sex) {
                return def;
            }
        }
    }

    private static Object getProp(Properties props, String name) {
        Object val = props.get(name);
        if (val != null) {
            return val;
        }
        return props.getProperty(name);
    }

    private static boolean getBoolean(Object value2, boolean def) {
        if (value2 == null) {
            return def;
        }
        if (value2 instanceof String) {
            if (def) {
                return !((String)value2).equalsIgnoreCase("false");
            }
            return ((String)value2).equalsIgnoreCase("true");
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        return def;
    }
}

