/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.mimepull;

final class ASCIIUtility {
    private ASCIIUtility() {
    }

    public static int parseInt(byte[] b, int start, int end, int radix) throws NumberFormatException {
        if (b == null) {
            throw new NumberFormatException("null");
        }
        int result2 = 0;
        boolean negative = false;
        int i = start;
        if (end > start) {
            int digit2;
            int limit;
            if (b[i] == 45) {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < end) {
                if ((digit2 = Character.digit((char)b[i++], radix)) < 0) {
                    throw new NumberFormatException("illegal number: " + ASCIIUtility.toString(b, start, end));
                }
                result2 = -digit2;
            }
            while (i < end) {
                if ((digit2 = Character.digit((char)b[i++], radix)) < 0) {
                    throw new NumberFormatException("illegal number");
                }
                if (result2 < multmin) {
                    throw new NumberFormatException("illegal number");
                }
                if ((result2 *= radix) < limit + digit2) {
                    throw new NumberFormatException("illegal number");
                }
                result2 -= digit2;
            }
        } else {
            throw new NumberFormatException("illegal number");
        }
        if (negative) {
            if (i > start + 1) {
                return result2;
            }
            throw new NumberFormatException("illegal number");
        }
        return -result2;
    }

    public static String toString(byte[] b, int start, int end) {
        int size2 = end - start;
        char[] theChars = new char[size2];
        int i = 0;
        int j = start;
        while (i < size2) {
            theChars[i++] = (char)(b[j++] & 0xFF);
        }
        return new String(theChars);
    }
}

