/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.util.Stack;
import org.jibx.runtime.IXMLWriter;

public abstract class XMLWriterNamespaceBase
implements IXMLWriter {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    protected String[] m_uris;
    protected String[] m_prefixes;
    private int m_nestingDepth;
    private Stack m_namespaceStack;
    private int m_namespaceDepth;
    private String[][] m_extensionUris;
    private String[][] m_extensionPrefixes;
    private int[] m_translateTable;
    private Stack m_translateTableStack;

    public XMLWriterNamespaceBase(String[] uris) {
        this.m_uris = uris;
        this.m_prefixes = new String[uris.length];
        this.m_prefixes[0] = "";
        this.m_prefixes[1] = "xml";
        this.m_namespaceStack = new Stack();
        this.m_namespaceDepth = -1;
        this.m_translateTableStack = new Stack();
    }

    public XMLWriterNamespaceBase(XMLWriterNamespaceBase base, String[] uris) {
        this(uris);
        this.m_extensionUris = base.m_extensionUris;
        this.m_extensionPrefixes = base.m_extensionPrefixes;
        this.m_nestingDepth = base.m_nestingDepth;
    }

    protected abstract void defineNamespace(int var1, String var2) throws IOException;

    protected abstract void undefineNamespace(int var1);

    protected void internalSetUris(String[] uris) {
        this.m_uris = uris;
        this.m_prefixes = new String[uris.length];
        this.m_prefixes[0] = "";
        this.m_prefixes[1] = "xml";
    }

    private void setNamespacePrefix(int index2, String prefix) {
        if (index2 < this.m_prefixes.length) {
            this.m_prefixes[index2] = prefix;
        } else if (this.m_extensionUris != null) {
            index2 -= this.m_prefixes.length;
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                int length = this.m_extensionUris[i].length;
                if (index2 < length) {
                    this.m_extensionPrefixes[i][index2] = prefix;
                    break;
                }
                index2 -= length;
            }
        }
    }

    @Override
    public int[] openNamespaces(int[] nums, String[] prefs) throws IOException {
        int count2 = 0;
        block0: for (int i = 0; i < nums.length; ++i) {
            String newpref = prefs[i];
            String oldpref = this.getNamespacePrefix(nums[i]);
            boolean use = false;
            if (!(newpref.equals(oldpref) || "".equals(newpref) && oldpref != null)) {
                use = true;
                for (int j = 0; j < i; ++j) {
                    if (nums[i] != nums[j]) continue;
                    if ("".equals(newpref)) {
                        use = false;
                        break;
                    }
                    nums[j] = -1;
                    continue block0;
                }
            }
            if (use) {
                ++count2;
                continue;
            }
            nums[i] = -1;
        }
        int[] deltas = EMPTY_INT_ARRAY;
        if (count2 > 0) {
            String[] priors = new String[count2];
            if (count2 == nums.length) {
                deltas = nums;
                if (this.m_translateTable != null) {
                    for (int i = 0; i < deltas.length; ++i) {
                        deltas[i] = this.m_translateTable[deltas[i]];
                    }
                }
                for (int i = 0; i < count2; ++i) {
                    int slot = deltas[i];
                    priors[i] = this.getNamespacePrefix(slot);
                    this.setNamespacePrefix(slot, prefs[i]);
                    this.defineNamespace(slot, prefs[i]);
                }
            } else {
                int fill2 = 0;
                deltas = new int[count2];
                for (int i = 0; i < nums.length; ++i) {
                    int xlate;
                    int slot = nums[i];
                    if (slot < 0) continue;
                    deltas[fill2] = xlate = this.translateNamespace(slot);
                    priors[fill2++] = this.getNamespacePrefix(slot);
                    this.setNamespacePrefix(xlate, prefs[i]);
                    this.defineNamespace(xlate, prefs[i]);
                }
            }
            this.m_namespaceStack.push(new DeclarationInfo(this.m_nestingDepth, deltas, priors));
            this.m_namespaceDepth = this.m_nestingDepth;
        }
        return deltas;
    }

    private void closeNamespaces() {
        DeclarationInfo info = (DeclarationInfo)this.m_namespaceStack.pop();
        int[] deltas = info.m_deltas;
        String[] priors = info.m_priors;
        for (int i = deltas.length - 1; i >= 0; --i) {
            int index2 = deltas[i];
            this.undefineNamespace(index2);
            if (index2 < this.m_prefixes.length) {
                this.m_prefixes[index2] = priors[i];
                continue;
            }
            if (this.m_extensionUris == null) continue;
            index2 -= this.m_prefixes.length;
            for (int j = 0; j < this.m_extensionUris.length; ++j) {
                int length = this.m_extensionUris[j].length;
                if (index2 < length) {
                    this.m_extensionPrefixes[j][index2] = priors[i];
                    continue;
                }
                index2 -= length;
            }
        }
        this.m_namespaceDepth = this.m_namespaceStack.empty() ? -1 : ((DeclarationInfo)this.m_namespaceStack.peek()).m_depth;
    }

    @Override
    public final int getNestingDepth() {
        return this.m_nestingDepth;
    }

    @Override
    public final int getNamespaceCount() {
        int count2 = this.m_uris.length;
        if (this.m_extensionUris != null) {
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                count2 += this.m_extensionUris[i].length;
            }
        }
        return count2;
    }

    protected void incrementNesting() {
        ++this.m_nestingDepth;
    }

    protected void decrementNesting() {
        --this.m_nestingDepth;
        if (this.m_nestingDepth >= 0) {
            while (this.m_nestingDepth == this.m_namespaceDepth) {
                this.closeNamespaces();
            }
        }
    }

    @Override
    public void reset() {
        this.m_nestingDepth = 0;
        this.m_namespaceDepth = -1;
        this.m_namespaceStack.clear();
        this.m_prefixes = new String[this.m_uris.length];
        this.m_prefixes[0] = "";
        this.m_prefixes[1] = "xml";
        this.m_extensionUris = null;
        this.m_extensionPrefixes = null;
        this.m_translateTable = null;
        this.m_translateTableStack.clear();
    }

    @Override
    public final String[] getNamespaces() {
        return this.m_uris;
    }

    protected final String internalNamespaceUri(int index2) {
        if (index2 < this.m_uris.length) {
            return this.m_uris[index2];
        }
        if (this.m_extensionUris != null) {
            index2 -= this.m_uris.length;
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                int length = this.m_extensionUris[i].length;
                if (index2 < length) {
                    return this.m_extensionUris[i][index2];
                }
                index2 -= length;
            }
        }
        return null;
    }

    @Override
    public final String getNamespaceUri(int index2) {
        return this.internalNamespaceUri(this.translateNamespace(index2));
    }

    protected final String internalNamespacePrefix(int index2) {
        if (index2 < this.m_prefixes.length) {
            return this.m_prefixes[index2];
        }
        if (this.m_extensionUris != null) {
            index2 -= this.m_prefixes.length;
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                int length = this.m_extensionUris[i].length;
                if (index2 < length) {
                    return this.m_extensionPrefixes[i][index2];
                }
                index2 -= length;
            }
        }
        return null;
    }

    @Override
    public final String getNamespacePrefix(int index2) {
        return this.internalNamespacePrefix(this.translateNamespace(index2));
    }

    @Override
    public final int getPrefixIndex(String prefix) {
        int i;
        if (this.m_extensionPrefixes != null) {
            for (i = this.m_extensionPrefixes.length - 1; i >= 0; --i) {
                String[] prefixes = this.m_extensionPrefixes[i];
                for (int j = prefixes.length - 1; j >= 0; --j) {
                    if (!prefix.equals(prefixes[j])) continue;
                    int index2 = j + this.m_prefixes.length;
                    for (int k = i - 1; k >= 0; --k) {
                        index2 += this.m_extensionPrefixes[k].length;
                    }
                    return index2;
                }
            }
        }
        if (this.m_translateTable == null) {
            for (i = this.m_prefixes.length - 1; i >= 0; --i) {
                if (!prefix.equals(this.m_prefixes[i])) continue;
                return i;
            }
        } else {
            for (i = this.m_translateTable.length - 1; i >= 0; --i) {
                int xlate = this.m_translateTable[i];
                if (!prefix.equals(this.m_prefixes[xlate])) continue;
                return xlate;
            }
        }
        return -1;
    }

    protected static String[][] growArray(String[][] base, String[] items) {
        if (base == null) {
            return new String[][]{items};
        }
        int length = base.length;
        String[][] grow = new String[length + 1][];
        System.arraycopy(base, 0, grow, 0, length);
        grow[length] = items;
        return grow;
    }

    protected static String[][] shrinkArray(String[][] base) {
        int length = base.length;
        if (length == 1) {
            return null;
        }
        String[][] shrink = new String[length - 1][];
        System.arraycopy(base, 0, shrink, 0, length - 1);
        return shrink;
    }

    @Override
    public void pushExtensionNamespaces(String[] uris) {
        this.m_extensionUris = XMLWriterNamespaceBase.growArray(this.m_extensionUris, uris);
        this.m_extensionPrefixes = XMLWriterNamespaceBase.growArray(this.m_extensionPrefixes, new String[uris.length]);
    }

    @Override
    public void popExtensionNamespaces() {
        this.m_extensionUris = XMLWriterNamespaceBase.shrinkArray(this.m_extensionUris);
        this.m_extensionPrefixes = XMLWriterNamespaceBase.shrinkArray(this.m_extensionPrefixes);
    }

    @Override
    public final String[][] getExtensionNamespaces() {
        return this.m_extensionUris;
    }

    public int translateNamespace(int index2) {
        if (this.m_translateTable != null && index2 < this.m_translateTable.length) {
            return this.m_translateTable[index2];
        }
        return index2;
    }

    @Override
    public void pushTranslationTable(int[] table) {
        this.m_translateTableStack.push(this.m_translateTable);
        if (table != null) {
            this.m_translateTable = table;
        }
    }

    @Override
    public void popTranslationTable() {
        this.m_translateTable = (int[])this.m_translateTableStack.pop();
    }

    private static class DeclarationInfo {
        public final int m_depth;
        public final int[] m_deltas;
        public final String[] m_priors;

        public DeclarationInfo(int depth, int[] deltas, String[] priors) {
            this.m_depth = depth;
            this.m_deltas = deltas;
            this.m_priors = priors;
        }
    }
}

