/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.StreamWriterBase;

public class UTF8StreamWriter
extends StreamWriterBase {
    private byte[] m_converts;

    public UTF8StreamWriter(String[] uris) {
        super("UTF-8", uris);
        this.defineNamespace(0, "");
        this.defineNamespace(1, "xml");
    }

    public UTF8StreamWriter(UTF8StreamWriter base, String[] uris) {
        super(base, uris);
        this.defineNamespace(0, "");
        this.defineNamespace(1, "xml");
    }

    @Override
    protected void writeMarkup(String text2) throws IOException {
        int length = text2.length();
        this.makeSpace(length * 3);
        int fill2 = this.m_fillOffset;
        for (int i = 0; i < length; ++i) {
            char chr = text2.charAt(i);
            if (chr > '\u007f') {
                if (chr > '\u07ff') {
                    this.m_buffer[fill2++] = (byte)(224 + (chr >> 12));
                    this.m_buffer[fill2++] = (byte)(128 + (chr >> 6 & 0x3F));
                    this.m_buffer[fill2++] = (byte)(128 + (chr & 0x3F));
                    continue;
                }
                this.m_buffer[fill2++] = (byte)(192 + (chr >> 6));
                this.m_buffer[fill2++] = (byte)(128 + (chr & 0x3F));
                continue;
            }
            this.m_buffer[fill2++] = (byte)chr;
        }
        this.m_fillOffset = fill2;
    }

    @Override
    protected void writeMarkup(char chr) throws IOException {
        this.makeSpace(3);
        if (chr > '\u007f') {
            if (chr > '\u07ff') {
                this.m_buffer[this.m_fillOffset++] = (byte)(224 + (chr >> 12));
                this.m_buffer[this.m_fillOffset++] = (byte)(128 + (chr >> 6 & 0x3F));
                this.m_buffer[this.m_fillOffset++] = (byte)(128 + (chr & 0x3F));
            } else {
                this.m_buffer[this.m_fillOffset++] = (byte)(192 + (chr >> 6));
                this.m_buffer[this.m_fillOffset++] = (byte)(128 + (chr & 0x3F));
            }
        } else {
            this.m_buffer[this.m_fillOffset++] = (byte)chr;
        }
    }

    @Override
    protected void defineNamespace(int index2, String prefix) {
        byte[] trim2;
        int limit = prefix.length() * 3;
        if (this.m_converts == null) {
            this.m_converts = new byte[limit];
        } else if (limit > this.m_converts.length) {
            this.m_converts = new byte[limit];
        }
        int fill2 = 0;
        for (int i = 0; i < prefix.length(); ++i) {
            char chr = prefix.charAt(i);
            if (chr > '\u007f') {
                if (chr > '\u07ff') {
                    this.m_converts[fill2++] = (byte)(224 + (chr >> 12));
                    this.m_converts[fill2++] = (byte)(128 + (chr >> 6 & 0x3F));
                    this.m_converts[fill2++] = (byte)(128 + (chr & 0x3F));
                    continue;
                }
                this.m_converts[fill2++] = (byte)(192 + (chr >> 6));
                this.m_converts[fill2++] = (byte)(128 + (chr & 0x3F));
                continue;
            }
            this.m_converts[fill2++] = (byte)chr;
        }
        if (fill2 > 0) {
            trim2 = new byte[fill2 + 1];
            System.arraycopy(this.m_converts, 0, trim2, 0, fill2);
            trim2[fill2] = 58;
        } else {
            trim2 = new byte[]{};
        }
        if (index2 < this.m_prefixBytes.length) {
            this.m_prefixBytes[index2] = trim2;
        } else if (this.m_extensionBytes != null) {
            index2 -= this.m_prefixBytes.length;
            for (int i = 0; i < this.m_extensionBytes.length; ++i) {
                int length = this.m_extensionBytes[i].length;
                if (index2 < length) {
                    this.m_extensionBytes[i][index2] = trim2;
                    continue;
                }
                index2 -= length;
            }
        } else {
            throw new IllegalArgumentException("Index out of range");
        }
    }

    @Override
    protected void writeAttributeText(String text2) throws IOException {
        int length = text2.length();
        this.makeSpace(length * 6);
        int fill2 = this.m_fillOffset;
        for (int i = 0; i < length; ++i) {
            char chr = text2.charAt(i);
            if (chr == '\"') {
                fill2 = this.writeEntity(this.m_quotEntityBytes, fill2);
                continue;
            }
            if (chr == '&') {
                fill2 = this.writeEntity(this.m_ampEntityBytes, fill2);
                continue;
            }
            if (chr == '<') {
                fill2 = this.writeEntity(this.m_ltEntityBytes, fill2);
                continue;
            }
            if (chr == '>' && i > 2 && text2.charAt(i - 1) == ']' && text2.charAt(i - 2) == ']') {
                this.m_buffer[fill2++] = 93;
                this.m_buffer[fill2++] = 93;
                fill2 = this.writeEntity(this.m_gtEntityBytes, fill2);
                continue;
            }
            if (chr < ' ') {
                if (chr != '\t' && chr != '\n' && chr != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in attribute value text");
                }
                this.m_buffer[fill2++] = (byte)chr;
                continue;
            }
            if (chr > '\u007f') {
                if (chr > '\u07ff') {
                    if (chr > '\ud7ff' && (chr < '\ue000' || chr == '\ufffe' || chr == '\uffff' || chr > '\u10ffff')) {
                        throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in attribute value text");
                    }
                    this.m_buffer[fill2++] = (byte)(224 + (chr >> 12));
                    this.m_buffer[fill2++] = (byte)(128 + (chr >> 6 & 0x3F));
                    this.m_buffer[fill2++] = (byte)(128 + (chr & 0x3F));
                    continue;
                }
                this.m_buffer[fill2++] = (byte)(192 + (chr >> 6));
                this.m_buffer[fill2++] = (byte)(128 + (chr & 0x3F));
                continue;
            }
            this.m_buffer[fill2++] = (byte)chr;
        }
        this.m_fillOffset = fill2;
    }

    @Override
    public void writeTextContent(String text2) throws IOException {
        this.flagTextContent();
        int length = text2.length();
        this.makeSpace(length * 5);
        int fill2 = this.m_fillOffset;
        for (int i = 0; i < length; ++i) {
            char chr = text2.charAt(i);
            if (chr == '&') {
                fill2 = this.writeEntity(this.m_ampEntityBytes, fill2);
                continue;
            }
            if (chr == '<') {
                fill2 = this.writeEntity(this.m_ltEntityBytes, fill2);
                continue;
            }
            if (chr == '>' && i > 2 && text2.charAt(i - 1) == ']' && text2.charAt(i - 2) == ']') {
                fill2 = this.writeEntity(this.m_gtEntityBytes, fill2);
                continue;
            }
            if (chr < ' ') {
                if (chr != '\t' && chr != '\n' && chr != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in content text");
                }
                this.m_buffer[fill2++] = (byte)chr;
                continue;
            }
            if (chr > '\u007f') {
                if (chr > '\u07ff') {
                    if (chr > '\ud7ff' && (chr < '\ue000' || chr == '\ufffe' || chr == '\uffff' || chr > '\u10ffff')) {
                        throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in content text");
                    }
                    this.m_buffer[fill2++] = (byte)(224 + (chr >> 12));
                    this.m_buffer[fill2++] = (byte)(128 + (chr >> 6 & 0x3F));
                    this.m_buffer[fill2++] = (byte)(128 + (chr & 0x3F));
                    continue;
                }
                this.m_buffer[fill2++] = (byte)(192 + (chr >> 6));
                this.m_buffer[fill2++] = (byte)(128 + (chr & 0x3F));
                continue;
            }
            this.m_buffer[fill2++] = (byte)chr;
        }
        this.m_fillOffset = fill2;
    }

    @Override
    public void writeCData(String text2) throws IOException {
        this.flagTextContent();
        int length = text2.length();
        this.makeSpace(length * 3 + 12);
        int fill2 = this.m_fillOffset;
        fill2 = this.writeEntity(this.m_cdataStartBytes, fill2);
        for (int i = 0; i < length; ++i) {
            char chr = text2.charAt(i);
            if (chr == '>' && i > 2 && text2.charAt(i - 1) == ']' && text2.charAt(i - 2) == ']') {
                throw new IOException("Sequence \"]]>\" is not allowed within CDATA section text");
            }
            if (chr < ' ') {
                if (chr != '\t' && chr != '\n' && chr != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in content text");
                }
                this.m_buffer[fill2++] = (byte)chr;
                continue;
            }
            if (chr > '\u007f') {
                if (chr > '\u07ff') {
                    if (chr > '\ud7ff' && (chr < '\ue000' || chr == '\ufffe' || chr == '\uffff' || chr > '\u10ffff')) {
                        throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in CDATA section text");
                    }
                    this.m_buffer[fill2++] = (byte)(224 + (chr >> 12));
                    this.m_buffer[fill2++] = (byte)(128 + (chr >> 6 & 0x3F));
                    this.m_buffer[fill2++] = (byte)(128 + (chr & 0x3F));
                    continue;
                }
                this.m_buffer[fill2++] = (byte)(192 + (chr >> 6));
                this.m_buffer[fill2++] = (byte)(128 + (chr & 0x3F));
                continue;
            }
            this.m_buffer[fill2++] = (byte)chr;
        }
        this.m_fillOffset = this.writeEntity(this.m_cdataEndBytes, fill2);
    }

    @Override
    public IXMLWriter createChildWriter(String[] uris) throws IOException {
        this.flagContent();
        return new UTF8StreamWriter(this, uris);
    }
}

