/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.GrowableStringArray;
import org.jibx.runtime.impl.IXMLReaderFactory;

public abstract class RuntimeSupport {
    public static String[] splitClassNames(String blob) {
        if (blob == null || blob.length() == 0) {
            return Utility.EMPTY_STRING_ARRAY;
        }
        GrowableStringArray names = new GrowableStringArray();
        String last2 = "";
        int split2 = -1;
        int index2 = 0;
        StringBuffer buff = new StringBuffer();
        while (split2 < blob.length()) {
            int base = split2 + 1;
            if ((split2 = blob.indexOf(124, base)) < 0) {
                split2 = blob.length();
            }
            if (split2 > base) {
                char chr;
                int mark = 0;
                while (base < split2) {
                    chr = blob.charAt(base);
                    if (chr == '.') {
                        mark = last2.indexOf(46, mark) + 1;
                    } else {
                        if (chr != '$') break;
                        mark = last2.indexOf(36, mark) + 1;
                    }
                    ++base;
                }
                buff.setLength(0);
                if (base == split2) {
                    if (mark < last2.length()) {
                        while (++mark < last2.length() && (chr = last2.charAt(mark)) != '.' && chr != '$') {
                        }
                    }
                    buff.append(last2.substring(0, mark));
                } else {
                    if (mark > 0) {
                        buff.append(last2.substring(0, mark));
                    }
                    buff.append(blob.substring(base, split2));
                }
                last2 = buff.toString().intern();
                names.add(last2);
            } else {
                names.add(null);
            }
            ++index2;
        }
        return names.toArray();
    }

    public static String[] expandNamespaces(String blob, String[] uris) {
        if (blob == null || blob.length() == 0) {
            return Utility.EMPTY_STRING_ARRAY;
        }
        String[] nameuris = new String[blob.length()];
        for (int i = 0; i < blob.length(); ++i) {
            int index2 = blob.charAt(i) - 2;
            if (index2 < 0) continue;
            nameuris[i] = uris[index2];
        }
        return nameuris;
    }

    public static String[] splitNames(String blob) {
        if (blob == null || blob.length() == 0) {
            return Utility.EMPTY_STRING_ARRAY;
        }
        GrowableStringArray names = new GrowableStringArray();
        int split2 = -1;
        int index2 = 0;
        while (split2 < blob.length()) {
            int base = split2 + 1;
            if ((split2 = blob.indexOf(124, base)) < 0) {
                split2 = blob.length();
            }
            if (split2 > base) {
                names.add(blob.substring(base, split2));
            } else {
                names.add(null);
            }
            ++index2;
        }
        return names.toArray();
    }

    public static int[] splitInts(String blob) {
        int[] indexes = new int[blob.length()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = blob.charAt(i) - '\u0001';
        }
        return indexes;
    }

    public static IXMLReaderFactory createReaderFactory(String cname) {
        Class<?> clas = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                clas = loader.loadClass(cname);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clas == null) {
            try {
                loader = IUnmarshallingContext.class.getClassLoader();
                clas = loader.loadClass(cname);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to specified parser factory class " + cname);
            }
        }
        if (!IXMLReaderFactory.class.isAssignableFrom(clas)) {
            throw new RuntimeException("Specified parser factory class " + cname + " does not implement IXMLReaderFactory interface");
        }
        try {
            Method meth = clas.getMethod("getInstance", null);
            return (IXMLReaderFactory)meth.invoke(null, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Specified parser factory class " + cname + " does not define static getInstance() method");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error on parser factory class " + cname + " getInstance() method call: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error on parser factory class " + cname + " getInstance() method call: " + e.getMessage());
        }
    }

    public static IXMLReaderFactory loadFactory() {
        String prop = null;
        try {
            prop = System.getProperty("org.jibx.runtime.impl.parser");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (prop == null) {
            IXMLReaderFactory fact = null;
            try {
                fact = RuntimeSupport.createReaderFactory("org.jibx.runtime.impl.XMLPullReaderFactory");
            }
            catch (Throwable e) {
                try {
                    fact = RuntimeSupport.createReaderFactory("org.jibx.runtime.impl.StAXReaderFactory");
                }
                catch (Throwable e1) {
                    throw new RuntimeException("Unable to load either XMLPull or StAX parser - check classpath for interface and implementation jars\nXMLPull error " + e.getClass().getName() + ": " + e.getMessage() + "\nStAX error " + e1.getClass().getName() + ": " + e1.getMessage());
                }
            }
            return fact;
        }
        return RuntimeSupport.createReaderFactory(prop);
    }
}

