/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.StreamWriterBase;

public class ISO88591StreamWriter
extends StreamWriterBase {
    public ISO88591StreamWriter(String[] uris) {
        super("ISO-8859-1", uris);
        try {
            this.defineNamespace(0, "");
            this.defineNamespace(1, "xml");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public ISO88591StreamWriter(ISO88591StreamWriter base, String[] uris) {
        super(base, uris);
        this.m_prefixBytes = new byte[uris.length][];
        try {
            this.defineNamespace(0, "");
            this.defineNamespace(1, "xml");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    protected void writeMarkup(String text2) throws IOException {
        int length = text2.length();
        this.makeSpace(length);
        int fill2 = this.m_fillOffset;
        for (int i = 0; i < length; ++i) {
            char chr = text2.charAt(i);
            if (chr > '\u00ff') {
                throw new IOException("Unable to write character code 0x" + Integer.toHexString(chr) + " in encoding ISO-8859-1");
            }
            this.m_buffer[fill2++] = (byte)chr;
        }
        this.m_fillOffset = fill2;
    }

    @Override
    protected void writeMarkup(char chr) throws IOException {
        this.makeSpace(1);
        if (chr > '\u00ff') {
            throw new IOException("Unable to write character code 0x" + Integer.toHexString(chr) + " in encoding ISO-8859-1");
        }
        this.m_buffer[this.m_fillOffset++] = (byte)chr;
    }

    @Override
    protected void defineNamespace(int index2, String prefix) throws IOException {
        int i;
        byte[] buff;
        if (prefix.length() > 0) {
            buff = new byte[prefix.length() + 1];
            for (i = 0; i < buff.length - 1; ++i) {
                char chr = prefix.charAt(i);
                if (chr > '\u00ff') {
                    throw new IOException("Unable to write character code 0x" + Integer.toHexString(chr) + " in encoding ISO-8859-1");
                }
                buff[i] = (byte)chr;
            }
            buff[buff.length - 1] = 58;
        } else {
            buff = new byte[]{};
        }
        if (index2 < this.m_prefixBytes.length) {
            this.m_prefixBytes[index2] = buff;
        } else if (this.m_extensionBytes != null) {
            index2 -= this.m_prefixBytes.length;
            for (i = 0; i < this.m_extensionBytes.length; ++i) {
                int length = this.m_extensionBytes[i].length;
                if (index2 < length) {
                    this.m_extensionBytes[i][index2] = buff;
                    continue;
                }
                index2 -= length;
            }
        } else {
            throw new IllegalArgumentException("Index out of range");
        }
    }

    @Override
    protected void writeAttributeText(String text2) throws IOException {
        int length = text2.length();
        this.makeSpace(length * 6);
        int fill2 = this.m_fillOffset;
        for (int i = 0; i < length; ++i) {
            char chr = text2.charAt(i);
            if (chr == '\"') {
                fill2 = this.writeEntity(this.m_quotEntityBytes, fill2);
                continue;
            }
            if (chr == '&') {
                fill2 = this.writeEntity(this.m_ampEntityBytes, fill2);
                continue;
            }
            if (chr == '<') {
                fill2 = this.writeEntity(this.m_ltEntityBytes, fill2);
                continue;
            }
            if (chr == '>' && i > 2 && text2.charAt(i - 1) == ']' && text2.charAt(i - 2) == ']') {
                this.m_buffer[fill2++] = 93;
                this.m_buffer[fill2++] = 93;
                fill2 = this.writeEntity(this.m_gtEntityBytes, fill2);
                continue;
            }
            if (chr < ' ') {
                if (chr != '\t' && chr != '\n' && chr != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in attribute value text");
                }
                this.m_buffer[fill2++] = (byte)chr;
                continue;
            }
            if (chr > '\u00ff') {
                if (chr > '\ud7ff' && (chr < '\ue000' || chr == '\ufffe' || chr == '\uffff' || chr > '\u10ffff')) {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in attribute value text");
                }
                this.m_fillOffset = fill2;
                this.makeSpace(length - i + 8);
                fill2 = this.m_fillOffset;
                this.m_buffer[fill2++] = 38;
                this.m_buffer[fill2++] = 35;
                this.m_buffer[fill2++] = 120;
                for (int j = 12; j >= 0; j -= 4) {
                    int nib = chr >> j & 0xF;
                    this.m_buffer[fill2++] = nib < 10 ? (byte)(48 + nib) : (byte)(65 + nib);
                }
                this.m_buffer[fill2++] = 59;
                continue;
            }
            this.m_buffer[fill2++] = (byte)chr;
        }
        this.m_fillOffset = fill2;
    }

    @Override
    public void writeTextContent(String text2) throws IOException {
        this.flagTextContent();
        int length = text2.length();
        this.makeSpace(length * 5);
        int fill2 = this.m_fillOffset;
        for (int i = 0; i < length; ++i) {
            char chr = text2.charAt(i);
            if (chr == '&') {
                fill2 = this.writeEntity(this.m_ampEntityBytes, fill2);
                continue;
            }
            if (chr == '<') {
                fill2 = this.writeEntity(this.m_ltEntityBytes, fill2);
                continue;
            }
            if (chr == '>' && i > 2 && text2.charAt(i - 1) == ']' && text2.charAt(i - 2) == ']') {
                fill2 = this.writeEntity(this.m_gtEntityBytes, fill2);
                continue;
            }
            if (chr < ' ') {
                if (chr != '\t' && chr != '\n' && chr != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in content text");
                }
                this.m_buffer[fill2++] = (byte)chr;
                continue;
            }
            if (chr > '\u00ff') {
                if (chr > '\ud7ff' && (chr < '\ue000' || chr == '\ufffe' || chr == '\uffff' || chr > '\u10ffff')) {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in character data text");
                }
                this.m_fillOffset = fill2;
                this.makeSpace(length - i + 8);
                fill2 = this.m_fillOffset;
                this.m_buffer[fill2++] = 38;
                this.m_buffer[fill2++] = 35;
                this.m_buffer[fill2++] = 120;
                for (int j = 12; j >= 0; j -= 4) {
                    int nib = chr >> j & 0xF;
                    this.m_buffer[fill2++] = nib < 10 ? (byte)(48 + nib) : (byte)(65 + nib);
                }
                this.m_buffer[fill2++] = 59;
                continue;
            }
            this.m_buffer[fill2++] = (byte)chr;
        }
        this.m_fillOffset = fill2;
    }

    @Override
    public void writeCData(String text2) throws IOException {
        this.flagTextContent();
        int length = text2.length();
        this.makeSpace(length + 12);
        int fill2 = this.m_fillOffset;
        fill2 = this.writeEntity(this.m_cdataStartBytes, fill2);
        for (int i = 0; i < length; ++i) {
            char chr = text2.charAt(i);
            if (chr == '>' && i > 2 && text2.charAt(i - 1) == ']' && text2.charAt(i - 2) == ']') {
                throw new IOException("Sequence \"]]>\" is not allowed within CDATA section text");
            }
            if (chr < ' ') {
                if (chr != '\t' && chr != '\n' && chr != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in content text");
                }
                this.m_buffer[fill2++] = (byte)chr;
                continue;
            }
            if (chr > '\u00ff') {
                throw new IOException("Character code 0x" + Integer.toHexString(chr) + " not allowed by encoding in CDATA section text");
            }
            this.m_buffer[fill2++] = (byte)chr;
        }
        this.m_fillOffset = this.writeEntity(this.m_cdataEndBytes, fill2);
    }

    @Override
    public IXMLWriter createChildWriter(String[] uris) throws IOException {
        this.flagContent();
        return new ISO88591StreamWriter(this, uris);
    }
}

