/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import java.lang.reflect.Array;

public class IntStack {
    public static final int DEFAULT_SIZE = 8;
    protected int m_countLimit;
    protected int m_countPresent;
    protected int m_maximumGrowth;
    protected int[] m_baseArray;

    public IntStack(int size2, int growth) {
        this.m_countLimit = size2;
        this.m_maximumGrowth = growth;
        this.m_baseArray = new int[size2];
    }

    public IntStack(int size2) {
        this(size2, Integer.MAX_VALUE);
    }

    public IntStack() {
        this(8);
    }

    public IntStack(IntStack base) {
        this(base.m_countLimit, base.m_maximumGrowth);
        System.arraycopy(base.m_baseArray, 0, this.m_baseArray, 0, base.m_countPresent);
        this.m_countPresent = base.m_countPresent;
    }

    public IntStack(int[] ints) {
        this(ints.length);
        System.arraycopy(ints, 0, this.m_baseArray, 0, ints.length);
        this.m_countPresent = ints.length;
    }

    private void resizeCopy(Object base, Object grown) {
        System.arraycopy(base, 0, grown, 0, Array.getLength(base));
    }

    private void growArray(int required) {
        int size2 = Math.max(required, this.m_countLimit + Math.min(this.m_countLimit, this.m_maximumGrowth));
        int[] grown = new int[size2];
        this.resizeCopy(this.m_baseArray, grown);
        this.m_countLimit = size2;
        this.m_baseArray = grown;
    }

    public final void ensureCapacity(int min2) {
        if (min2 > this.m_countLimit) {
            this.growArray(min2);
        }
    }

    public void push(int value2) {
        int index2 = this.getAddIndex();
        this.m_baseArray[index2] = value2;
    }

    public int pop() {
        if (this.m_countPresent > 0) {
            return this.m_baseArray[--this.m_countPresent];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to pop empty stack");
    }

    public int pop(int count2) {
        if (count2 <= 0) {
            throw new IllegalArgumentException("Count must be greater than 0");
        }
        if (this.m_countPresent >= count2) {
            this.m_countPresent -= count2;
            return this.m_baseArray[this.m_countPresent];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to pop past end of stack");
    }

    public int peek(int depth) {
        if (this.m_countPresent > depth) {
            return this.m_baseArray[this.m_countPresent - depth - 1];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to peek past end of stack");
    }

    public int peek() {
        return this.peek(0);
    }

    public int[] toArray() {
        int[] copy = new int[this.m_countPresent];
        System.arraycopy(this.m_baseArray, 0, copy, 0, this.m_countPresent);
        return copy;
    }

    public Object clone() {
        return new IntStack(this);
    }

    private int getAddIndex() {
        int index2 = this.m_countPresent++;
        if (this.m_countPresent > this.m_countLimit) {
            this.growArray(this.m_countPresent);
        }
        return index2;
    }

    public int size() {
        return this.m_countPresent;
    }

    public boolean isEmpty() {
        return this.m_countPresent == 0;
    }

    public void clear() {
        this.m_countPresent = 0;
    }
}

