/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.io.File;
import org.jibx.extras.TestRoundtrip;

public class TestMultRoundtrip {
    public static void main(String[] args) {
        if (args.length == 3 || args.length > 0 && args.length % 4 == 0) {
            File temp = new File("temp.xml");
            if (temp.exists()) {
                temp.delete();
            }
            boolean err2 = false;
            String fin = null;
            String fout = null;
            for (int base = 0; base < args.length; base += 4) {
                fin = args[base + 2];
                fout = args.length < base + 4 ? fin : args[base + 3];
                try {
                    if (!TestRoundtrip.runTest(args[base], args[base + 1], fin, fout)) {
                        err2 = true;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    err2 = true;
                }
                if (!err2) continue;
                System.err.println("Error round-tripping class: " + args[base] + "\n with input file " + fin + " and output compared to " + fout);
                System.err.println("Saved output document file path " + temp.getAbsolutePath());
                System.exit(1);
            }
        } else {
            System.err.println("Usage: java TestMultRoundtrip mapped-class binding-name in-file [out-file]\n where out-file is only required if the output document is different from\nthe input document. Leaves output as temp.xml in case of error");
            System.exit(1);
        }
    }
}

